Name: apt-scripts
Version: 0.1.4
Release: alt1.M80P.1

Summary: Lua scripts for APT
License: GPL-2.0-or-later
Group: System/Configuration/Packaging

Source0: %name-%version.tar.gz

BuildRequires: apt
BuildArch: noarch

%description
apt-cache list-extras
	This script will list all installed packages which are
	not availabe in any online repository.
apt-cache list-nodeps
	This script will list all installed packages which are
	not required by any other installed package.
apt-cache list-unreleased
	This script will list all installed packages which have
	version newer than in repository.
apt-get dedup
	This script will collect all unallowed duplicated pkgs and remove the
	eldest, keeping the newest.

%prep
%setup -q

%install
for f in *.lua; do install -pD -m755 $f %buildroot/usr/share/apt/scripts/$f; done
for f in *.conf; do install -pD -m644 $f %buildroot/etc/apt/apt.conf.d/$f; done

cat *.conf >.apt.conf
apt-cache -c .apt.conf -o Dir::Bin::scripts=%buildroot/usr/share/apt/scripts list-extras
apt-cache -c .apt.conf -o Dir::Bin::scripts=%buildroot/usr/share/apt/scripts list-nodeps
apt-cache -c .apt.conf -o Dir::Bin::scripts=%buildroot/usr/share/apt/scripts list-unreleased
apt-cache -c .apt.conf script ./list-extras.lua
apt-cache -c .apt.conf script ./list-nodeps.lua
apt-cache -c .apt.conf script ./list-unreleased.lua

mkdir -p %buildroot/etc/buildreqs/files/ignore.d
ls *.conf |sed 's:^:^/etc/apt/apt.conf.d/:;s:[.]:[.]:g' >%buildroot/etc/buildreqs/files/ignore.d/%name

%files
/usr/share/apt
%config /etc/apt/apt.conf.d/*
%config /etc/buildreqs/files/ignore.d/%name

%changelog
