Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-java
# END SourceDeps(oneline)
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
Name:           args4j
Version:        2.32
Release:        alt1_2jpp8
Summary:        Java command line arguments parser
License:        MIT
URL:            http://args4j.kohsuke.org
Source0:        https://github.com/kohsuke/%{name}/archive/%{name}-site-%{version}.tar.gz

BuildArch:      noarch

BuildRequires:  maven-local
BuildRequires:  mvn(com.sun:tools)
BuildRequires:  mvn(junit:junit)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires:  mvn(org.apache.maven.plugins:maven-site-plugin)
BuildRequires:  mvn(org.kohsuke:pom:pom:)
BuildRequires:  mvn(org.mockito:mockito-all)
Source44: import.info

%description
args4j is a small Java class library that makes it easy
to parse command line options/arguments in your CUI application.
- It makes the command line parsing very easy by using annotations
- You can generate the usage screen very easily
- You can generate HTML/XML that lists all options for your documentation
- Fully supports localization
- It is designed to parse javac like options (as opposed to GNU-style
  where ls -lR is considered to have two options l and R)

%package tools
Group: Development/Java
Summary:        Development-time tool for generating additional artifacits

%description tools
This package contains args4j development-time tool for generating
additional artifacits.

%package parent
Group: Development/Java
Summary:        args4j parent POM

%description parent
This package contains parent POM for args4j project.

%package javadoc
Group: Development/Java
Summary:        API documentation for %{name}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q -n %{name}-%{name}-site-%{version}

# removing classpath addition
sed -i 's/<addClasspath>true/<addClasspath>false/g' %{name}-tools/pom.xml

# fix ant group id
sed -i 's/<groupId>ant/<groupId>org.apache.ant/g' %{name}-tools/pom.xml

# removing bundled stuff
find -name '*.class' -exec rm -f '{}' \;
find -name '*.jar' -exec rm -f '{}' \;

%pom_remove_plugin :maven-shade-plugin %{name}-tools

# XMvn cannot generate requires on dependecies with scope "system"
%pom_xpath_remove "pom:profile[pom:id[text()='jdk-tools-jar']]" %{name}-tools
%pom_add_dep com.sun:tools %{name}-tools

# we don't need these now
%pom_disable_module args4j-maven-plugin
%pom_disable_module args4j-maven-plugin-example

# put args4j-tools and parent POM to separate subpackages
%mvn_package :args4j-tools::{}: %{name}-tools
%mvn_package :args4j-site::{}: %{name}-parent

# install also compat symlinks
%mvn_file ":{*}" %{name}/@1 @1

%build
%mvn_build

%install
%mvn_install

%files -f .mfiles
%dir %{_javadir}/%{name}
%doc %{name}/LICENSE.txt

%files tools -f .mfiles-%{name}-tools

%files parent -f .mfiles-%{name}-parent
%doc %{name}/LICENSE.txt

%files javadoc -f .mfiles-javadoc
%doc %{name}/LICENSE.txt

%changelog
