%def_disable static
%if_enabled static
%define buildstatic 0
%else
%define buildstatic 0
%endif

Name: arts
Version: 1.5.10
Release: alt6
Serial: 1

Source: %name-%version.tar

# RH
Patch1: arts-1.1.4-debug.patch
Patch2: arts-1.5.0-check_tmp_dir.patch
Patch3: arts-1.3.1-alsa.patch
Patch4: arts-acinclude.patch
Patch5: libltdl-CVE-2009-3736.patch

# SuSE
Patch22: arts-vorbis-fix.dif

# MDK
Patch31: arts-1.1.4-64bit-fixes.patch
Patch32: arts-1.1.4-lib64.patch

# ALT
Patch100: arts-1.0.1-mcop_home.patch
Patch101: arts-1.0.2-tmpdir.patch
Patch102: arts-1.5.6-flags.patch
Patch103: arts-1.1.4-no_ltdl.patch
Patch104: arts-1.3.92-la2so.patch
Patch105: arts-1.2.3-glib-ldflags.patch
Patch106: arts-1.2.3-detect-esd.patch
Patch107: arts-1.5.10-alt-automake.patch
Patch108: arts-1.5.10-mcopclass-la-replace-so.patch

Group: System/Servers
Summary: aRts (analog realtime synthesizer) - the KDE sound system
License: ARTISTIC BSD GPL_V2 LGPL_V2 QPL_V1.0

Requires: lib%name = %serial:%version-%release
##Conflicts: lib%name-devel-static < %serial:%version-%release
##Conflicts: kdemultimedia-arts <= 3.1.4-alt2 kdemultimedia-noatun <= 3.1.4-alt2

# Automatically added by buildreq on Thu Apr 08 2004 (-bi)
BuildRequires: cmake kde-common-devel gcc-c++ libtqt-devel
BuildRequires: glib2-devel libalsa-devel libltdl7-devel
BuildRequires: libjpeg-devel libmad-devel libpng-devel
BuildRequires: libstdc++-devel pkgconfig zlib-devel
BuildRequires: jackit-devel libaudiofile-devel libmad-devel
BuildRequires: libogg-devel libvorbis-devel
BuildRequires: libqt3-devel > 3.0
# hack against apt
#BuildRequires: libqt3-qsa > 3.0 libqt3-qsa-devel > 3.0

Packager: Sergey V Turchin <zerg@altlinux.org>

%description
aRts is a short form for "analog realtime synthesizer". The idea of the whole
thing is to create/process sound using small modules which do certain tasks.
These may be create a waveform (oscillators), play samples, filter data, add
signals, perform effects like delay/flanger/chorus, or output the data to the
soundcard.

%package -n lib%name
Group: Graphical desktop/KDE
Summary: The libraries for arts

%description -n lib%name
Libraries needed for arts.

%package -n lib%name-devel
Group: Development/C++
Summary: Development files for arts
Requires: lib%name = %serial:%version-%release libalsa-devel
Requires: jackit-devel libaudiofile-devel libmad-devel
Requires: libogg-devel libvorbis-devel
Requires: glib2-devel libalsa-devel libpng-devel
#
%description -n lib%name-devel
Development files for arts.

%package -n lib%name-devel-static
Group: Development/KDE and QT
Summary: Static libraries for arts
Requires: lib%name-devel = %serial:%version-%release
#
%description -n lib%name-devel-static
Static libraries for arts.

%package -n lib%name-qtmcop
Group: Graphical desktop/KDE
Summary: Qt specific arts sound stuff
Requires: lib%name = %serial:%version-%release
Requires: %{get_dep libqt3}
Provides: lib%name-qt = %serial:%version-%release
Obsoletes: lib%name-qt <= %serial:%version-%release
#
%description -n lib%name-qtmcop
Libraries for sound support for Qt library

%package -n lib%name-qtmcop-devel
Group: Development/KDE and QT
Summary: Development files for arts and Qt
Requires: lib%name = %serial:%version-%release
Requires: lib%name-devel = %serial:%version-%release
Requires: lib%name-qt = %serial:%version-%release
Requires: libqt3-devel
Provides: lib%name-qt-devel = %serial:%version-%release
Obsoletes: lib%name-qt-devel <= %serial:%version-%release
#
%description -n lib%name-qtmcop-devel
Development files for sound support for Qt library

%package -n lib%name-qtmcop-devel-static
Group: Development/KDE and QT
Summary: Static libraries for development with arts and Qt
Requires: lib%name-qt-devel = %serial:%version-%release
#Requires: libqt3-devel-static
Provides: lib%name-qt-devel-static = %serial:%version-%release
Obsoletes: lib%name-qt-devel-static <= %serial:%version-%release
#
%description -n lib%name-qtmcop-devel-static
Static libraries for sound support for Qt library

%package -n lib%name-gmcop
Group: System/Libraries
Summary: Glib specific art sound stuff
Requires: lib%name = %serial:%version-%release
#
%description -n lib%name-gmcop
Libraries for sound support for Glib library

%package -n lib%name-gmcop-devel
Group: Development/C++
Summary: Development files for arts and Glib
Requires: lib%name = %serial:%version-%release lib%name-gmcop = %serial:%version-%release
#
%description -n lib%name-gmcop-devel
Development files for sound support for Glib library

%package -n lib%name-gmcop-devel-static
Group: Development/C++
Summary: Static libraries for development with arts and Glib
Requires: lib%name-gmcop-devel = %serial:%version-%release
Requires: glib2-devel-static
#
%description -n lib%name-gmcop-devel-static
Static libraries for sound support for Glib library


%prep
%setup -q -n %name-%version
%patch1 -p1
#%patch2 -p1
%patch3 -p1
#%patch4 -p1
%patch5 -p1
#
#%patch22 -p0
#
%patch31 -p1
#%patch32 -p1
#
#%patch100 -p1
#%patch101 -p1
#%patch102 -p1
#%patch103 -p1
#%patch104 -p1
#%patch105 -p1
#%patch106 -p1
#%patch107 -p1
%patch108 -p1

%build
BD=%_builddir/%name-%version/BUILD
export LD_LIBRARY_PATH=$BD/mcop:$LD_LIBRARY_PATH

%K3cmake -DCMAKE_BUILD_TYPE=RelWithDebInfo \
    -DBIN_INSTALL_DIR=%_bindir \
    -DCMAKE_INSTALL_PREFIX=%_prefix \
    -DBUILD_ALL="ON" \
    -DCMAKE_SKIP_RPATH="OFF" \
    -DWITH_GCC_VISIBILITY="ON" \
    -DINCLUDE_INSTALL_DIR:INTERNAL=%_K3includedir/%name
%K3make

%install
%K3install

mv %buildroot/%_includedir/artsc %buildroot/%_K3includedir/

%files
%_bindir/artscat
%_bindir/artsd*
%_bindir/artsp*
%_bindir/artss*
%_bindir/artsw*
%_bindir/artsr*
#%_bindir/testdhandle

%files -n libarts
%_libdir/libartsc.so*
%_libdir/libartscbackend.so*
%_libdir/libartsdsp.so*
%_libdir/libartsdsp_st.so*
%_libdir/libartsgsl.a
%_libdir/libartsflow.so*
%_libdir/libartsflow_idl.so*
%_libdir/libartswavplayobject.so*
%_libdir/libartsgslplayobject.so*
%_libdir/libkmedia2.so*
%_libdir/libkmedia2_idl.so*
%_libdir/libsoundserver_idl.so*
%_libdir/libmcop.so*
%_libdir/libmcop_mt.so*
#_libdir/libx11globalcomm.so*
#
%dir %_libdir/mcop/
%_libdir/mcop/*.mcopclass
%_libdir/mcop/*.mcoptype
#
%dir %_libdir/mcop/Arts
%_libdir/mcop/Arts/*.mcopclass

%files -n libarts-devel
%_bindir/artsc-config
%_bindir/mcopidl
#
%dir %_K3includedir/arts/
%_K3includedir/arts/gsl
%_K3includedir/arts/*.h
%exclude %_K3includedir/arts/*?iomanager.h
%_pkgconfigdir/%name.pc
#
%_K3includedir/arts/*.idl
#
%dir %_K3includedir/artsc/
%_K3includedir/artsc/*.h
#

%files -n lib%name-qtmcop
%_libdir/libqtmcop.so*
%files -n lib%name-qtmcop-devel
%_K3includedir/arts/qiomanager.h

%files -n lib%name-gmcop
%_libdir/libgmcop.so*
%files -n lib%name-gmcop-devel
%_K3includedir/arts/giomanager.h

%if %buildstatic
%files -n libarts-devel-static
%_libdir/libartsc.a
%_libdir/libartscbackend.a
%_libdir/libartsdsp.a
%_libdir/libartsdsp_st.a
%_libdir/libartsflow.a
%_libdir/libartsflow_idl.a
%_libdir/libartswavplayobject.a
%_libdir/libartsgslplayobject.a
%_libdir/libkmedia2.a
%_libdir/libkmedia2_idl.a
%_libdir/libsoundserver_idl.a
%_libdir/libmcop.a
%_libdir/libmcop_mt.a
#_libdir/libx11globalcomm.a
%files -n lib%name-qtmcop-devel-static
%_libdir/libqtmcop.a
%files -n lib%name-gmcop-devel-static
%_libdir/libgmcop.a
%endif

%changelog
