%define glib2_version 1.0
%define _libexecdir %_prefix/libexec
%define apiversion 1.5.0
%define _name atril

%def_disable introspection
%def_disable libs_subpackage
%def_disable dbus

# it uses webkit
%def_disable epub

Name:           %_name-gtk
Version:        1.16.1
Release:        alt1
Summary:        Document viewer

License:        GPLv2+ and GFDL
Group:          Publishing
URL:            http://pub.mate-desktop.org
Source0:        %name-%version.tar
Patch:          %_name-%version-%release.patch

BuildRequires:  gtk2-devel
BuildRequires:  glib2-devel
BuildRequires:  libpoppler-glib-devel
BuildRequires:  libXt-devel
#BuildRequires:  mate-keyring-devel
BuildRequires:  libglade2-devel
BuildRequires:  libtiffxx-devel libtiff-devel
BuildRequires:  libjpeg-devel
BuildRequires:  libspectre-devel
BuildRequires:  gettext
BuildRequires:  desktop-file-utils
BuildRequires:  libtool
BuildRequires:  intltool
BuildRequires:  t1lib-devel
BuildRequires:  yelp-tools
%{?_enable_introspection:BuildRequires:  gobject-introspection-devel}
%{?_enable_epub:BuildRequires: libwebkitgtk2-devel}

BuildRequires:  mate-common
BuildRequires:  libcairo-gobject-devel
BuildRequires: /usr/bin/glib-genmarshal /usr/bin/glib-gettextize /usr/bin/glib-mkenums /usr/bin/gtkdocize gcc-c++ libICE-devel libgdk-pixbuf-gir-devel libgio-devel libgtk+2-gir-devel pkgconfig(cairo) pkgconfig(cairo-pdf) pkgconfig(cairo-ps) pkgconfig(gail) pkgconfig(gail-3.0) pkgconfig(gio-2.0) pkgconfig(gtk+-2.0) pkgconfig(gtk+-3.0) pkgconfig(gtk+-unix-print-2.0) pkgconfig(gtk+-unix-print-3.0) pkgconfig(gtk+-x11-2.0) pkgconfig(gtk+-x11-3.0) pkgconfig(libgxps) pkgconfig(libxml-2.0) pkgconfig(sm) pkgconfig(x11) zlib-devel

# for the caja properties page
#BuildRequires: mate-file-manager-devel
# for the dvi backend
BuildRequires: libkpathsea-devel
# for the djvu backend
BuildRequires: libdjvu-devel

%if_enabled libs_subpackage
Requires: lib%{name} = %{version}-%{release}
%else
Provides: lib%{name} = %{version}-%{release}
Obsoletes: lib%{name} < %{version}-%{release}
Conflicts: mate-document-viewer-libs

%add_findprov_skiplist %_libdir/*
%filter_from_requires /^\(debug\(64\)\?(\)\?libatril\(document\|view\)\.so\.[[:digit:]]/d
%endif

Conflicts: mate-document-viewer

%define _unpackaged_files_terminate_build 1

%description
Atril is simple multi-page document viewer. It can display and print
Portable Document Format (PDF), PostScript (PS) and Encapsulated
PostScript (EPS) files. When supported by the document format, atril
allows searching for text, copying text to the clipboard, hypertext
navigation, table-of-contents bookmarks and editing of forms.

Support for other document formats such as DVI and DJVU can be added by
installing additional backends.

(version without MATE-specific)

%package -n lib%name
Summary: Libraries for the atril document viewer
Group: System/Libraries
Conflicts: mate-document-viewer-libs

%description -n lib%name
This package contains shared libraries needed for atril


%package -n lib%name-devel
Summary: Support for developing backends for the atril document viewer
Group: Development/C
Requires: lib%name = %{version}-%{release}
Conflicts: mate-document-viewer-devel

%description -n lib%name-devel
This package contains libraries and header files needed for atril
backend development.


%package dvi
Summary: Atril backend for dvi files
Group: Publishing
Requires: %name = %{version}-%{release}
Conflicts: mate-document-viewer-devel

%description dvi
This package contains a backend to let atril display dvi files.


%package djvu
Summary: Atril backend for djvu files
Group: Publishing
Requires: %name = %{version}-%{release}
Conflicts: mate-document-viewer-djvu

%description djvu
This package contains a backend to let atril display djvu files.

%package pixbuf
Summary: Atril backend for graphics files
Group: Publishing
Requires: %name = %{version}-%{release}
Conflicts: mate-document-viewer-pixbuf

%description pixbuf
This package contains a backend to let atril display graphics files.

%package xps
Summary: Atril backend for xps files
Group: Publishing
Requires: %name = %{version}-%{release}
Conflicts: mate-document-viewer-xps

%description xps
This package contains a backend to let atril display xps files.

%package epub
Summary: Atril backend for ePub documents
Group: Publishing
Requires: %name = %{version}-%{release}
Conflicts: mate-document-viewer-djvu

%description epub
This package contains a backend to let atril display ePub documents.

%prep
%setup
%patch -p1

%build
NOCONFIGURE=1 ./autogen.sh
%configure \
	--disable-static \
	--disable-scrollkeeper \
	--enable-comics \
	--enable-dvi=yes \
	--enable-djvu=yes \
	--enable-t1lib=yes \
	--enable-pixbuf=yes \
	--enable-xps=yes \
	%{subst_enable epub} \
	--with-gtk=2.0 \
	%{subst_enable introspection} \
	--without-keyring \
	--disable-caja \
	--without-matedesktop \
	%{subst_enable dbus} \
	--disable-gtk-doc

%make_build V=1 LIBTOOL=/usr/bin/libtool

%install
%makeinstall_std

%find_lang %_name

mkdir -p %buildroot%{_datadir}/applications
/bin/rm -rf %buildroot/var/scrollkeeper
# Get rid of static libs and .la files.
rm -f %buildroot%{_libdir}/atril/3/backends/*.la
rm -f %buildroot%{_libdir}/atril/3/backends/*.a
rm -f %buildroot%{_libdir}/*.la
rm -f %buildroot%{_libdir}/*.a

# don't ship icon caches
rm -f %buildroot%{_datadir}/icons/hicolor/icon-theme.cache

%files -f %_name.lang
%{_bindir}/*
%{_datadir}/atril/
%_desktopdir/%_name.desktop
%{_datadir}/icons/hicolor/*/apps/atril.*
%{_mandir}/man1/atril*.1.*
%{_libexecdir}/atril-convert-metadata
%if_enabled dbus
%{_libexecdir}/atrild
%{_datadir}/dbus-1/services/org.mate.atril.Daemon.service
%endif
%{_datadir}/glib-2.0/schemas/org.mate.Atril.gschema.xml
%{_datadir}/thumbnailers/atril.thumbnailer
%{_datadir}/help/*/*

# don't package appdata file:
# for atril-gtk there should be changed description at least
%exclude %_datadir/appdata/atril.appdata.xml

%if_enabled libs_subpackage
%files -n lib%name
%endif
%doc README COPYING NEWS AUTHORS
%{_libdir}/libatrilview.so.*
%{_libdir}/libatrildocument.so.*
%dir %{_libdir}/atril
%dir %{_libdir}/atril/3
%dir %{_libdir}/atril/3/backends
%{_libdir}/atril/3/backends/libpdfdocument.so
%{_libdir}/atril/3/backends/pdfdocument.atril-backend
%{_libdir}/atril/3/backends/libpsdocument.so
%{_libdir}/atril/3/backends/psdocument.atril-backend
%{_libdir}/atril/3/backends/libtiffdocument.so
%{_libdir}/atril/3/backends/tiffdocument.atril-backend
%{_libdir}/atril/3/backends/libcomicsdocument.so
%{_libdir}/atril/3/backends/comicsdocument.atril-backend
%if_enabled introspection
%{_libdir}/girepository-1.0/AtrilDocument-*.typelib
%{_libdir}/girepository-1.0/AtrilView-*.typelib
%endif

%if_enabled libs_subpackage
%files -n lib%name-devel
%dir %{_includedir}/atril
%{_includedir}/atril/%apiversion
%{_libdir}/libatrilview.so
%{_libdir}/libatrildocument.so
%{_libdir}/pkgconfig/atril-view-*.pc
%{_libdir}/pkgconfig/atril-document-*.pc
%if_enabled introspection
%{_datadir}/gir-1.0/AtrilDocument-*.gir
%{_datadir}/gir-1.0/AtrilView-*.gir
%endif
%else
%exclude %_includedir/atril/
%exclude %_libdir/pkgconfig/atril-*.pc
%exclude %_libdir/libatril*.so
%endif

%files dvi
%{_libdir}/atril/3/backends/libdvidocument.so*
%{_libdir}/atril/3/backends/dvidocument.atril-backend

%files djvu
%{_libdir}/atril/3/backends/libdjvudocument.so
%{_libdir}/atril/3/backends/djvudocument.atril-backend

%files xps
%{_libdir}/atril/3/backends/libxpsdocument.so*
%{_libdir}/atril/3/backends/xpsdocument.atril-backend

%files pixbuf
%{_libdir}/atril/3/backends/libpixbufdocument.so*
%{_libdir}/atril/3/backends/pixbufdocument.atril-backend

%if_enabled epub
%files epub
%{_libdir}/atril/3/backends/libepubdocument.so*
%{_libdir}/atril/3/backends/epubdocument.atril-backend
%{_libdir}/atril/3/backends/epub/
%endif

%changelog
