Name: autofs
Version: 5.1.4
Release: alt0.M80P.1

Summary: A tool for automatically mounting and unmounting filesystems
License: GPL
Group: System/Kernel and hardware
Url: ftp://ftp.kernel.org/pub/linux/daemons/autofs/v4/

Source: %name-%version.tar

Requires(post): %post_service
Requires(preun): %preun_service

BuildRequires(pre): rpm-build-ubt
BuildRequires: bison flex
BuildRequires: libkrb5-devel libldap-devel libsasl2-devel
BuildRequires: libssl-devel libxml2-devel libtirpc-devel >= 1.0.1-alt1
BuildRequires: libsss_autofs

%package ldap
Summary: A tool for automatically mounting and unmounting filesystems
Group: System/Kernel and hardware
Requires: %name = %version-%release 

%package sss
Summary: A tool for automatically mounting and unmounting filesystems
Group: System/Kernel and hardware
Requires: %name = %version-%release

# {{{ descriptions

%description
Autofs controls the operation of the automount daemons.  The automount daemons
automatically mount filesystems when you use them and unmount them after a
period of inactivity.  Filesystems can include network filesystems, CD-ROMs,
floppies and others.

Install this package if you want a program for automatically mounting and
unmounting filesystems.

%description ldap
Autofs controls the operation of the automount daemons.  The automount daemons
automatically mount filesystems when you use them and unmount them after a
period of inactivity.  Filesystems can include network filesystems, CD-ROMs,
floppies and others.

This package adds LDAP support to the %name package

%description sss
Autofs controls the operation of the automount daemons.  The automount daemons
automatically mount filesystems when you use them and unmount them after a
period of inactivity.  Filesystems can include network filesystems, CD-ROMs,
floppies and others.

This package adds SSSD support to the %name package

# }}}

%prep
%setup

%build
%autoreconf
export ac_cv_path_MODPROBE=/sbin/modprobe
export ac_cv_path_MOUNT=/bin/mount
export ac_cv_path_UMOUNT=/bin/umount
export ac_cv_path_MOUNT_NFS=/sbin/mount.nfs
%configure --with-systemd --disable-mount-locking \
	--enable-ignore-busy --enable-sloppy-mount \
	--with-libtirpc
%make_build

%install
%make_install install INSTALLROOT=%buildroot
rm -fv %buildroot%_sysconfdir/auto.{misc,net}
(cd altlinux && find . -type f |cpio -pumd %buildroot)
chmod 0644 samples/auto.*

%define docdir %_defaultdocdir/%name-%version
mkdir -p %buildroot%docdir
rm -fv samples/rc.autofs* samples/autofs.conf.default* samples/autofs.init* \
	samples/autofs.service* samples/Makefile
cp -pr CHANGELOG CREDITS COPYRIGHT README* samples %buildroot%docdir

%post
%post_service %name

%preun
%preun_service %name

%triggerun -- autofs < 5.0.1
[ $2 -gt 0 ] || exit 0
if /sbin/start-stop-daemon --stop --quiet \
    --signal USR2 --retry 5 --exec /usr/sbin/automount; then
/sbin/service autofs start ||:
fi

%files
%dir %docdir
%dir %docdir/samples
%docdir/[A-Z]*
%docdir/samples/auto.master
%docdir/samples/auto.misc
%docdir/samples/auto.net
%docdir/samples/auto.smb

%systemd_unitdir/autofs.service

%config(noreplace) %_initdir/autofs
%config(noreplace) %_sysconfdir/auto.master
%config(noreplace) %_sysconfdir/auto.tab
%config(noreplace) %_sysconfdir/auto.avahi
%config(noreplace,missingok) %_sysconfdir/auto.smb
%config(noreplace) %_sysconfdir/sysconfig/%name
%config(noreplace) %_sysconfdir/autofs.conf

%dir %_libdir/%name
%_libdir/%name/*
%exclude %_libdir/%name/lookup_ldap.so
%exclude %_libdir/%name/lookup_ldaps.so
%exclude %_libdir/%name/lookup_sss.so

%_sbindir/*
%_mandir/man?/*

%files ldap
%docdir/samples/autofs.schema
%docdir/samples/auto.master.ldap
%docdir/samples/ldap-*

%_sysconfdir/autofs_ldap_auth.conf

%_libdir/%name/lookup_ldaps.so
%_libdir/%name/lookup_ldap.so

%files sss
%_libdir/%name/lookup_sss.so

%changelog
