Name: autogen
Version: 5.18.4
Release: alt1.1

Summary: AutoGen - The Automated Program Generator
License: %gpl3plus
Group: Development/Other
Url: http://www.gnu.org/software/autogen/

Source: %name-%version.tar
Patch1: autogen-5.18.4-masquerade-deps.patch

BuildPreReq: rpm-build-licenses rpm-build-compat

BuildPreReq: texi2html guile18-devel libxml2-devel
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
AutoGen is a tool designed to simplify the creation and maintenance
of programs that contain large amounts of repetitious text.
It is especially valuable in programs that have several blocks of text
that must be kept synchronized.

AutoGen can now accept XML files as definition input, in addition to CGI
data (for producing dynamic HTML) and traditional AutoGen definitions.

A common example where this would be useful is in creating and
maintaining the code required for processing program options. Processing
options requires multiple constructs to be maintained in parallel
in different places in your program. Options maintenance needs to be
done countless times. So, AutoGen comes with an add-on package named
AutoOpts that simplifies the maintenance and documentation of program
options.

%package -n libopts
Summary: Command line option parser based on AutoGen
Group: Development/Other
License: %lgpl3plus, %bsd

%description -n libopts
AutoOpts is a very powerful command line option parser consisting of
a set of AutoGen templates and a run time library that nearly eliminates
the hassle of parsing and documenting command line options.
This package allows you to specify several program attributes, up to 100
option types and many attributes for each option.

%package -n libopts-devel
Summary: AutoGen development files and libraries
Group: Development/Other
License: %lgpl3plus, %bsd
Requires: libopts = %version-%release
Obsoletes: autogen-devel = %version-%release
Provides: autogen-devel = %version-%release

%description -n libopts-devel
AutoOpts is a very powerful command line option parser consisting of
a set of AutoGen templates and a run time library that nearly eliminates
the hassle of parsing and documenting command line options. This package
allows you to specify several program attributes, up to 100 option types
and many attributes for each option.

This package is needed to write programs that use AutoOpts API.

%prep
%setup
%patch1 -p1

%build
%autoreconf
%configure \
	--disable-static \
	--with-libguile
%make_build

%install
%makeinstall_std

# Move pkgconfig file to the proper place
mkdir -p %buildroot%_pkgconfigdir/
mv %buildroot%_datadir/pkgconfig/*.pc %buildroot%_pkgconfigdir/

%files
%doc AUTHORS TODO COPYING NEWS THANKS README VERSION
%_bindir/autogen
%_bindir/columns
%_bindir/getdefs
%_bindir/xml2ag
%dir %_datadir/%name
%_datadir/%name/*
%_infodir/%{name}*
%_man1dir/autogen.1*
%_man1dir/columns.1*
%_man1dir/getdefs.1*
%_man1dir/xml2ag.1*

%files -n libopts
%_libdir/libopts.so.*

%files -n libopts-devel
%_bindir/autoopts-config
%dir %_includedir/autoopts
%_includedir/autoopts/*
%_pkgconfigdir/autoopts.pc
%_libdir/*.so
%_datadir/aclocal/autoopts.m4
%_man1dir/autoopts-config.1.*
%_man3dir/*.3.*

%changelog
