%define realname automake
%define dialect _1.10
%define dialect_regex _1\\.10
%define suff -1.10
%define altver 1103
%define apiname %realname%suff

Name: %realname%dialect
Version: 1.10.3
Release: alt4
Epoch: 1

%define mydatadir %_datadir/%apiname
%set_compress_method xz
%define _perl_lib_path %perl_vendor_privlib:%mydatadir
%{?filter_from_requires:%filter_from_requires /^perl(Automake/d}
%{?filter_from_provides:%filter_from_provides /^perl(/d}

Summary: A GNU tool for automatically creating Makefiles
License: GPLv2+ and GFDLv1.3+
Group: Development/Other
Url: http://www.gnu.org/software/automake/
BuildArch: noarch

%define srcname %realname-%version-%release

# git://git.altlinux.org/gears/a/%name.git
Source: %srcname.tar

Provides: %realname = %epoch:%version-%release
Provides: aclocal(libtool)
Obsoletes: %realname
PreReq: automake-common, alternatives >= 0:0.4
Requires: autoconf_2.60

BuildPreReq: autoconf >= 2:2.58, makeinfo

%description
Automake is a tool for automatically generating `Makefile.in'
files compliant with the GNU Coding Standards.

%prep
%setup -n %srcname
xz -k9 NEWS

# patch texinfo file
sed -i \
	-e '/@direntry/,/@end direntry/ s/^\(\*[[:space:]]\+[[:alnum:].-]\+\)\(:[[:space:]]\+\)(%realname)/\1\2(%apiname)/' \
	-e '/^@\(setfilename\|settitle\)[[:space:]]\+%realname/ s//&%suff/' \
	doc/automake.texi

%build
%define docdir %_docdir/%realname-%version
%configure --docdir=%docdir
%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall_std MAKEINFOFLAGS=--no-split

mv %buildroot%_infodir/%realname.info %buildroot%_infodir/%apiname.info

# replace config.* copies with symlinks to original files
for f in %_datadir/gnu-config/config.*; do
	[ -f "$f" ] || continue
	ln -frs %buildroot"$f" %buildroot%mydatadir/"${f##*/}"
done

mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
cat <<EOF >%buildroot%_sysconfdir/buildreqs/files/ignore.d/%name
^/usr/share/aclocal(%dialect_regex)?/.+\.m4$
EOF

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo %realname >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name

mkdir -p %buildroot%_altdir
cat <<EOF >%buildroot%_altdir/%name
%_bindir/%realname-default	%_bindir/%apiname	%altver
%_bindir/aclocal-default	%_bindir/aclocal%suff	%_bindir/%apiname
%_datadir/%realname	%mydatadir	%_bindir/%apiname
%_infodir/%realname.info.xz	%_infodir/%apiname.info.xz	%_bindir/%apiname
EOF

install -pm644 AUTHORS README THANKS NEWS.* \
	%buildroot%docdir/

%check
%make_build -k check

%files
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%config %_sysconfdir/buildreqs/files/ignore.d/*
%_altdir/%name
%_bindir/*%suff
%_datadir/aclocal%suff
%mydatadir/
%_infodir/*.info*
%docdir/

%changelog
