%define realname automake
%define dialect _1.14
%define dialect_regex _1\\.14
%define suff -1.14
%define altver 1141
%define apiname %realname%suff

Name: %realname%dialect
Version: 1.14.1
Release: alt2

%define mydatadir %_datadir/%apiname
%set_compress_method xz
%define _perl_lib_path %perl_vendor_privlib:%mydatadir
%{?filter_from_requires:%filter_from_requires /^perl(\(Automake\|TAP\)/d}
%{?filter_from_provides:%filter_from_provides /^perl(/d}

Summary: A GNU tool for automatically creating Makefiles
License: GPLv2+ and GFDLv1.3+
Group: Development/Other
Url: http://www.gnu.org/software/automake/
BuildArch: noarch

%define srcname %realname-%version-%release

# git://git.altlinux.org/gears/a/%name.git
Source: %srcname.tar

Provides: %realname = 1:%version-%release
Provides: aclocal(libtool)
Obsoletes: %realname
PreReq: automake-common, alternatives >= 0:0.4
Requires: autoconf >= 2:2.65

BuildPreReq: autoconf >= 2:2.65, gnu-config, help2man, makeinfo, perl-threads
BuildPreReq: perl(TAP/Parser.pm)
%{!?__buildreqs:%{!?_without_check:%{!?_disable_check:BuildRequires: dejagnu expect flex gcc-c++ gcc-fortran makedepend}}}

%description
Automake is a tool for automatically generating `Makefile.in'
files compliant with the GNU Coding Standards.

%prep
%setup -n %srcname
xz -k9 NEWS

# patch texinfo file
sed -i \
	-e '/@direntry/,/@end direntry/ s/^\(\*[[:space:]]\+[[:alnum:].-]\+\)\(:[[:space:]]\+\)(%realname)/\1\2(%apiname)/' \
	-e '/^@\(setfilename\|settitle\)[[:space:]]\+%realname/ s//&%suff/' \
	doc/automake.texi

%build
%define docdir %_docdir/%realname-%version
./bootstrap.sh
%configure --docdir=%docdir
%make_build MAKEINFOFLAGS=--no-split

%install
%makeinstall_std MAKEINFOFLAGS=--no-split

# provided by automake-common
rm %buildroot%_aclocaldir/README

# replace config.* copies with symlinks to original files
for f in %_datadir/gnu-config/config.*; do
	[ -f "$f" ] || continue
	ln -frs %buildroot"$f" %buildroot%mydatadir/"${f##*/}"
done

mkdir -p %buildroot%_sysconfdir/buildreqs/files/ignore.d
cat <<EOF >%buildroot%_sysconfdir/buildreqs/files/ignore.d/%name
^/usr/share/aclocal(%dialect_regex)?/.+\.m4$
EOF

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo %realname >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name

mkdir -p %buildroot%_altdir
cat <<EOF >%buildroot%_altdir/%name
%_bindir/%realname-default	%_bindir/%apiname	%altver
%_bindir/aclocal-default	%_bindir/aclocal%suff	%_bindir/%apiname
%_man1dir/%realname.1.xz	%_man1dir/%apiname.1.xz	%_bindir/%apiname
%_man1dir/aclocal.1.xz	%_man1dir/aclocal%suff.1.xz	%_bindir/%apiname
%_datadir/%realname	%mydatadir	%_bindir/%apiname
%_infodir/%realname.info.xz	%_infodir/%apiname.info.xz	%_bindir/%apiname
EOF

install -pm644 AUTHORS README THANKS NEWS.* \
	%buildroot%docdir/

# reenable perl-threads dependencies
%define __spec_autodep_custom_pre export AUTOMAKE_JOBS=1

%check
%make_build -k check

%files
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%config %_sysconfdir/buildreqs/files/ignore.d/*
%_altdir/%name
%_bindir/*%suff
%_man1dir/*%suff.1*
%_datadir/aclocal%suff
%mydatadir/
%_infodir/*.info*
%docdir/

%changelog
