%define realname automake
%define realver 1.4
%define dialect _1.4
%define suff -1.4

Name: %realname%dialect
%define patchlevel p6
Version: %realver%patchlevel
Release: alt7
Epoch: 1

%add_findreq_skiplist %_datadir/%realname%suff/config.guess
%set_compress_method xz

Summary: A GNU tool for automatically creating Makefiles
License: GPLv2+
Group: Development/Other
Url: http://www.gnu.org/software/automake/
Packager: Dmitry V. Levin <ldv@altlinux.org>
BuildArch: noarch

%define srcname %realname-%realver-%patchlevel

# ftp://ftp.gnu.org/gnu/%realname/%srcname.tar.bz2
Source: %srcname.tar
Source1: %name.buildreq

Patch1: automake-1.4-rh-libtoolize.patch
Patch2: automake-1.4-rh-subdir.patch
Patch3: automake-1.4-rh-backslash.patch
Patch4: automake-1.4-rh-subdirs-89656.patch
Patch5: automake-1.4-alt-texinfo.patch
Patch6: automake-1.4-alt-aclocal_libtool.patch
Patch7: 0001-automake.in-finish_languages-Use-not-do-.-From-Pavel.patch

BuildRequires: makeinfo

Provides: %realname = %epoch:%realver-%{release}0.%patchlevel
Provides: aclocal(libtool)
Obsoletes: %realname
PreReq: automake-common, alternatives >= 0.4

%description
Automake is a tool for automatically generating Makefiles compliant with the
GNU Coding Standards.

You should install Automake if you are developing software and would like to
use its capabilities of automatically generating GNU standard Makefiles.  If
you install Automake, you will also need to install GNU Autoconf package.

%prep
%setup -q -n %srcname
%patch1 -p0
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1

%build
%configure
%make_build MAKEINFO='makeinfo --no-split'

%install
%makeinstall MAKEINFO='makeinfo --no-split'

install -pD -m644 %SOURCE1 %buildroot%_sysconfdir/buildreqs/files/ignore.d/%name
install -p -m644 %realname%suff.info %buildroot%_infodir/

mkdir -p %buildroot%_sysconfdir/buildreqs/packages/substitute.d
echo %realname >%buildroot%_sysconfdir/buildreqs/packages/substitute.d/%name

mkdir -p %buildroot%_altdir
cat <<EOF >%buildroot%_altdir/%name
%_bindir/%realname-default	%_bindir/%realname%suff	20
%_bindir/aclocal-default	%_bindir/aclocal%suff	%_bindir/%realname%suff
%_datadir/%realname	%_datadir/%realname%suff	%_bindir/%realname%suff
%_infodir/%realname.info.xz	%_infodir/%realname%suff.info.xz	%_bindir/%realname%suff
EOF

%files
%config %_sysconfdir/buildreqs/packages/substitute.d/%name
%config %_sysconfdir/buildreqs/files/ignore.d/*
%_altdir/%name
%_bindir/*%suff
%_datadir/aclocal%suff
%_datadir/%realname%suff
%_infodir/*.info*
%doc AUTHORS NEWS README THANKS TODO

%changelog
