# vim: set ft=spec : -*- rpm-spec -*-
%define autossh_user      _autossh
%define autossh_group     _autossh
%define autossh_dir      /var/lib/autosshd

Name: autosshd
Version: 0.0.3
Release: alt11

Summary: System administration - AutoSSH system level service

Group: System/Servers
License: GPL
Url: http://wiki.etersoft.ru/Autosshd

Packager: Danil Mikhailov <danil@altlinux.org>

#Source-git: https://github.com/vitlav/autosshd
Source: %name-%version.tar

BuildArch: noarch

BuildPreReq: rpm-build-intro

Requires: shadow-utils openssh-common
Requires: autossh

%description
Run autossh as system service at startup.

%prep
%setup

%install
mkdir -p %buildroot%_sysconfdir/autossh.d/

mkdir -p %buildroot%_runtimedir/%name/
mkdir -p %buildroot%_locksubsysdir/autossh.d/
mkdir -p %buildroot/%_tmpfilesdir/

cat <<EOF >%buildroot/%_tmpfilesdir/%name.conf
d %_runtimedir/%name 0755 %autossh_user %autossh_group
d %_locksubsysdir/autossh.d/ 0755 root root
EOF

mkdir -p %buildroot/%autossh_dir/.ssh/
#echo "StrictHostKeyChecking no" > %buildroot%autossh_dir/.ssh/config

mkdir -p %buildroot%_docdir/%name/

install -D -m754 etc/rc.d/init.d/autosshd %buildroot%_initdir/%name
# TODO: we need automate filling of this config
install -D -m644 etc/sysconfig/autosshd %buildroot%_sysconfigdir/%name

install -m644 etc/autossh.d/*.conf.template %buildroot%_sysconfdir/autossh.d/

mkdir -p %buildroot%_datadir/%name/
mkdir -p %buildroot%_bindir/
mkdir -p %buildroot/lib/systemd/system/
cp usr/bin/autosshd-ssh %buildroot%_bindir/
cp share/autossh-conf %buildroot%_datadir/%name/
cp share/autosshd.setup* %buildroot%_datadir/%name/
cp lib/systemd/system/autosshd.service %buildroot/lib/systemd/system/autosshd.service 

%pre
# Add the "_autossh" user
%_sbindir/groupadd -r -f %autossh_group 2>/dev/null ||:
%_sbindir/useradd -M -r -g %autossh_group -c 'Autossh daemon' \
	-s /dev/null -d %autossh_dir %autossh_user 2>/dev/null ||:

%post
%post_service %name

%preun
%preun_service %name

%files
%doc doc/*
%attr(750,%autossh_user,%autossh_group) %dir %autossh_dir/
%config(noreplace) %attr(750,%autossh_user,%autossh_group) %autossh_dir/.ssh/
%config(noreplace) %_sysconfigdir/%name
%_sysconfdir/autossh.d/
%_initdir/%name
%_tmpfilesdir/%name.conf
%attr(750,%autossh_user,%autossh_group) %dir %_runtimedir/%name/
%dir %_locksubsysdir/autossh.d/
%dir %_datadir/%name/
%_datadir/%name/autossh-conf
%_datadir/%name/autosshd.setup
%_datadir/%name/autosshd.setup.user
%_bindir/autosshd-ssh
/lib/systemd/system/autosshd.service 

%changelog
