
%define rname avidemux
%def_disable ownffmpeg
%add_python_req_skip ADM_resize ADM_image

Name: avidemux-qt
Version: 2.6.20
Release: alt3%ubt

Group: Video
Summary: Avidemux is a graphical AVI files editor
Summary(ru_RU.UTF-8): Avidemux -- это редактор AVI-файлов с графическим интерфейсом
Url: http://avidemux.org/
License: GPL

Provides: avidemux3 = %version-%release
Provides: avidemux2 = %version-%release
Obsoletes: avidemux2 < %version-%release
Provides: avidemux = %version-%release
Conflicts: avidemux

Source: avidemux-%version.tar
%if_enabled ownffmpeg
Source1: ffmpeg.tar.bz2
%endif
Source2: avidemux.desktop
Source3: http://gitorious.org/avidemux2-6/avidemux2-6/blobs/raw/7cf44bbc1f33894594b2bc84089d1779edc5c2b9/avidemux_plugins/ADM_autoScrips/lib/ADM_resize.py
Source4: avidemux_ru.ts

%if_enabled ownffmpeg
Patch1: avidemux-2.5.6-alt-ffmpeg-0.9.2.patch
%endif
Patch2: alt-i18n-qm-path.patch
Patch3: alt-crash-retranslate.patch
Patch4: alt-flags.patch
Patch5: alt-buildfix.patch
Patch6: alt-fix-find-x264.patch
#
Patch100: avidemux-2.5.1-opencore-check.patch

# Automatically added by buildreq on Mon Aug 24 2015 (-bi)
# optimized out: cmake-modules elfutils glibc-devel-static libEGL-devel libGL-devel libX11-devel libXext-devel libXv-devel libalsa-devel libgpg-error libjack-devel libjson-c libogg-devel libopencore-amrnb0 libopencore-amrwb0 libqt5-core libqt5-gui libqt5-script libqt5-widgets libqt5-xml libstdc++-devel libvorbis-devel libxcb-devel makeinfo perl-Encode perl-Pod-Escapes perl-Pod-Simple perl-Pod-Usage pkg-config python-base python3 python3-base qt5-base-devel rpm-build-gir rsync ruby ruby-stdlibs xorg-videoproto-devel xorg-xextproto-devel xorg-xproto-devel zlib-devel
#BuildRequires: bzlib-devel cmake gcc-c++ git-core libSDL-devel libXvMC-devel libaften-devel libarts-devel libdca-devel libfaad-devel liblame-devel liblzma-devel liblzo2-devel libopencore-amrnb-devel libopencore-amrwb-devel libpulseaudio-devel libsamplerate-devel libsqlite3-devel libva-devel libvdpau-devel libvpx-devel libx264-devel libx265-devel libxvid-devel nss-ldapd perl-podlators python-module-google qt5-script-devel qt5-tools rpm-build-python3 rpm-build-ruby texi2html xsltproc yasm zlib-devel-static
BuildRequires: bzlib-devel cmake gcc-c++ yasm glibc-devel libGL-devel libGLU-devel libSDL2-devel python-devel
BuildRequires: libaften-devel libdca-devel libfaad-devel libjack-devel liblame-devel libtwolame-devel libopus-devel
BuildRequires: liblzma-devel liblzo2-devel libsqlite3-devel libfreetype-devel fontconfig-devel libfribidi-devel
BuildRequires: libopencore-amrnb-devel libopencore-amrwb-devel libpulseaudio-devel libsamplerate-devel
BuildRequires: libvdpau-devel libva-devel libxvba-devel libXv-devel libXvMC-devel
BuildRequires: libvorbis-devel libvpx-devel libx264-devel libx265-devel
BuildRequires: libass-devel liba52-devel libmad-devel libmp4v2-devel
BuildRequires: libxml2-devel libxvid-devel
BuildRequires: perl-podlators perl-IO-Compress texi2html
BuildRequires: qt5-base-devel qt5-script-devel qt5-tools
BuildRequires: xml-utils xsltproc yasm kde-common-devel libalsa-devel zlib-devel
BuildRequires(pre): rpm-build-ubt

%description
Avidemux is a graphical tool to edit AVI. It allows you to multiplex and
demultiplex audio to/from video.

It is able to cut video, import BMP, MJPEG and MPEG video, and encode them.
You can also process video with included filters. It requires a DivX
compatible encoder and the Gimp Toolkit (GTK) libraries.

%description -l ru_RU.UTF-8
Avidemux -- это редактор AVI-файлов с графическим интерфейсом.
Он позволяет монтировать видеосцены из видеофайлов и изображений
и добавлять к ним звуковую дорожку, а затем кодировать в файлы сжатых
форматов.

%package gui-qt
Group: Video
Summary: Qt GUI for %name
PreReq(post,preun): alternatives >= 0.2
Requires: %name-common = %version-%release
Provides: %name-qui = %version-%release
Conflicts: %name <= 2.4.4-alt1
%description gui-qt
Qt GUI for %name

%package gui-gtk
Group: Video
Summary: GTK GUI for %name
PreReq(post,preun): alternatives >= 0.2
Requires: %name-common = %version-%release
Provides: %name-qui = %version-%release
Conflicts: %name <= 2.4.4-alt1
%description gui-gtk
GTK GUI for %name

%package common
Group: Video
Summary: Common files for %name
PreReq(post,preun): alternatives >= 0.2
Provides: %name-qui = %version-%release
Conflicts: %name <= 2.4.4-alt1
%description common
Common files for %name

%prep
%setup -qn %rname-%version
%if_enabled ownffmpeg
%patch1 -p1
%endif
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch100 -p1

#cp -f %SOURCE4 po/

%if_enabled ownffmpeg
install -m 0644 %SOURCE1 avidemux_core/ffmpeg_package
%endif

grep -rlw 'amd/amdxvba\.h' | xargs sed -i 's|amd/\(amdxvba\.h\)|\1|g'


%build
%add_optflags -std=c++11
export QTDIR=%_qt5_prefix
BUILDDIR=$PWD
sh bootStrap.bash \
    --with-core \
    --with-cli \
    --with-qt \
    --with-plugins \
    --with-system-libass \
    --with-system-liba52 \
    --with-system-libmad \
    --with-system-libmp4v2 \
    #
#lrelease-qt5 avidemux/qt4/i18n/*.ts
#for p in po/*.po ; do
#    FLNG=`echo "$p" | sed -e 's|\..*||' -e 's|.*\/||'`
#    msgfmt -o po/"$FLNG".mo $p
#done

%install
%set_verify_elf_method unresolved=relaxed,textrel=relaxed
cp -ar install/* %buildroot/
mkdir -p %buildroot/usr/
for d in bin include %_lib share
do
    [ -d "%buildroot/$d" ] || continue
    mv "%buildroot/$d" %buildroot/usr/
done

install -pD -m644 avidemux_icon.png %buildroot/%_pixmapsdir/%rname.png
install -pD -m644 %SOURCE2 %buildroot/%_desktopdir/%rname.desktop
install -pD -m644 %SOURCE3 %buildroot/%_libdir/ADM_plugins6/autoScripts/lib/
ln -s avidemux3_qt5 %buildroot/%_bindir/%rname

#for p in po/*.mo ; do
#    LNG=`echo "$p" | sed -e 's|\..*||' -e 's|.*\/||' -e 's|@.*||'`
#    FLNG=`echo "$p" | sed -e 's|\..*||' -e 's|.*\/||'`
#    mkdir -p %buildroot/%_datadir/locale/"$LNG"/LC_MESSAGES
#    install -m 0644 po/"$FLNG".mo %buildroot/%_datadir/locale/"$LNG"/LC_MESSAGES/avidemux.mo
#done
#mkdir -p %buildroot/%_datadir/avidemux6/i18n/
#install -m 0644 lrelease-qt5 avidemux/qt4/i18n/avidemux*.qm %buildroot/%_datadir/avidemux6/i18n/

%find_lang --with-qt avidemux
#echo "%%defattr(644,root,root,755)" > avidemux.lang
#for f in %buildroot/%_datadir/avidemux6/i18n/avidemux*.qm
#do
#    LNG=`echo "$f"| sed -e 's|^.*/\(.*\)_\([a-z][a-z]\)[^[:alpha:]].*|\2|'`
#    FILE=%%_datadir/avidemux6/i18n/`basename "$f"`
#    echo "%%lang($LNG) $FILE" >>avidemux.lang
#done



%files -f avidemux.lang
%_desktopdir/*.desktop
%_bindir/avidemux
%_bindir/avidemux3_cli
%_bindir/avidemux3_jobs*
%_bindir/avidemux3_qt5
%_libdir/libADM6*.so.*
%_libdir/libADM_*.so
%_libdir/ADM_plugins?/
%_pixmapsdir/*
#%_datadir/ADM_scripts
%dir %_datadir/avidemux6
%dir %_datadir/avidemux6/*/
%dir %_datadir/avidemux6/*/*
#%_datadir/avidemux6/help

# devel
%exclude %_includedir/avidemux

%changelog
