# -*- rpm-spec -*-
# $Id: avr-binutils,v 1.11 2003/09/05 11:18:56 grigory Exp $

#define snapshot_version 030512
%define cross_arch avr

Summary: A GNU collection of binary utilities.
Name: %cross_arch-binutils
Version: 2.25
Release: alt1
Serial: 2
Copyright: GPL
Group: Development/Other
URL: ftp://ftp.kernel.org/pub/linux/devel/binutils/
Source: avr-binutils-%version.tar.gz
Patch0: patch-coff-avr-2.20.51.0.9.patch
Patch1: 30-binutils-2.20.1-avr-size.patch
#Patch0: binutils-%version-info_fix.diff

%define libavrdir %_libdir/%cross_arch
%define includeavrdir %_includedir/%cross_arch

BuildRequires: makeinfo

# Automatically added by buildreq on Sat Jan 09 2016
# optimized out: avr-gcc avr-gcc-c++ glibc-devel-static libncurses-devel libstdc++-devel libtinfo-devel makeinfo perl-Encode perl-Text-Unidecode perl-Unicode-EastAsianWidth perl-Unicode-Normalize perl-libintl perl-unicore pkg-config python-base python-devel python-modules xorg-xproto-devel zlib-devel
BuildRequires: avr-binutils expect flex gcc-c++ imake libX11-devel libelf-devel libexpat-devel python-module-distribute python-module-fonttools python-module-google ruby ruby-stdlibs xorg-cf-files zlib-devel-static

%description
Avr-Binutils is a collection of binary utilities, including avr-ar (for
creating, modifying and extracting from archives), avr-as (a family of GNU
assemblers), avr-ld (the GNU linker), avr-nm (for listing symbols from object
files), avr-objcopy (for copying and translating object files), avr-objdump
(for displaying information from object files), avr-ranlib (for generating an
index for the contents of an archive), avr-size (for listing the section sizes
of an object or archive file), avr-strings (for listing printable strings from
files), avr-strip (for discarding symbols), and avr-addr2line (for converting
addresses to file and line).

This package is for cross-development of AVR programs.

%prep
%setup -n binutils -q
#%patch1
#%patch0 -p1
#%patch0 -p1 -b .avrinfo

%build
%__subst 's/AC_PREREQ(2.64)/AC_PREREQ(2.68)/g' ./configure.ac
%__subst 's/AC_PREREQ(2.64)/AC_PREREQ(2.68)/g' ./libiberty/configure.ac
%__subst 's/  \[m4_fatal(\[Please use exactly Autoconf \]/  \[m4_errprintn(\[Please use exactly Autoconf \]/g' ./config/override.m4
%__autoconf
pushd ld
autoreconf
popd

# Binutils come with its own custom libtool
%define __libtoolize echo
./configure \
	--prefix=%_prefix \
	--mandir=%_mandir \
	--infodir=%_infodir \
	--includedir=%includeavrdir \
	--libdir=%libavrdir \
	--exec-prefix=%libavrdir \
	--disable-nls \
	--target=avr \
	--program-prefix="avr-" \
	--enable-languages="c,c++" \
	--disable-werror \
	--enable-install-libiberty \
	--enable-install-libbfd

%make_build all-bfd TARGET-bfd=headers
%__rm bfd/Makefile

%make_build configure-host
%make_build


%install
%__mkdir_p %buildroot{%libavrdir/bin,%includeavrdir,%_bindir}

%makeinstall \
	prefix=%buildroot%_prefix \
	exec_prefix=%buildroot%libavrdir \
	libdir=%buildroot%libavrdir \
	includedir=%buildroot%includeavrdir \
	mandir=%buildroot%_mandir

%__make install-info \
	prefix=%buildroot%_prefix \
	infodir=%buildroot%_infodir

%__mv %buildroot%_bindir/* %buildroot%libavrdir/bin/
for i in `ls -1 %buildroot%libavrdir/bin/`; do
	%__ln_s ../..%libavrdir/bin/$i %buildroot%_bindir/$i
done
for i in `ls -1 %buildroot%libavrdir/%cross_arch/bin/`; do
	%__ln_s %cross_arch-$i %buildroot%libavrdir/bin/$i
done
%__rm -rf %buildroot%libavrdir/%cross_arch/bin

%__ln_s ../bin %buildroot%libavrdir/avr/bin
%__ln_s ./ %buildroot%libavrdir/lib
%__ln_s ../../..%includeavrdir %buildroot%libavrdir/include

%__rm -f %buildroot%_bindir/*c++filt*
%__rm -fr %buildroot%_infodir

%__ln_s %_libdir/%cross_arch %buildroot%_prefix/%cross_arch

%__rm -f %buildroot/usr/lib64/lib64/libiberty.a
%__rm -rf %buildroot/%_datadir/gdb

%files
%doc README
%dir %libavrdir
%dir %includeavrdir
%dir %includeavrdir/libiberty
%dir %includeavrdir/gdb
%_bindir/*
%_prefix/%cross_arch
%includeavrdir/libiberty/*
%includeavrdir/gdb/*
%libavrdir/*
%_man1dir/*

%changelog
