# -*- rpm-spec -*-
# $Id: avr-libc,v 1.33 2005/06/03 10:59:46 grigory Exp $

%define cross_arch avr

Summary: AVR libc
Name: avr-libc
Version: 2.0.0
Release: alt1
Serial: 1
License: GPL, LGPL, BSD, Public Domain
Group: Development/Other
URL: http://savannah.gnu.org/projects/avr-libc

Source0: http://savannah.gnu.org/download/avr-libc/avr-libc-%version.tar.bz2
Source1: avr8-headers-3.5.0.1662.zip
Patch0: 1.8.0.fix.patch

# Automatically added by buildreq on Fri Feb 01 2013
# optimized out: avr-binutils avr-gcc fontconfig fonts-ttf-gnu-freefont-mono fonts-ttf-gnu-freefont-sans fonts-ttf-gnu-freefont-serif fonts-type1-urw ghostscript-classic ghostscript-common netpbm ruby texlive-extra-utils
BuildRequires: azenis-fonts-ttf cups-filters doxygen ruby-stdlibs transfig
BuildRequires: fonts-otf-oldstandard fonts-otf-stix fonts-ttf-armenian fonts-ttf-baekmuk-batang fonts-ttf-baekmuk-dotum
BuildRequires: fonts-ttf-baekmuk-gulim fonts-ttf-baekmuk-hline fonts-ttf-bengali fonts-ttf-chinese-big5
BuildRequires: fonts-ttf-chinese-gb2312 fonts-ttf-church fonts-ttf-dejavu fonts-ttf-dejavu-lgc fonts-ttf-devanagari
BuildRequires: fonts-ttf-freefont fonts-ttf-georgian fonts-ttf-gost fonts-ttf-gw fonts-ttf-java-1.6.0-sun fonts-ttf-junicode
BuildRequires: fonts-ttf-kannada fonts-ttf-latex-xft fonts-ttf-liberation fonts-ttf-malayalam fonts-ttf-ms fonts-ttf-oldstandard
BuildRequires: fonts-ttf-reduce fonts-ttf-sazanami-gothic fonts-ttf-sazanami-mincho fonts-ttf-sil-gentium fonts-ttf-syriac
BuildRequires: fonts-ttf-tamil fonts-ttf-tempora fonts-ttf-urdu fonts-ttf-vera fonts-ttf-xorg fonts-ttf-znamen
BuildRequires: fonts-type1-cm-super-pfb fonts-type1-dmtr40in fonts-type1-phonetic fonts-type1-xorg unzip

BuildRequires: avr-binutils >= 2:2.23.1-alt1
BuildRequires: avr-gcc >= 4.7.2-alt3
BuildRequires: avr-gcc-c++ >= 4.7.2-alt3

Requires: avr-binutils >= 2:2.23.1-alt1
Requires: avr-gcc >= 4.7.2-alt3
Requires: avr-gcc-c++ >= 4.7.2-alt3

%define libavrdir %_libdir/%cross_arch
%define includeavrdir %_includedir/%cross_arch

%description
Avr-libc is a C library for developing applications for Atmel AVR microcontrollers.

%package doc
Summary: Documentation for avr-libc
Group: Development/Other
BuildArch: noarch

%description doc
Documentation for avr-libc in html, postscript and pdf formats.


%prep
%setup -q
# -n libc/avr-libc
# patch0 -p1
unzip %SOURCE1
for i in avr/io*.h; do
	mv --verbose --force $i include/avr/
done

%build
./bootstrap
./configure \
	--host=avr \
	--build=$(./config.guess) \
	--prefix=%_prefix \
	--libdir=%_libdir \
	--includedir=%includeavrdir \
	--mandir=%_mandir \
	--infodir=%_infodir \
	--enable-doc --disable-versioned-doc --disable-pdf-doc
#	--exec-prefix=%libavrdir \

%make_build

%install
%make_build \
	prefix=%buildroot%_prefix \
	exec_prefix=%buildroot%_libdir \
	mandir=%buildroot%_mandir \
	infodir=%buildroot%_infodir \
	libdir=%buildroot%_libdir \
	includedir=%buildroot%includeavrdir \
	install

# Move lib and include files from /usr/avr -> /usr/lib/avr
%__mkdir_p %buildroot%_libdir
%__mv %buildroot%_prefix/avr %buildroot%_libdir/

%files
%doc AUTHORS ChangeLog INSTALL LICENSE NEWS README
%doc doc/CHANGES.old doc/ChangeLog doc/INSTALL doc/TODO
%libavrdir/include/*
%libavrdir/lib/*

%files doc
%_bindir/*
%_datadir/doc/avr-libc/*

%changelog
