# -*- rpm-spec -*-
# $Id: avrdude,v 1.2 2005/02/02 09:35:55 grigory Exp $

%def_enable doc

%set_verify_elf_method unresolved=relaxed

Summary: AVRDUDE is software for programming Atmel AVR Microcontrollers.
Name: avrdude
Version: 6.3
Release: alt2.M80P.4
License: GPL
Group: Development/Other
URL: http://www.nongnu.org/avrdude/
Source0: http://download.savannah.gnu.org/releases/avrdude/%name-%version.tar.gz
Patch: avrdude-install-header.patch

#BuildRequires(pre): rpm-build-ubt

BuildRequires: gnu-config libtinfo-devel libusb-devel libusb-compat-devel makeinfo
BuildRequires: flex libelf-devel libftdi1-devel libncurses-devel libreadline-devel

%if_enabled doc
BuildRequires: tex-common texlive-base texlive-base-bin texlive-common texlive-generic-recommended texlive-latex-base texi2html texi2dvi
%endif

%package docs
Summary: Documentation for AVRDUDE.
Group: Development/Other
BuildArch: noarch

%package devel
Summary: The AVRDUDE static library with API for other tools.
Group: Development/C
Provides: lib%name-devel = %version-%release
Provides: lib%name-static = %version-%release

%description
AVRDUDE is software for programming Atmel AVR Microcontrollers.

%description docs
Documentation for avrdude in html, postscript and pdf formats.

%description devel
AVRDUDE static library provides API integration for programming Atmel AVR Microcontrollers.

%prep
%setup -q
%patch -p2

%build
%autoreconf
%configure %{subst_enable doc} --enable-parport --enable-linuxgpio
%make

%install
%makeinstall
sed -i 's/^#include "ac_cfg\.h"$/#include <libavrdude_cfg.h>/' %buildroot%_includedir/libavrdude.h
install -T ac_cfg.h %buildroot%_includedir/libavrdude_cfg.h
rm -f %buildroot%_libdir/*.so*

mkdir -p %buildroot%_sysconfdir/avrdude
ln -s ../avrdude.conf %buildroot%_sysconfdir/avrdude/avrdude.conf

%if_enabled doc
%post

%preun
%endif

%files
%doc AUTHORS ChangeLog* NEWS README doc/TODO
%config %_sysconfdir/%name.conf
%dir %_sysconfdir/%name
%_sysconfdir/%name/%name.conf
%_bindir/*
%_man1dir/*

%if_enabled doc
%_infodir/*

%files docs
%doc doc/avrdude-html/*.html doc/avrdude.ps doc/avrdude.pdf
%endif

%files devel
%_includedir/*.h
%_libdir/*.a

%changelog
