Name: awesome
Version: 3.5.9
Release: alt1
Group: Graphical desktop/Other
License: GPL2+

Url: http://awesome.naquadah.org/
Packager: Evgenii Terechkov <evg@altlinux.org>
Source: %name-%version.tar
Source1: %name.wmsession
Source2: %name.menu-method
Patch0:%name-%version-alt.patch

Summary: A window manager initialy based on a dwm code rewriting

BuildRequires: ImageMagick-tools asciidoc cmake gcc-c++ gperf
BuildRequires: imlib2-devel libdbus-devel libev-devel liblua5-devel
BuildRequires: libncurses-devel libpango-devel libreadline-devel xmlto
BuildRequires: libxdg-basedir-devel libstartup-notification-devel
BuildRequires: libXdmcp-devel libgdk-pixbuf-devel lgi
BuildRequires: lua libpango-gir

BuildPreReq: libxcbutil-devel >= 0.3.8 libxcbutil-keysyms-devel >= 0.3.8
BuildPreReq: libxcbutil-icccm-devel >= 0.3.8 libxcbutil-cursor-devel

Requires: libstartup-notification >= 0.10-alt1
Requires: design-graphics
Requires: lgi >= 0.6.1
Requires: libpango-gir
Requires: libcairo-gobject

%description
awesome is a window manager initialy based on a dwm code rewriting. It's
extremely fast, small, dynamic and awesome.

%prep
%setup -n %name-%version
%patch0 -p1

%build
echo -n "v%version" >| .version_stamp
mkdir -p build
pushd build
CFLAGS="%optflags" \
CXXFLAGS="%optflags" \
cmake \
  -DPREFIX=%prefix \
  -DAWESOME_DOC_PATH=%_docdir/%name-%version \
  -DCMAKE_INSTALL_PREFIX=%prefix \
  -DSYSCONF_INSTALL_DIR=%_sysconfdir \
  -DSYSCONFDIR=%_sysconfdir \
  -DCOMPRESS_MANPAGES=OFF \
%if %_lib == lib64
  -DLIB_SUFFIX=64 \
%endif
  ..

%make_build
popd

%install
pushd build
# Fix manpages:
for i in `find manpages -type f -iname '*.[0-9]'`; do
    sed -i '1i.\\" -*- mode: troff; coding: utf-8 -*-' $i
# "
done

%makeinstall DESTDIR=%buildroot install
popd
install -D -m 644 %name.desktop %buildroot/%_desktopdir/%name.desktop
touch %buildroot%_sysconfdir/xdg/%name/menu.lua
install -D -m 644 %SOURCE1 %buildroot%_sysconfdir/X11/wmsession.d/05%name
install -D -m 755 %SOURCE2 %buildroot%_sysconfdir/menu-methods/%name

%find_lang %name

%files -f %name.lang
%_bindir/*
%_sysconfdir/menu-methods/%name
%_sysconfdir/xdg/%name
%ghost %_sysconfdir/xdg/%name/menu.lua
%_sysconfdir/X11/wmsession.d/*
%_man1dir/aw*
%_man5dir/aw*
%_mandir/*/man1/aw*
%_mandir/*/man5/aw*
%_datadir/%name
%_desktopdir/%name.desktop
%doc AUTHORS LICENSE README BUGS PATCHES STYLE

%changelog
