Name: bash4
%define bash_version 4.2
%define bash_patchlevel .50
Version: %bash_version%bash_patchlevel
Release: alt1.1

Summary: The GNU Bourne Again SHell (Bash)
Group: Shells
License: GPLv3+
Url: http://www.gnu.org/software/%name/
Packager: Gleb F-Malinovskiy <glebfm@altlinux.org>

# ftp://ftp.gnu.org/gnu/bash/bash-%bash_version.tar.bz2
# ftp://ftp.gnu.org/gnu/bash/bash-%bash_version-patches/
Source0: bash-%version.tar

Source2: bash_alias
Source3: bashrc

Patch: bash-%version-%release.patch

# bashbug produces a lot of unneeded dependencies.
AutoReq: yes, noshell

Requires: sh4 = %version-%release

BuildPreReq: libtinfo-devel, libreadline-devel >= 6.1, mktemp >= 1:1.3.1
# explicitly added texinfo for info files
BuildRequires: texinfo

%package -n sh4
Summary: The GNU Bourne Again SHell (/bin/sh)
Group: Shells
Provides: /bin/sh4, /usr/lib/bash4
Conflicts: %name < %version-%release
AutoReq: yes

%package doc
Group: Shells
Summary: Documentation for the GNU Bourne Again SHell
BuildArch: noarch
Requires: %name = %version-%release
AutoReq: yes

%package examples
Group: Development/Other
Summary: Examples for the GNU Bourne Again SHell
BuildArch: noarch
Requires: %name = %version-%release
AutoReq: yes

%package devel
Group: Development/Other
Summary: Bash loadable builtins development files
Requires: %name = %version-%release

%description
Bash is an sh-compatible command language interpreter that executes
commands read from the standard input or from a file.  Bash also
incorporates useful features from the Korn and C shells (ksh and csh).
Most sh scripts can be run by bash without modification.

Bash is ultimately intended to be a conformant implementation of the
IEEE POSIX Shell and Tools specification (IEEE Working Group 1003.2).

%description -n sh4
Bash is an sh-compatible command language interpreter that executes
commands read from the standard input or from a file.  Bash also
incorporates useful features from the Korn and C shells (ksh and csh).
Most sh scripts can be run by bash without modification.

Bash is ultimately intended to be a conformant implementation of the
IEEE POSIX Shell and Tools specification (IEEE Working Group 1003.2).

This package contains /bin/sh.

%description doc
Bash is an sh-compatible command language interpreter that executes
commands read from the standard input or from a file.  Bash also
incorporates useful features from the Korn and C shells (ksh and csh).
Most sh scripts can be run by bash without modification.

Bash is ultimately intended to be a conformant implementation of the
IEEE POSIX Shell and Tools specification (IEEE Working Group 1003.2).

This package contains documentation for the GNU Bourne Again SHell.

%description examples
Bash is an sh-compatible command language interpreter that executes
commands read from the standard input or from a file.  Bash also
incorporates useful features from the Korn and C shells (ksh and csh).
Most sh scripts can be run by bash without modification.

Bash is ultimately intended to be a conformant implementation of the
IEEE POSIX Shell and Tools specification (IEEE Working Group 1003.2).

This package contains examples for the GNU Bourne Again SHell.

%description devel
Bash can dynamically load new builtin commands.
Included are the necessary headers to compile custom builtins.

%prep
%setup -n bash-%version
%patch -p1

# Remove files which should be regenerated during build.
rm configure y.tab.? doc/*.info*

# Bundled texi2dvi is outdated.
install -pm755 /usr/bin/texi2dvi support/

# Fix temporary file handling.
sed -i 's,/tmp/,,g' *.m4

# Would anyone volunteer to fix those? Probably not.
#find examples -type f -print0 |
#	xargs -r0 grep -FlZ -- /tmp |
#	xargs -r0 rm -fv --

sed -n '1,/^\.SH "BASH BUILTIN COMMANDS"/p' doc/builtins.1 >builtins.1
sed -n '/^\.\\" start of bash_builtins/,/^\.\\" bash_builtins/p' doc/bash.1 >>builtins.1
sed -n '/^\.SH SEE ALSO/,$p' doc/builtins.1 >>builtins.1
mv builtins.1 doc/builtins.1

sed -n '1,/^\.SH "RESTRICTED SHELL"/p' doc/rbash.1 >rbash.1
sed -n '/^\.\\" rbash\.1/,/^\.\\" end of rbash\.1/p' doc/bash.1 >> rbash.1
sed -n '/^\.SH SEE ALSO/,$p' doc/rbash.1 >>rbash.1
mv rbash.1 doc/rbash.1

mv po/bash.pot po/bash4.pot

%build
%add_optflags -D_GNU_SOURCE -Werror=parentheses -Werror=maybe-uninitialized
autoconf

export \
	bash_cv_dev_fd=standard \
	bash_cv_dev_stdin=present \
	bash_cv_mail_dir=/var/mail \
	bash_cv_termcap_lib=libc \
	%{?__buildreqs:bash_cv_must_reinstall_sighandlers=no} \
	#

%define _configure_script ../configure

# Build sh.
mkdir build-sh
pushd build-sh
%configure \
	--without-bash-malloc \
	--disable-readline \
	--disable-command-timing \
	--disable-net-redirections \
	--disable-help-builtin \
	--disable-bang-history \
	--disable-history \
	--disable-progcomp \
	--disable-restricted \
	#
# SMP-incompatible build.
make "CPPFLAGS=-DRECYCLES_PIDS"
popd

# Build bash.
mkdir build-bash
pushd build-bash
%configure \
	--without-bash-malloc \
	--with-installed-readline \
	--disable-command-timing \
	--disable-net-redirections \
	--enable-separate-helpfiles \
	#
# SMP-incompatible build.
make "CPPFLAGS=-DRECYCLES_PIDS"
make info
ln doc/*.info* ../doc/
popd

%install
%makeinstall -C build-bash

install -pD -m755 build-sh/bash %buildroot/bin/sh4
mv %buildroot%_bindir/bash %buildroot/bin/%name

ln -s %name %buildroot/bin/r%name
mv %buildroot%_bindir/bash{,4}bug

mv %buildroot%_infodir/bash{,4}.info

mv %buildroot%_man1dir/bash{,4}.1
mv %buildroot%_man1dir/bash{,4}bug.1
mv %buildroot%_man1dir/bash{,4}_builtins.1
mv %buildroot%_man1dir/rbash{,4}.1
ln -s %name.1 %buildroot%_man1dir/sh4.1

# Directory for builtins
mkdir -p %buildroot/usr/lib/%name

# Include files for building custom builtins.
pushd build-bash
mkdir -p %buildroot%_includedir/bash
for f in ../examples/loadables/*.c; do
	%__cc -MM -DHAVE_CONFIG_H -DSHELL -Iexamples/loadables -I. -I.. -I../lib -I../builtins -I../include "$f"
done |
	tr -d '\:' |
	tr -s '[:space:]' '\n' |
	fgrep .h |
	fgrep -v examples/loadables/ |
	sort -u |
	while read f; do
		install -pm644 "$f" %buildroot%_includedir/bash/
	done
popd

# Prepare documentation.
%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir/{html,ps,txt}
install -p -m644 \
	AUTHORS CHANGES COMPAT NEWS NOTES POSIX RBASH doc/{FAQ,INTRO} \
	%buildroot%docdir/
install -p -m644 doc/*.html %buildroot%docdir/html/
install -p -m644 doc/*.ps %buildroot%docdir/ps/
install -p -m644 doc/*.txt %buildroot%docdir/txt/
find %buildroot%docdir/{[A-Z],{ps,txt}/}* -type f -size +8k -print0 |
	xargs -r0 bzip2 -9 --
cp -a examples %buildroot%docdir/
find %buildroot%docdir/examples/ -type f -name 'Makefile*' -delete -print

cat >%buildroot%docdir/examples/loadables/Makefile <<'EOF'
CC = %__cc
CPPFLAGS = -DHAVE_CONFIG_H -I. -I%_includedir/bash
CFLAGS = %optflags_default %optflags_shared
LDFLAGS = -shared -Wl,-soname,$@

%%.so: %%.c
	$(LINK.c) $^ $(LOADLIBES) $(LDLIBS) -o $@
EOF

%find_lang %name

%check
%make_build -k check -C build-sh
%make_build -k check -C build-bash

%files -n sh4
/bin/sh4
/usr/lib/bash4

%files -f %name.lang
/bin/*%{name}*
%_bindir/*
%_datadir/%name
%_mandir/man?/*
%_infodir/*.info*
%dir %docdir
%docdir/[A-Z]*

%files doc
%dir %docdir
%docdir/html
%docdir/ps
%docdir/txt

%files examples
%dir %docdir
%docdir/examples

%files devel
%_includedir/*

%changelog
