Group: Development/Java
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
%global svnrev 1592769

Name:           bcel
Version:        6.0
Release:        alt1_0.4.20140406svn1592769jpp8
Epoch:          1
Summary:        Byte Code Engineering Library
License:        ASL 2.0
URL:            http://commons.apache.org/proper/commons-bcel/
# Source for releases:
# Source0:        http://archive.apache.org/dist/commons/bcel/source/bcel-%{version}-src.tar.gz

# svn export http://svn.apache.org/repos/asf/commons/proper/bcel/trunk bcel
# tar cJf bcel-1592769.tar.xz bcel
Source0:        bcel-%{svnrev}.tar.xz
# Upstream uses Maven 1, which is not available in Fedora.
# The following is upstream project.xml converted to Maven 2/3.
Source1:        %{name}-pom.xml
BuildArch:      noarch

BuildRequires:  maven-local
BuildRequires:  mvn(regexp:regexp)
BuildRequires:  mvn(org.apache.felix:maven-bundle-plugin)
Source44: import.info

%description
The Byte Code Engineering Library (formerly known as JavaClass) is
intended to give users a convenient possibility to analyze, create, and
manipulate (binary) Java class files (those ending with .class). Classes
are represented by objects which contain all the symbolic information of
the given class: methods, fields and byte code instructions, in
particular.  Such objects can be read from an existing file, be
transformed by a program (e.g. a class loader at run-time) and dumped to
a file again. An even more interesting application is the creation of
classes from scratch at run-time. The Byte Code Engineering Library
(BCEL) may be also useful if you want to learn about the Java Virtual
Machine (JVM) and the format of Java .class files.  BCEL is already
being used successfully in several projects such as compilers,
optimizers, obfuscators and analysis tools, the most popular probably
being the Xalan XSLT processor at Apache.

%package javadoc
Group: Development/Java
Summary:        API documentation for %{name}
Obsoletes:      %{name}-manual < %{version}-%{release}
BuildArch: noarch

%description javadoc
This package provides %{summary}.

%prep
%setup -q -n %{name}
cp -p %{SOURCE1} pom.xml
%mvn_alias : bcel: apache:
%mvn_file : %{name}

# different path in test
sed -i '\|lib/dt\.jar|s|javaHome|javaHome.substring(0, javaHome.length() - 4)|' \
        src/test/java/org/apache/bcel/PerformanceTest.java

%build
%mvn_build

%install
%mvn_install

%files -f .mfiles
%doc README.txt
%doc LICENSE.txt NOTICE.txt

%files javadoc -f .mfiles-javadoc
%doc LICENSE.txt NOTICE.txt

%changelog
