Name: bind-dyndb-ldap
Version: 10.1
Release: alt3.M80P.1

Summary: LDAP back-end plug-in for BIND
License: %gpl2plus
Group: System/Servers

URL: https://fedorahosted.org/bind-dyndb-ldap
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

BuildRequires: bind-devel
BuildRequires: libldap-devel
BuildRequires: libkrb5-devel
BuildRequires: libuuid-devel
BuildRequires: libsasl2-devel

Requires: bind

%define _unpackaged_files_terminate_build 1

%description
This package provides an LDAP back-end plug-in for BIND. It features
support for dynamic updates and internal caching, to lift the load
off of your LDAP server.

%prep
%setup
%patch -p1

%build
#autoreconf
%configure
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_localstatedir/bind/zone/dyndb-ldap/

%post
# restart bind due to upgrade issue caused by binary incompatibility
# of new installed version of bind and old not removed yet version of
# dyndb ldap
systemctl is-enabled --quiet bind && systemctl restart bind 2>&1 ||:
# actually FreeIPA installer disables all depended services to
# explicitly control them via ipa.service/ipactl. Therefore in this
# case named is always in disabled state.
systemctl is-enabled --quiet ipa && systemctl restart bind 2>&1 ||:

%files
%_defaultdocdir/%name
%_libdir/bind/ldap.so
%dir %attr(770, root, named) %_localstatedir/bind/zone/dyndb-ldap/

%exclude %_libdir/bind/*.la

%changelog
