Name: binutils
Version: 2.26.1
Release: alt1
Epoch: 1

Summary: GNU Binary Utility Development Utilities
License: GPLv3+
Group: Development/Other
Url: http://sourceware.org/binutils/

# ftp://ftp.kernel.org/pub/linux/devel/%name/%name-%version.tar.xz
Source: %name-%version.tar
Source1: bfd.h
Source2: gcc.sh
Source3: g++.sh
Source4: output-format.sed

Patch: binutils-2_26-branch.patch

Patch0001: 0001-Add-lto-and-none-lto-input-support-for-ld-r.patch
Patch0002: 0002-Add-test-for-nm-on-mixed-LTO-non-LTO-object.patch
Patch0003: 0003-Don-t-check-the-plugin-target-twice.patch
Patch0004: 0004-PR19886-as-needed-regression.patch
Patch0005: 0005-gold-change-default-hash-style-to-gnu.patch
Patch0006: 0006-bfd-export-demangle.h-and-hashtab.h.patch
Patch0007: 0007-ld-add-no-warn-shared-textrel-option.patch
Patch0008: 0008-ld-enable-optimization-and-warn-shared-textrel-by-de.patch
Patch0009: 0009-ld-change-default-hash-style-to-gnu.patch
Patch0010: 0010-ld-enable-z-relro-by-default.patch
Patch0011: 0011-gold-enable-z-relro-by-default.patch
Patch0012: 0012-ld-testsuite-restore-upstream-default-options.patch
Patch0013: 0013-gold-testsuite-use-sysv-hash-style-for-two-tests.patch
Patch0014: 0014-bfd-elflink.c-bfd_elf_final_link-check-all-objects-f.patch
Patch0015: 0015-ld-testsuite-pr18808b.c-pass-Wno-return-type.patch

PreReq: alternatives >= 0:0.4
Conflicts: libbfd
# due to c++filt
Conflicts: gcc-common < 0:1.2.1-alt4

BuildRequires: alternatives >= 0:0.4
BuildRequires: flex makeinfo perl-Pod-Parser zlib-devel
BuildRequires: gcc-c++ libstdc++-devel-static
BuildRequires: makeinfo
%{?!_without_check:%{?!_disable_check:BuildRequires: dejagnu, gcc-c++, glibc-devel-static, zlib-devel-static, bc, /proc, /dev/pts}}

%package devel
Summary: Development files for development with BFD, opcodes and libiberty libraries
Group: Development/C
Requires: zlib-devel-static
Provides: libiberty-devel = %epoch:%version-%release
Provides: libbfd-devel = %epoch:%version-%release
Obsoletes: libiberty-devel
Obsoletes: libbfd-devel

%description
Binutils is a collection of binary utilities, including:
+ addr2line: converting addresses to file and line;
+ ar: creating modifying and extracting from archives;
+ nm: listing symbols from object files;
+ objcopy: copying and translating object files;
+ objdump: displaying information from object files;
+ ranlib: generating an index for the contents of an archive;
+ size: listing the section sizes of an object or archive file;
+ strings: listing printable strings from files;
+ strip: discarding symbols.

%description devel
This package contains include files, dynamic and static libraries needed
for development software based on Binary File Descriptor library and
libiberty.

%prep
%setup

%patch -p1

%patch0001 -p1
%patch0002 -p1
%patch0003 -p1
%patch0004 -p1
%patch0005 -p1
%patch0006 -p1
%patch0007 -p1
%patch0008 -p1
%patch0009 -p1
%patch0010 -p1
%patch0011 -p1
%patch0012 -p1
%patch0013 -p1
%patch0014 -p1
%patch0015 -p1

# Replay libtool commits
# a042d335197ac7afb824ab54c3aab91f3e79a2d0
# 9e68384a4fac10585e54519a3f1925cb99d338e8
sed -i -e '
/^      \*32-bit\*)$/ a \
	libsuff=x32
/^      \*64-bit\*)$/ a \
	libsuff=64
s,sys_lib_search_path_spec="/lib /usr/lib /usr/local/lib",sys_lib_search_path_spec="/lib$libsuff /usr/lib$libsuff /usr/local/lib$libsuff",
s,sys_lib_dlsearch_path_spec="/lib /usr/lib",sys_lib_dlsearch_path_spec="/lib$libsuff /usr/lib$libsuff",
s,sys_lib_dlsearch_path_spec="/lib /usr/lib \$lt_ld_extra",sys_lib_dlsearch_path_spec="$sys_lib_dlsearch_path_spec $lt_ld_extra",
s,x86_64-\*kfreebsd\*-gnu|x86_64-\*linux\*|powerpc\*-\*linux\*|,aarch64*-*linux*|&,
' libtool.m4 */configure

sed -i 's/%%{release}/%release/g' bfd/Makefile{.am,.in}

%build
%define _configure_target --host=%_target_platform --build=%_target_platform
%undefine __libtoolize
ADDITIONAL_TARGETS=
%ifarch %ix86 x86_32
ADDITIONAL_TARGETS="--enable-64-bit-bfd"
%endif
%ifarch ia64 x86_64
ADDITIONAL_TARGETS="--enable-targets=i386-alt-linux"
%endif
%ifarch ppc
ADDITIONAL_TARGETS="--enable-targets=powerpc64-alt-linux --enable-targets=spu --enable-64-bit-bfd"
%endif
%configure \
	--enable-shared \
	--with-pic \
	--disable-werror \
	--enable-plugins \
	--with-bugurl=http://bugzilla.altlinux.org/ \
	--enable-gold=yes --enable-ld=default \
	--with-stage1-ldflags=' ' \
	--with-boot-ldflags=' ' \
	$ADDITIONAL_TARGETS

for t in configure-host maybe-all-{libiberty,bfd,opcodes} all; do
	%make_build MAKEINFOFLAGS=--no-split tooldir=%_prefix $t
done

%install
%makeinstall_std tooldir=%_prefix install-info

# Add alternatives files
install -d %buildroot%_altdir
echo "%_bindir/ld	%_bindir/ld.bfd	50" >  %buildroot%_altdir/ld-bfd
echo "%_bindir/ld	%_bindir/ld.gold	10" >  %buildroot%_altdir/ld-gold

# Remove /usr/bin/ld to avoid conflicts with alternatives
rm %buildroot%_bindir/ld

# Install PIC version of the libiberty.a
install -pm644 libiberty/pic/libiberty.a %buildroot%_libdir/

# Remove unrelated manpages.
find %buildroot%_man1dir -type f |while read f; do
	n="${f##*/}"
	n="${n%%.1*}"

	# ld uses alternatives
	[ "$n" != "ld" ] || continue

	[ -f "%buildroot%_bindir/$n" ] || rm -v "$f"
done

%ifarch %ix86 x86_32 ppc
# Sanity check --enable-64-bit-bfd really works.
grep -Fqsx '#define BFD_ARCH_SIZE 64' %buildroot%_prefix/include/bfd.h
%endif

# Generate .so linker scripts for dependencies; imported from glibc/Makerules:

# Remove symlinks
rm -f %buildroot%_libdir/lib{bfd,opcodes}.so

# This fragment of linker script gives the OUTPUT_FORMAT statement
# for the configuration we are building.
OUTPUT_FORMAT="\
/* Ensure this .so library will not be used by a link for a different format
   on a multi-architecture system.  */
$(gcc $CFLAGS $LDFLAGS -shared -x c /dev/null -o /dev/null -Wl,--verbose -v 2>&1 |
	sed -n -f "%_sourcedir/output-format.sed")"

cat >%buildroot%_libdir/libbfd.so <<EOF
/* GNU ld script */

$OUTPUT_FORMAT

/* The -lz and -ldl dependencies are unexpected by legacy build scripts.  */
INPUT ( %_libdir/libbfd.a -liberty -ldl -lz )
EOF

cat >%buildroot%_libdir/libopcodes.so <<EOF
/* GNU ld script */

$OUTPUT_FORMAT

INPUT ( %_libdir/libopcodes.a -lbfd )
EOF

# Relocate include files.
pushd %buildroot%_includedir
	mkdir bfd
	for f in *.h; do
		mv "$f" bfd/
		ln -s bfd/"$f" .
	done
popd

# Cleanup config.h remnants
sed -i '/PR 14072:/,/^#endif/d' %buildroot%_includedir/bfd/bfd.h
sed -i '/HAVE_STDINT_H/,/^#endif/d; /#include <sys\/types.h>/i#include <stdint.h>' \
	%buildroot%_includedir/bfd/plugin-api.h

# Workaround multilib issues
wordsize=$(printf '%%s\n%%s' '#include <bits/wordsize.h>' '__WORDSIZE' | gcc -E -P -)
mv %buildroot%_includedir/bfd/bfd{,-$wordsize}.h
install -pm644 %_sourcedir/bfd.h %buildroot%_includedir/bfd/

# Add more include files.
install -pm644 include/libiberty.h %buildroot%_includedir/
install -pm644 bfd/{elf-bfd,lib*}.h %buildroot%_includedir/bfd/
cp -a include/{coff,elf,nlm} %buildroot%_includedir/bfd/
rm %buildroot%_includedir/bfd/{*in.h,*/ChangeLog*}

# Install NEWS.
for n in binutils gas ld; do
	install -pm644 $n/NEWS NEWS-$n
done

%find_lang binutils bfd gas gold gprof ld opcodes --append --output files.lst

%set_verify_elf_method strict

%check
[ -w /dev/ptmx -a -f /proc/self/maps ] || exit
# testsuite requires gcc to be able to print path to liblto_plugin.so
GCC_PFN_LTO=$(gcc -print-file-name=liblto_plugin.so)
GCC_PPN_LTO=$(gcc -print-prog-name=liblto_plugin.so)
[ "$GCC_PFN_LTO" != 'liblto_plugin.so' -o "$GCC_PPN_LTO" != 'liblto_plugin.so' ] || exit
RUNTESTFLAGS=
XFAIL_TESTS=
%make_build -k check CC="%_sourcedir/gcc.sh" CXX="%_sourcedir/g++.sh" \
	XFAIL_TESTS="$XFAIL_TESTS" RUNTESTFLAGS="$RUNTESTFLAGS"

%files devel
%_libdir/*.a
%_libdir/libbfd.so
%_libdir/libopcodes.so
%_includedir/bfd/
%_includedir/*.h
%_infodir/bfd.info*

%files -f files.lst
%_bindir/*
%_altdir/ld-*
%_prefix/lib/ldscripts/
%_mandir/man?/*
%_libdir/*-*.so
%_infodir/*.info*
%exclude %_infodir/bfd.info*
%doc NEWS*

%changelog
