Name: bitcoin
Version: 0.16.3
Release: alt0.M80P.1

Summary: peer-to-peer network based anonymous digital currency
License: MIT
Group: Networking/Other

Url: http://www.bitcoin.org/
Source: %name-%version.tar

# Automatically added by buildreq on Thu Sep 14 2017
# optimized out: boost-devel boost-devel-headers gcc-c++ glibc-kernheaders-generic glibc-kernheaders-x86 gnu-config libcom_err-devel libdb4-devel libgpg-error libkrb5-devel libqt5-core libqt5-dbus libqt5-gui libqt5-network libqt5-test libqt5-widgets libqt5-xml libstdc++-devel llvm perl pkg-config python-base python-modules qt5-base-common
BuildRequires: boost-filesystem-devel boost-interprocess-devel boost-program_options-devel boost-signals-devel
BuildRequires: clang lcov libevent-devel libminiupnpc-devel libprotobuf-devel libqrencode-devel
BuildRequires: libssl-devel protobuf-compiler python-module-mpl_toolkits qt5-base-devel qt5-tools libdb4.8_cxx-devel

%description
Q. What is Bitcoin?
A. Bitcoin is a peer-to-peer currency. Peer-to-peer means that no
central authority issues new money or tracks transactions. These tasks
are managed collectively by the network.

Q. How does Bitcoin work?
A. Bitcoin utilises public-key cryptography. A coin contains the owner's
public key. When a coin is transferred from user A to user B, A adds B's
public key to the coin, and the coin is signed using A's private key. B
now owns the coin and can transfer it further. A is prevented from
transferring the already spent coin to other users because a public list
of all previous transactions is collectively maintained by the network.
Before each transaction the coin's validity will be checked.

%prep
%setup

%build
./autogen.sh
export OBJC=clang
export OBJCXX=clang++
%configure \
	--enable-upnp-default \
	--with-gui=qt5
%make_build V=1

%install
%makeinstall_std
ln -s %name-qt %buildroot%_bindir/%name

%pre
rm -f %_bindir/%name

%files
%_bindir/%{name}*
%_mandir/man1/bitcoin*.1.*
%doc doc/*

%changelog
