Name: blackbox
Version: 0.70.1
Release: alt3

Summary: A Window Manager for the X Window System
License: BSD-style
Group: Graphical desktop/Other
Url: http://blackboxwm.sourceforge.net/

Source0: http://prdownloads.sf.net/blackboxwm/%name-%version.tar.bz2
Source1: %name.menu-method
Source2: %name.menu
Source3: %name-16.png
Source4: %name-32.png
Source5: %name-48.png
Source6: %name-64.png
Source7: %name.wmsession
Source8: %name.alternatives
Source9: %name-gencat-wrapper

Patch0: blackbox-0.70.1-gcc43.patch
Patch1: blackbox-0.70.1-Xutil.patch
Patch10: blackbox-0.70.1-alt-style.patch
Patch11: blackbox-0.70.1-alt-nls.patch

# Automatically added by buildreq on Tue Mar 12 2013
# optimized out: alternatives fontconfig fontconfig-devel gnu-config libX11-devel libXrender-devel libfreetype-devel libstdc++-devel pkg-config xorg-renderproto-devel xorg-xextproto-devel xorg-xproto-devel
BuildRequires: gcc-c++ imake libXext-devel libXft-devel xorg-cf-files

%description
This is a window manager for X.  It is similar in many respects to
such popular packages as Window Maker, Enlightenment, and FVWM2.  You
might be interested in this package if you are tired of window managers
that are a heavy drain on your system resources, but you still want
an attractive and modern-looking interface.

The best part of all is that this program is coded in C++, so it
is even more attractive "under the hood" than it is in service -- no
small feat.

If none of this sounds familiar to you, or you want your computer to
look like Windows 98, you probably don't want this package.

%package devel
Summary: Blackbox Toolbox library for writing small applications
Group: Development/C++
Requires: %name = %version-%release

%description devel
This package contains the Blackbox Toolbox files, headers and static library
of the utility class library for writing small applications.

%prep
%setup -q
%patch10 -p0
%patch11 -p0

%patch0 -p1 -b .gcc43
%patch1 -p1 -b .Xutil

pushd nls
  for enc in KOI8-R CP1251 UTF-8; do
    mkdir ru_RU.$enc
    pushd ru_RU
    for f in *; do
      iconv -f KOI8-R -t $enc <"$f" >../ru_RU.$enc/"$f"
    done
    popd
    sed -i -e "s/ru_RU/ru_RU.$enc/" ru_RU.$enc/*
  done
  sed -i -e 's/ru_RU/ru_RU.KOI8-R ru_RU.CP1251 ru_RU.UTF-8/' Makefile*
popd

install -p %SOURCE9 ./gencat-wrapper

%build
export gencat_cmd="`pwd`/gencat-wrapper"
autoreconf -i -f
%configure \
    --enable-shared \
    --disable-static \
    --sysconfdir=%_sysconfdir/X11/%name \
    --enable-nls

%make_build DEFAULT_MENU=%_sysconfdir/X11/%name/%name-menu

%install
%make_install DESTDIR=%buildroot install

mv %buildroot%_bindir/bsetbg   %buildroot%_bindir/bsetbg-%name
mv %buildroot%_bindir/bsetroot %buildroot%_bindir/bsetroot-%name
mv %buildroot%_man1dir/bsetbg.1 %buildroot%_man1dir/bsetbg-%name.1
mv %buildroot%_man1dir/bsetroot.1 %buildroot%_man1dir/bsetroot-%name.1

install -pD -m755 %SOURCE1 %buildroot%_sysconfdir/menu-methods/%name
install -pD -m644 %SOURCE2 %buildroot%_menudir/%name
install -pD -m644 %SOURCE3 %buildroot%_miconsdir/%name.png
install -pD -m644 %SOURCE4 %buildroot%_niconsdir/%name.png
install -pD -m644 %SOURCE5 %buildroot%_liconsdir/%name.png
install -pD -m644 %SOURCE6 %buildroot%_iconsdir/hicolor/64x64/apps/%name.png
install -pD -m644 %SOURCE7 %buildroot%_sysconfdir/X11/wmsession.d/07%name
install -pD -m644 %SOURCE8 %buildroot%_altdir/%name

install -pD -m644 /dev/null %buildroot%_sysconfdir/X11/%name/%name-menu

%files
%doc AUTHORS COMPLIANCE ChangeLog* LICENSE README* RELNOTES TODO
%_bindir/blackbox
%_bindir/bsetbg*
%_bindir/bsetroot*
%_bindir/bstyleconvert
%_man1dir/*
%dir %_datadir/%name
%_datadir/%name/
%_libdir/libbt.so.*
# alt specific
%_menudir/*
%config(noreplace) %_sysconfdir/menu-methods/*
%config %_sysconfdir/X11/wmsession.d/*
%dir %_sysconfdir/X11/%name
%ghost %_sysconfdir/X11/%name/%name-menu
%_altdir/%name
%_iconsdir/hicolor/??x??/apps/*.png

%files devel
%_libdir/libbt.so
%dir %_includedir/bt
%_includedir/bt/*.hh
%_pkgconfigdir/libbt.pc

%changelog
