# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
%define _unpackaged_files_terminate_build 1

Name: blender
Version: 2.79b
Release: alt5.M80P.1

Summary: 3D modeling, animation, rendering and post-production
License: GPLv2
Group: Graphics
URL: http://www.blender.org/

# Repacked http://download.blender.org/source/blender-%%version.tar.gz
Source: %name-%version.tar

Patch11: 0001-blender_thumbnailer.patch
Patch12: 0002-install_in_usr_share.patch
Patch13: 0003-locales_directory_install.patch
Patch14: 0004-update_manpages.patch
Patch15: 0005-do_not_use_version_number_in_system_path.patch
Patch16: 0006-look_for_dejavu_ttf_with_fontconfig.patch

# https://git.archlinux.org/svntogit/community.git/tree/trunk/ffmpeg4.0.patch?h=packages/blender&id=059566c3ec72
Patch17: blender-2.79-arch-ffmpeg40.patch

Patch21: blender-2.66-alt-pcre.patch
Patch22: blender-2.77-alt-enable-localization.patch
Patch23: blender-2.77-alt-usertempdir.patch
Patch24: blender-2.79-upstream-gcc8.patch
Patch25: blender-2.79-alt-gcc8.patch
Patch26: blender-2.79-slackbuilds-PyRNA-python3.7.patch
Patch27: blender-2.79-fedora-oiio2.patch

BuildRequires(pre): rpm-build-python3

# Automatically added by buildreq on Mon Oct 31 2016
# optimized out: boost-devel boost-devel-headers cmake-modules fontconfig libGL-devel libGLU-devel libX11-devel libXau-devel libXext-devel libXfixes-devel libavcodec-devel libavutil-devel libfreetype-devel libstdc++-devel pkg-config python-base python-modules python3 python3-base xorg-fixesproto-devel xorg-inputproto-devel xorg-kbproto-devel xorg-xproto-devel zlib-devel
BuildRequires: boost-filesystem-devel boost-locale-devel
BuildRequires: cmake gcc-c++
BuildRequires: fontconfig-devel libGLEW-devel libXi-devel
BuildRequires: libavdevice-devel libavformat-devel
BuildRequires: libfftw3-devel libjack-devel libopenal-devel libsndfile-devel
BuildRequires: libjpeg-devel libopenjpeg-devel libpng-devel libtiff-devel libpcre-devel libswscale-devel libxml2-devel
BuildRequires: liblzo2-devel
BuildRequires: libopenCOLLADA-devel >= 0-alt3
BuildRequires: python3-devel >= 3.5
#BuildRequires: libopenimageio-devel
#BuildRequires: libopencolorio-devel
BuildRequires: openexr-devel
BuildRequires: libpugixml-devel

%add_python3_path %_datadir/%name/scripts
%add_python3_req_skip BPyWindow
%add_python3_req_skip _bpy
%add_python3_req_skip _bpy_path
%add_python3_req_skip _freestyle
%add_python3_req_skip _cycles
%add_python3_req_skip bge
%add_python3_req_skip bgl
%add_python3_req_skip blend
%add_python3_req_skip blf
%add_python3_req_skip enchant
%add_python3_req_skip mathutils
%add_python3_req_skip mathutils.geometry
%add_python3_req_skip mathutils.noise

%py3_provides BPyMesh
%py3_provides Blender
%py3_provides bmesh
%py3_provides bpy
%py3_provides bpy.props
%py3_provides bpy.types
%py3_provides bpy.app.translations
%py3_provides bpy.app.handlers
%py3_provides bpy.app

Requires: libopenCOLLADA >= 0-alt3

Obsoletes: %name-i18n

%description
Fully integrated creation suite, offering a broad range of essential
tools for the creation of 3D content, including modeling, uv-mapping,
texturing, rigging, skinning, animation, particle and other simulation,
scripting, rendering, compositing, post-production and game creation

%description -l ru_RU.UTF-8
Полностью интегрированный пакет разработки, предлагающий широкий
выбор инструментов необходимых для создания 3D-графики. Включает
средства моделирования, анимации, рендеринга, постобработки видео,
а также создания интерактивных игр. Пакет имеет такие функции,
как динамика твердых тел, жидкостей и мягких тел, систему горячих
клавиш, большое количество легко доступных расширений, написанных
на языке Python.

%prep
%setup

# debian
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1

#patch17 -p1

%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p2
#patch26 -p1
%patch27 -p1

%ifnarch %ix86 x86_64
sed -i 's,-fuse-ld=gold,,' build_files/cmake/platform/platform_unix.cmake
%endif

%build
BUILD_DATE="$(stat -c '%%y' '%SOURCE0' | date -f - '+%%Y-%%m-%%d')"
BUILD_TIME="$(stat -c '%%y' '%SOURCE0' | date -f - '+%%H:%%M:%%S')"

# needed due to non-standard location of pcre.h header
%add_optflags "$(pkg-config --cflags libpcre)"

%add_optflags -fPIC -funsigned-char -fno-strict-aliasing

export CFLAGS="%optflags"
export CXXFLAGS="%optflags"

mkdir cmake-make
pushd cmake-make

cmake .. \
  -DCMAKE_INSTALL_PREFIX=%{_prefix} \
%ifnarch %{ix86} x86_64
  -DWITH_RAYOPTIMIZATION=OFF \
  -DWITH_CPU_SSE=OFF \
%endif
 -DCMAKE_SKIP_RPATH=ON \
 -DBUILD_SHARED_LIBS=OFF \
 -DWITH_FFTW3=ON \
 -DWITH_JACK=ON \
 -DWITH_CODEC_SNDFILE=ON \
 -DWITH_IMAGE_OPENJPEG=ON \
 -DWITH_PYTHON=ON \
 -DWITH_PYTHON_INSTALL=OFF \
 -DWITH_CODEC_FFMPEG=ON \
 -DWITH_GAMEENGINE=ON \
 -DWITH_CXX_GUARDEDALLOC=OFF \
 -DWITH_INSTALL_PORTABLE=OFF \
 -DWITH_PYTHON_SAFETY=ON \
 -DWITH_PLAYER=ON \
 -DWITH_OPENMP=OFF \
 -DWITH_OPENCOLLADA=ON \
 -DWITH_FONTCONFIG=ON \
 -DWITH_CYCLES=OFF \
 -DWITH_OPENCOLORIO=OFF \
 -DWITH_OPENIMAGEIO=OFF \
 -DWITH_SYSTEM_GLEW=ON \
 -DWITH_SYSTEM_LZO=ON \
 -DWITH_SYSTEM_OPENJPEG=ON \
 -DWITH_IMAGE_OPENEXR=ON \
 -DPYTHON_VERSION="%_python3_version" \
 -DBUILDINFO_OVERRIDE_DATE="$BUILD_DATE" \
 -DBUILDINFO_OVERRIDE_TIME="$BUILD_TIME" \
 #

popd

%make_build -C cmake-make

%install
%makeinstall_std -C cmake-make

%find_lang blender

%files -f %name.lang
%_bindir/*
%_desktopdir/*
%_iconsdir/hicolor/*/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_datadir/%name/
%_defaultdocdir/%name/

%changelog
