%define orig_name blender

Name: blender2.49
Version: 2.49b
Release: alt12.qa1

Summary: 3D modeling, animation, rendering and post-production
License: GPL
Group: Graphics
URL: http://www.blender.org/
Packager: ALT QA Team <qa@packages.altlinux.org>

Source0: http://download.blender.org/source/blender-%version.tar.gz
Source1: blender-wrapper
Source2: blender.desktop
Source3: blender-win.desktop
Patch1: blender-2.47-alt-libtiff5.patch
Patch2: blender-2.47-alt-usertempdir.patch
Patch3: blender-2.49b-alt-ld.patch
Patch4: blender-2.49b-alt-qhull.patch
Patch5: blender-2.49b-alt-libav.patch
Patch6: blender-2.49b-alt-i18n.patch
Patch7: blender-2.49b-alt-rename.patch
Patch8: blender-2.49b-alt-gcc4.6.patch

Provides: python%_python_version(Blender)
Provides: python%_python_version(bpy)
Provides: python%_python_version(BPyMesh)

Requires: %name-i18n = %version-%release

%if "%_lib" == "lib64"
%define lib_suffix ()(64bit)
%else
%define lib_suffix %nil
%endif
Requires: libtiff.so.5%lib_suffix

# Automatically added by buildreq on Sun Dec 19 2010
BuildRequires: flex gcc-c++ libSDL-devel libXi-devel libavdevice-devel libftgl-devel libglew-devel libjpeg-devel libopenal-devel libpng-devel libpth-devel libswscale-devel libtiff-devel openexr-devel python-devel python-modules-email scons swig

BuildPreReq: libavformat-devel libalut-devel libqhull-devel

%description
Fully integrated creation suite, offering a broad range of essential
tools for the creation of 3D content, including modeling, uv-mapping,
texturing, rigging, skinning, animation, particle and other simulation,
scripting, rendering, compositing, post-production and game creation

%description -l ru_RU.UTF-8
Полностью интегрированный пакет разработки, предлагающий широкий
выбор инструментов необходимых для создания 3D-графики. Включает
средства моделирования, анимации, рендеринга, постобработки видео,
а также создания интерактивных игр. Пакет имеет такие функции,
как динамика твердых тел, жидкостей и мягких тел, систему горячих
клавиш, большое количество легко доступных расширений, написанных
на языке Python.

%package i18n
Group: Graphics
Summary: Languages support for blender
Requires: %name = %version-%release
BuildArch: noarch

%description i18n
Languages support for blender

%prep
%setup -q -n %{orig_name}-%version
%patch1 -p1
%patch2 -p1
%patch3 -p2
%patch4 -p2
%patch5 -p2
%patch6 -p1
%patch7 -p1
%patch8 -p2

find -type f -print0 |
	xargs -r0 grep -FlZ '#include "math.h"' |
	xargs -r0 sed -i 's/#include "math\.h"/#include <math.h>/' --

sed -i 's|BulletSoftBody//|BulletSoftBody/|' source/gameengine/Physics/Bullet/CcdPhysicsController.cpp

sed -i 's|\(CFLAGS\=\"\)|\1 -g |' release/plugins/bmake
sed -i '36a\#include <GL/gl.h>' \
	source/blender/ftfont/intern/FTF_TTFont.h
rm -fR extern/fftw extern/qhull

%build
cat >user-config.py <<__EOF__
BF_PYTHON_VERSION = '%_python_version'

WITH_BF_PLAYER = 'true'

WITH_BF_OPENAL = 'true'

WITH_BF_QUICKTIME = 'false'

WITH_BF_FFMPEG = 'false'
BF_FFMPEG = '%_usr'
BF_FFMPEG_INC = '%_includedir'
BF_FFMPEG_LIBPATH='%_libdir'
BF_FFMPEG_LIB = 'avformat avcodec avutil swscale avdevice'

WITH_BF_ODE = 'true'
BF_ODE = '%_usr'
BF_ODE_INC = '%_includedir/ode'
BF_ODE_LIB = 'ode'

WITH_BF_GAMEENGINE = 'true'

WITH_BF_INTERNATIONAL = 'true'

WITH_BF_ICONV = 'true'
BF_ICONV = '%_libdir/gconv'
BF_ICONV_INC = '%_libdir'
BF_ICONV_LIB = ''
BF_ICONV_LIBPATH = '%_libdir'

WITH_BF_FTGL = 'true'
BF_FTGL = '%_usr'
BF_FTGL_INC = '%_includedir/FTGL'
BF_FTGL_LIB = 'ftgl'

WITH_BF_GETTEXT = 'true'
BF_GETTEXT_LIBPATH='%_libdir'
BF_GETTEXT_INC='%_includedir'

WITH_BF_FREETYPE = 'true'
BF_FREETYPE = '%_usr'
BF_FREETYPE_INC = '%_includedir/freetype2'
BF_FREETYPE_LIB = 'freetype'

WITH_BF_STATICOPENGL = 'false'
BF_OPENGL = '%_usr'
BF_OPENGL_INC = '%_includedir/GL'
BF_OPENGL_LIB = 'GLEW GL GLU X11 Xi'

BF_BUILDDIR = 'build/linux'
BF_INSTALLDIR='release/linux'

CPPFLAGS = '-g -I%_includedir/python%_python_version -fpermissive'
__EOF__
scons -j %__nprocs BF_QUIET=0

pushd release/linux/plugins
/bin/ln -s ../../../source/blender/blenpluginapi include
/bin/chmod +x bmake
%make
popd

%install
/bin/install -pD -m755 release/linux/%orig_name %buildroot%_bindir/%{orig_name}-bin2.49
/bin/install -pD -m755 release/linux/%{orig_name}player %buildroot%_bindir/%{orig_name}player2.49
/bin/install -pD -m755 %SOURCE1 %buildroot%_bindir/%name
sed -i -e 's|@LIBDIR@|%_libdir|' %buildroot%_bindir/%name

# icons and .desktop files
/bin/install -pD -m644 release/freedesktop/icons/16x16/%{orig_name}.png %buildroot%_miconsdir/%name.png
/bin/install -pD -m644 release/freedesktop/icons/32x32/%{orig_name}.png %buildroot%_niconsdir/%name.png
/bin/install -pD -m644 release/freedesktop/icons/scalable/%{orig_name}.svg %buildroot%_iconsdir/hicolor/scalable/apps/%name.svg
/bin/install -pD -m644 %SOURCE2 %buildroot%_desktopdir/%name.desktop
/bin/install -pD -m644 %SOURCE3 %buildroot%_desktopdir/%name-win.desktop

/bin/install -d %buildroot%_libdir/%name/plugins/sequence
/bin/install -d %buildroot%_libdir/%name/plugins/texture
/bin/install -pD -m644 release/linux/plugins/sequence/*.so %buildroot%_libdir/%name/plugins/sequence
/bin/install -pD -m644 release/linux/plugins/texture/*.so %buildroot%_libdir/%name/plugins/texture

/bin/cp -a release/linux/.blender/scripts %buildroot%_libdir/%name/scripts

pushd release/linux/.blender/locale
for i in *; do
  pushd $i/LC_MESSAGES
  mv %{orig_name}.mo %name.mo
  popd
done
popd

/bin/cp -a release/linux/.blender/locale %buildroot%_datadir

/bin/install -d %buildroot%_datadir/%name
/bin/install -m644 release/VERSION %buildroot%_datadir/%name
/bin/install -m644 bin/.blender/.Blanguages %buildroot%_datadir/%name

#/bin/rm -rf %buildroot%_bindir
#/bin/rm -rf %buildroot%_desktopdir
#/bin/rm -rf %buildroot%_datadir/locale
#/bin/rm -rf %buildroot%_niconsdir
#/bin/rm -rf %buildroot%_miconsdir
#/bin/rm -rf %buildroot%_iconsdir/hicolor/scalable/apps/%name.svg
%find_lang %name

%files
%doc README release/linux/*.pdf release/linux/release_*.txt release/linux/blender.html
%_bindir/*
%_desktopdir/*
%_libdir/%name/

%_niconsdir/%name.png
%_miconsdir/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg

%_datadir/%name/
%exclude %_datadir/%name/.Blanguages

%files i18n -f %name.lang
%_datadir/%name/.Blanguages

%changelog
