%define _libexecdir %_prefix/libexec
%def_enable obex
# since 5.44 the following tools marked as deprecated:
# hciattach hciconfig hcitool hcidump rfcomm sdptool ciptool gatttool
%def_enable deprecated

Name: bluez
Version: 5.44
Release: alt0.M80P.1

Summary: Bluetooth utilities
License: GPLv2+
Group: Networking/Other
URL: http://www.bluez.org/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Conflicts: udev-extras < 169

Source: %name-%version.tar
Patch: %name-%version-%release.patch
# fc
Patch10: 0001-Allow-using-obexd-without-systemd-in-the-user-session.patch

Obsoletes: bluez-alsa < 5.0
Obsoletes: obex-data-server < 0.4.6-alt3

BuildRequires: glib2-devel libudev-devel libdbus-devel libreadline-devel
BuildRequires: systemd-devel gtk-doc
%{?_enable_obex:BuildRequires: libical-devel libicu-devel}

%description
Bluetooth protocol stack for Linux

%package -n lib%name
Summary: Libraries for use in Bluetooth applications
Group: System/Libraries
Obsoletes: lib%{name}4

%description -n lib%name
Libraries for use in Bluetooth applications

%package -n lib%name-devel
Summary: Development libraries for Bluetooth applications
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
lib%name-devel contains development libraries and headers for
use in Bluetooth applications

%package cups
Summary: CUPS printer backend for Bluetooth printers
Group: Networking/Other
Requires: %name = %version-%release

%description cups
This package contains the CUPS backend

%prep
%setup
%patch -p1
%patch10 -p1

%build
%autoreconf
export CFLAGS="$CFLAGS -D_FILE_OFFSET_BITS=64"
%configure \
	--enable-library \
	--enable-threads \
	%{subst_enable obex} \
	--enable-cups \
	--enable-tools \
	--localstatedir=%_var \
	%{subst_enable deprecated}
%make_build

%install
%makeinstall_std
%{?_enable_deprecated:install -m755 attrib/gatttool %buildroot%_bindir/}
install -pD -m755 scripts/bluetooth.alt.init %buildroot%_initdir/bluetoothd
ln -s bluetooth.service %buildroot%_unitdir/bluetoothd.service
mkdir -p %buildroot%_libdir/bluetooth/plugins %buildroot%_localstatedir/bluetooth
# configdir
mkdir -p %buildroot%_sysconfdir/bluetooth

find %buildroot%_libdir -name \*.la -delete

%check
%make check

%post
%post_service bluetoothd
if [ $1 = 1 ]; then
	chkconfig bluetoothd on
fi

%preun
%preun_service bluetoothd

%triggerin -- %name <= 4.37-alt1
chkconfig bluetoothd on

%files
%doc AUTHORS ChangeLog README
%dir %_sysconfdir/bluetooth
%_initdir/bluetoothd
%config %_sysconfdir/dbus-1/system.d/bluetooth.conf
%_unitdir/*.service
%_prefix/lib/systemd/user/obex.service
/lib/udev/rules.d/*-hid2hci.rules
/lib/udev/hid2hci
%_bindir/bccmd
%_bindir/bluemoon
%_bindir/bluetoothctl
%_bindir/btattach
%_bindir/btmon
%_bindir/hex2hcd
%_bindir/l2ping
%_bindir/l2test
%_bindir/mpris-proxy
%_bindir/rctest

%if_enabled deprecated
%_bindir/ciptool
%_bindir/gatttool
%_bindir/hciattach
%_bindir/hciconfig
%_bindir/hcidump
%_bindir/hcitool
%_bindir/rfcomm
%_bindir/sdptool
%endif

%_libdir/bluetooth/
%_libexecdir/bluetooth/
%_datadir/dbus-1/system-services/org.bluez.service
%_datadir/dbus-1/services/org.bluez.obex.service
%_localstatedir/bluetooth
%_man1dir/*.1*
%_man8dir/*.8*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/bluetooth
%_libdir/*.so
%_pkgconfigdir/*.pc

%files cups
%_prefix/lib/cups/backend/bluetooth

%changelog
