%define ver_major 3.12
%define brasero_api_ver 3
%define nau_api_ver 3.0
%define gst_api_ver 1.0

%def_enable gtk_doc
# Make use of Tracker
%def_enable search
# Embed a playlist functionality based on libtotem
%def_enable playlist
%def_enable cdrkit
%def_disable cdrtools
%def_enable cdrdao
%def_disable libburnia
%def_enable introspection

Name: brasero
Version: %ver_major.2
Release: alt0.M80P.1

Summary: CD/DVD burning tool for GNOME.
Group: Archiving/Cd burning
License: %gpl2plus
Url: http://www.gnome.org/projects/brasero/

#Source: %name-%version.tar
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
Patch: %name-2.27.90-alt-link.patch
Patch1: %name-2.28.1-alt-button-underline.patch
Patch2: %name-2.32.1-schemas_convert_typo.patch

Requires: lib%name = %version-%release

Requires: dvd+rw-tools
#Requires: cdrecord
Requires: cdrkit
Requires: mkisofs
%{?_enable_cdrdao:Requires: cdrdao}

# to make vcd or video dvd
Requires: dvdauthor vcdimager gst-plugins-bad%gst_api_ver

BuildPreReq: gnome-common rpm-build-gnome rpm-build-licenses

# From configure.ac
BuildPrereq: libgio-devel >= 2.30.0
BuildPreReq: libgtk+3-devel >= 3.0.0
BuildPreReq: gstreamer%gst_api_ver-devel >= 0.11.99
BuildPreReq: gst-plugins%gst_api_ver-devel >= 0.11.99
BuildPreReq: libxml2-devel >= 2.6.0
%{?_enable_libburnia:BuildPreReq: libburn-devel >= 0.4.0 libisofs-devel >= 0.6.4}
BuildPreReq: libnotify-devel >= 0.7
%{?_enable_search:BuildPreReq: tracker-devel >= 1.0}
%{?_enable_playlist:BuildPreReq: libtotem-pl-parser-devel >= 2.30.2}
BuildPreReq: intltool >= 0.35.0
BuildPrereq: libcanberra-gtk3-devel
BuildPreReq: gtk-doc >= 1.11
BuildRequires: yelp-tools itstool
BuildRequires: libSM-devel
# for nautilus extension
BuildRequires: libnautilus-devel
# GObject introspection support
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel libgtk+3-gir-devel}

%description
Brasero is an application to burn CD/DVD for the Gnome Desktop. It is designed
to be as simple as possible and has some unique features to enable users to
create their discs easily and quickly.

%package -n lib%name
Summary: Shared library for Brasero CD/DVD burning application
Group: System/Libraries

%description -n lib%name
Brasero is an application to burn CD/DVD for the Gnome Desktop. It is designed
to be as simple as possible and has some unique features to enable users to
create their discs easily and quickly.

This package provides shared library required for Brasero to work.

%package -n lib%name-devel
Summary: Development files and libraries for Brasero CD/DVD burning application
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Brasero is an application to burn CD/DVD for the Gnome Desktop. It is designed
to be as simple as possible and has some unique features to enable users to
create their discs easily and quickly.

This package provides files and library required to develop applications
that use libbrasero.

%package -n lib%name-devel-doc
Summary: Development documentation for Brasero CD/DVD burning application
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name < %version

%description -n lib%name-devel-doc
Brasero is an application to burn CD/DVD for the Gnome Desktop. It is designed
to be as simple as possible and has some unique features to enable users to
create their discs easily and quickly.

This package provides usefull documentation to develop applications
that use libbrasero.

%package nautilus
Summary: Nautilus extension for the Brasero CD/DVD burning application
Group: Archiving/Cd burning
Requires: %name = %version-%release

%description nautilus
This package provides integration with the Brasero for the Nautilus file
manager.

%package -n lib%name-gir
Summary: GObject introspection data for the Brasero
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the Brasero

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Brasero
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the Brasero

%prep
%setup
%patch -p1 -b .link
%patch1 -p1 -b .button_underline
%patch2 -b .schemas_convert

%build
%autoreconf
%configure \
	%{subst_enable libburnia} \
	%{subst_enable search} \
	%{subst_enable playlist} \
	%{subst_enable cdrkit} \
	%{subst_enable cdrtools} \
	%{subst_enable cdrdao} \
	%{subst_enable introspection} \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	--enable-preview \
	--enable-inotify \
	--disable-caches \
	--disable-static \
	--disable-schemas-compile

%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%dir %_libdir/%name%brasero_api_ver/plugins
%_libdir/%name%brasero_api_ver/plugins/lib%name-cdrdao.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-dvdcss.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-dvdrwformat.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-genisoimage.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-growisofs.so
%{?_enable_libburnia:%_libdir/%name%brasero_api_ver/plugins/lib%name-libburn.so}
%{?_enable_libburnia:%_libdir/%name%brasero_api_ver/plugins/lib%name-libisofs.so}
%_libdir/%name%brasero_api_ver/plugins/lib%name-local-track.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-checksum.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-checksum-file.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-normalize.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-readom.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-audio2cue.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-transcode.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-wodim.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-dvdauthor.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-vcdimager.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-vob.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-burn-uri.so

%if_enabled cdrtools
%_libdir/%name%brasero_api_ver/plugins/lib%name-cdrecord.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-readcd.so
%_libdir/%name%brasero_api_ver/plugins/lib%name-mkisofs.so
%endif

%_desktopdir/%name.desktop
%dir %_datadir/%name
%_datadir/%name/*
%_iconsdir/hicolor/*x*/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name-symbolic.svg
%_man1dir/%name.1.*
%_datadir/mime/packages/%name.xml
%config %_datadir/glib-2.0/schemas/org.gnome.brasero.gschema.xml
%_datadir/GConf/gsettings/brasero.convert
%_datadir/appdata/%name.appdata.xml

%exclude %_datadir/applications/brasero-nautilus.desktop
%exclude %_libdir/%name%brasero_api_ver/plugins/lib%name-*.la

%files nautilus
%_libdir/nautilus/extensions-%nau_api_ver/libnautilus-brasero-extension.so
%_datadir/applications/brasero-nautilus.desktop

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*.typelib

%files -n lib%name-gir-devel
%_girdir/*.gir
%endif

%exclude %_libdir/nautilus/extensions-%nau_api_ver/libnautilus-%name-extension.la

%changelog
