%global vernumber 086

Name: bsnes
Version: 0.%vernumber
Release: alt1.1
Summary: SNES emulator focused on accuracy

License: GPLv3
Group: Emulators
Url: http://byuu.org/bsnes/
Packager: Ilya Mashkin <oddity@altlinux.ru>
Source0: http://bsnes.googlecode.com/files/%{name}_v%vernumber-source.tar.bz2
Source2: README.bsnes
Patch1: bsnes-0.086-systemwide.patch

#bsnes does not use system snes_ntsc because the modified video processing
#filter algorithm calls back into bsnes specific c++ colortable code, that
#isn't available when the library is built stand alone
BuildRequires: desktop-file-utils
BuildRequires: libalut-devel
BuildRequires: libgtk+2-devel
BuildRequires: libao-devel
BuildRequires: libXv-devel
BuildRequires: libpulseaudio-devel
BuildRequires: libSDL-devel gcc-c++ libalsa-devel

%description
bsnes is an emulator that began development on 2004-10-14. The purpose of the
emulator is a bit different from other emulators: it focuses on accuracy,
debugging functionality, and clean code.
The emulator does not focus on things that would hinder accuracy. This
includes speed and game-specific hacks for compatibility. As a result, the
minimum system requirements for bsnes are quite high.

%prep
%setup -n %{name}_v%vernumber-source
%patch1 -p1 -b .systemwide

#fix permissions
find . -type f -not -name \*.sh -exec chmod 644 {} \;

#use system optflags
%add_optflags -fpermissive
sed -i "s/-O3/%optflags/" bsnes/Makefile
sed -i "s/-O3/%optflags -fPIC/" snesfilter/Makefile
sed -i "s/-O3/%optflags/" snespurify/cc-gtk.sh

#don't strip the binaries prematurely
sed -i "s/link += -s/link +=/" bsnes/Makefile
sed -i "s/link    := -s/link    :=/" snesfilter/Makefile
sed -i "s/-s //" snespurify/cc-gtk.sh

#use the proper compiler and moc commands
sed -i "s/g++-4.5/g++/" snespurify/cc-gtk.sh

#install fedora-specific readme
install -pm 644 %SOURCE2 README.bsnes

#use proper system-wide path for filters
sed -i 's@/usr/lib@%_libdir@' bsnes/ui/general/main-window.cpp

%build
#prepare for building compatibity and accuracy profile, as well as the debugger
cp -pR bsnes bsnes-accuracy
cp -pR bsnes laevateinn

pushd bsnes
make %{?_smp_mflags} compiler=gcc profile=compatibility phoenix=gtk
popd
pushd bsnes-accuracy
make %{?_smp_mflags} compiler=gcc profile=accuracy phoenix=gtk
popd
pushd laevateinn
make %{?_smp_mflags} compiler=gcc ui=ui-debugger phoenix=gtk
popd
pushd snesfilter
make %{?_smp_mflags} compiler=gcc
popd
pushd snespurify
./cc-gtk.sh
popd

%install
pushd bsnes
sed -i 's/Name=bsnes/Name=bsnes (Compatibility profile)/' data/bsnes.desktop
make install DESTDIR=$RPM_BUILD_ROOT prefix=%prefix
desktop-file-install --vendor=altlinux \
        --delete-original --dir $RPM_BUILD_ROOT%_datadir/applications \
        $RPM_BUILD_ROOT%_datadir/applications/bsnes.desktop
popd
pushd bsnes-accuracy
sed -i 's/Name=bsnes/Name=bsnes (Accuracy profile)/' data/bsnes.desktop
sed -i 's/Exec=bsnes/Exec=bsnes-accuracy/' data/bsnes.desktop
install -pm 755 out/bsnes $RPM_BUILD_ROOT%_bindir/bsnes-accuracy
desktop-file-install --dir $RPM_BUILD_ROOT%_datadir/applications \
         data/bsnes.desktop
popd
pushd laevateinn
install -pm 755 out/laevateinn $RPM_BUILD_ROOT%_bindir
popd
install -d $RPM_BUILD_ROOT%_datadir/%name
install -pm 644 bsnes/data/cheats.xml $RPM_BUILD_ROOT%_datadir/%name
install -d $RPM_BUILD_ROOT%_libdir/%name/filters
install -pm 755 snesfilter/out/*.filter $RPM_BUILD_ROOT%_libdir/%name/filters
install -pm 755 snespurify/snespurify-gtk $RPM_BUILD_ROOT%_bindir
install -d $RPM_BUILD_ROOT%_datadir/%name/shaders
install -pm 644 snesshader/*.shader $RPM_BUILD_ROOT%_datadir/%name/shaders

%files
%doc README.bsnes
%_bindir/bsnes
%_bindir/bsnes-accuracy
%_bindir/laevateinn
%_bindir/snespurify-gtk
%_libdir/bsnes
%_datadir/bsnes
%_datadir/pixmaps/bsnes.png
%_datadir/applications/bsnes.desktop
%_datadir/applications/altlinux-bsnes.desktop

%changelog
