%define _unpackaged_files_terminate_build 1

Name: btrfsmaintenance
Version: 0.4.2
Release: alt1
Summary: Scripts for btrfs periodic maintenance tasks
License: GPLv2
Group: System/Base
Url: https://github.com/kdave/btrfsmaintenance
Source0: %name-%version.tar
Patch: %name-%version-alt.patch
BuildArch: noarch

Requires: btrfs-progs

%description
Scripts for btrfs maintenance tasks like periodic scrub, balance, trim or defrag
on selected mountpoints or directories. Hints for periodic snapshot tuning (eg.
for snapper).

%prep
%setup
%patch -p1

%build
%install
# scripts
install -m 755 -d %buildroot%_datadir/%name/
install -m 755 btrfs-defrag.sh %buildroot%_datadir/%name/
install -m 755 btrfs-balance.sh %buildroot%_datadir/%name/
install -m 755 btrfs-scrub.sh %buildroot%_datadir/%name/
install -m 755 btrfs-trim.sh %buildroot%_datadir/%name/
install -m 755 btrfsmaintenance-refresh-cron.sh %buildroot%_datadir/%name/
install -m 644 btrfsmaintenance-functions %buildroot%_datadir/%name/

# systemd services and timers
install -m 755 -d %buildroot%_unitdir/
install -m 644 -D btrfsmaintenance-refresh.service %buildroot%_unitdir/
install -m 644 -D btrfsmaintenance-refresh.path %buildroot%_unitdir/
install -m 644 -D btrfs-balance.service %buildroot%_unitdir/
install -m 644 -D btrfs-defrag.service %buildroot%_unitdir/
install -m 644 -D btrfs-scrub.service %buildroot%_unitdir/
install -m 644 -D btrfs-trim.service %buildroot%_unitdir/
install -m 644 -D btrfs-balance.timer %buildroot%_unitdir/
install -m 644 -D btrfs-defrag.timer %buildroot%_unitdir/
install -m 644 -D btrfs-scrub.timer %buildroot%_unitdir/
install -m 644 -D btrfs-trim.timer %buildroot%_unitdir/

# config
install -m 644 -D sysconfig.btrfsmaintenance %buildroot%_sysconfdir/sysconfig/%name

%post
%post_service btrfsmaintenance-refresh
%post_service btrfs-balance
%post_service btrfs-defrag
%post_service btrfs-scrub
%post_service btrfs-trim

%preun
%preun_service btrfsmaintenance-refresh
%preun_service btrfs-balance
%preun_service btrfs-defrag
%preun_service btrfs-scrub
%preun_service btrfs-trim

%files
%doc COPYING README.md
%config(noreplace) %_sysconfdir/sysconfig/%name
%dir %_datadir/%name
%_datadir/%name/*
%_unitdir/btrfsmaintenance-refresh.path
%_unitdir/btrfsmaintenance-refresh.service
%_unitdir/btrfs-balance.service
%_unitdir/btrfs-defrag.service
%_unitdir/btrfs-scrub.service
%_unitdir/btrfs-trim.service
%_unitdir/btrfs-balance.timer
%_unitdir/btrfs-defrag.timer
%_unitdir/btrfs-scrub.timer
%_unitdir/btrfs-trim.timer

%changelog
