Group: Databases
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CGI.pm) perl(CGI/Carp.pm) perl(Encode.pm) perl(Module/Signature.pm) perl(Pod/Usage.pm) perl(charnames.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382

Name:           bucardo
Version:        5.5.0
Release:        alt0.M80P.1
Summary:        Postgres replication system for both multi-master and multi-slave operations
License:        BSD
URL:            http://bucardo.org/
Source0:        %name-%version.tar
Source1:        %name.service
BuildArch:      noarch

BuildRequires:  postgresql-perl

# Build
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)

# Runtime
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(Pod/PlainText.pm)
BuildRequires:  perl(Pod/Parser.pm)
BuildRequires:  perl(boolean.pm)
BuildRequires:  perl(open.pm)
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(DBD/Pg.pm)
BuildRequires:  perl(DBI.pm)
BuildRequires:  perl(DBIx/Safe.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(Net/SMTP.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(sigtrap.pm)
BuildRequires:  perl(Sys/Hostname.pm)
BuildRequires:  perl(Sys/Syslog.pm)
BuildRequires:  perl(Time/HiRes.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(Encode/Locale.pm)

# Extra
BuildRequires:  perl(MongoDB.pm)
BuildRequires:  perl(DBD/mysql.pm)
BuildRequires:  perl(Redis.pm)
BuildRequires:  perl(DBD/SQLite.pm)

# Tests only
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       postgresql-perl

Requires:  perl(MongoDB.pm)
Requires:  perl(DBD/mysql.pm)
Requires:  perl(Redis.pm)
Requires:  perl(DBD/SQLite.pm)

%description
Bucardo is an asynchronous PostgreSQL replication system, allowing for both
multi-master and multi-slave operations.It was developed at Backcountry.com
primarily by Greg Sabino Mullane of End Point Corporation.

%prep
%setup
# perl.req fails on -*-cperl-*-
sed -i -e 's,-- -\*-cperl-\*-,,' Bucardo.pm

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot} DESTINSTALLVENDORSHARE=%{buildroot}/%{_datadir}/%{name}
# removing packlist is required for building on fedora-epel
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
sed -i -e '1d;2i#!%{__perl}' %{name}
rm -f %{buildroot}/%{_bindir}/%{name}
install -p -d -m 0644 %buildroot/var/log/%name
install -Dp -m755 bucardo %{buildroot}/%{_sbindir}/%{name}
install -Dp -m644 %{name}.schema %{buildroot}/%{_datadir}/%{name}/%{name}.schema
install -pD -m 0644 %SOURCE1 %buildroot%systemd_unitdir/%name.service
# %{_fixperms} %{buildroot}/

%files
%doc --no-dereference LICENSE
%doc *.html Changes INSTALL README TODO
%dir /var/log/%name
%systemd_unitdir/%name.service
%{perl_vendor_privlib}/*
%{_sbindir}/%{name}
%{_datadir}/%{name}

%changelog
