%def_enable session
Name: cairo-dock
Version: 3.4.1
Release: alt4

Summary: A light and eye-candy dock to launch your programs easily
Summary(ru_RU.UTF-8): Приятный глазу док для простого запуска ваших программ
License: GPLv3+
Group: Graphical desktop/Other
# http://glx-dock.org
Url: https://launchpad.net/cairo-dock-core

Packager: Anton Midyukov <antohami@altlinux.org>
Source: %name-%version.tar
BuildPreReq: cmake rpm-macros-cmake
# Automatically added by buildreq on Wed Sep 09 2015 (-bi)
# optimized out: at-spi2-atk cmake-modules elfutils fontconfig glib-networking glib2-devel libGL-devel libX11-devel libXfixes-devel libXrender-devel libat-spi2-core libatk-devel libcairo-devel libcairo-gobject libcairo-gobject-devel libdbus-devel libdbus-glib libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libpango-devel libstdc++-devel libwayland-client libwayland-client-devel libwayland-cursor libwayland-egl libwayland-server pkg-config python-base wayland-devel xorg-compositeproto-devel xorg-fixesproto-devel xorg-kbproto-devel xorg-renderproto-devel xorg-xproto-devel
BuildRequires: ImageMagick-tools cmake desktop-file-utils gcc-c++ libGConf libGLU-devel libXcomposite-devel libcurl-devel libdbus-glib-devel libgtk+3-devel librsvg-devel libxml2-devel
%if_enabled session
BuildRequires: libpixman-devel libXtst-devel libXrandr-devel libXdmcp-devel libwayland-egl-devel 	libharfbuzz-devel libexpat-devel libdrm-devel libXdamage-devel libXxf86vm-devel libpng-devel libXinerama-devel libXcursor-devel 	libxkbcommon-x11-devel libwayland-cursor-devel libepoxy-devel at-spi2-atk-devel libat-spi2-core-devel
%endif

Requires: %name-data = %version

%description
Cairo-dock uses cairo to render nice graphics, and Glitz to use hardware
acceleration. It's fully configurable and can be a taskbar too. You can
easily plug applets into it.

%description -l ru_RU.UTF-8
Сairo-dock использует cairo для рендеринга приятной графики и Glitz для
задействования аппаратного ускорения. Это полностью настраиваемая и
многофункциональная панель задач. Вы можете легко включить апплеты не ней.

%package data
Summary: Data files for %name
Group: Graphical desktop/Other
BuildArch: noarch

%description data
Data files for %name

%if_enabled session
%package session
Summary: Session for %name
Group: Graphical desktop/Other
BuildArch: noarch
Requires: %name = %version

%description session
Session for %name
%endif

%package devel
Summary: Development files for cairo-dock
Group: Development/Other
Requires: %name = %version-%release

%description devel
cairo-dock uses cairo to render nice graphics, and Glitz to use hardware
acceleration. It's fully configurable and can be a taskbar too. You can
easily plug applets into it.

This package provides the include files and library for cairo-dock functions.

%prep
%setup -n %name-%version

%build
%cmake %{?_enable_session:-Denable-desktop-manager=ON}
%make_build -C BUILD

%install
%makeinstall_std -C BUILD

%find_lang %name

mkdir -p %buildroot{%_niconsdir,%_miconsdir,%_liconsdir}
convert data/cairo-dock.svg -resize 48x48 %buildroot%_liconsdir/%name.png
convert data/cairo-dock.svg -resize 16x16 %buildroot%_miconsdir/%name.png
convert data/cairo-dock.svg -resize 32x32 %buildroot%_niconsdir/%name.png
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=System \
	--add-category="GNOME;GTK;Utility;X-Desktop" \
	%buildroot%_desktopdir/cairo-dock.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=System \
	--add-category="GNOME;GTK;Utility;X-Desktop" \
	%buildroot%_desktopdir/cairo-dock-cairo.desktop

%files -f %name.lang
%_bindir/%name
%_libdir/*.so.*
%_libdir/%name/libcd-Help.so

%files data
%_datadir/%name
%_desktopdir/*.desktop
%_pixmapsdir/*.svg
%_niconsdir/%name.png
%_miconsdir/%name.png
%_liconsdir/%name.png
%_man1dir/*.1.*

%if_enabled session
%files session
%_bindir/%name-session
%_datadir/gnome-session/sessions/cairo-dock.session
%exclude %_datadir/xsessions/cairo-dock.desktop
%endif

%files devel
%_includedir/%name
%_libdir/*.so
%_pkgconfigdir/*.pc

%changelog
