Name:    castxml
Version: 0.0.1.20170823
Release: alt2%ubt
Summary: C-family abstract syntax tree XML output tool
Group:   Development/Other

# The main program is Apache 2.0
# src/kwsys/* is BSD
License: Apache 2.0 and BSD
URL:     https://github.com/CastXML/CastXML

# https://github.com/CastXML/CastXML.git
Source:	%name-%version.tar

# Link against the shared llvm library (one common library).
Patch1: %name-fedora-shared.patch

BuildRequires(pre): rpm-build-ubt
BuildRequires: cmake ctest gcc-c++
BuildRequires: llvm4.0-devel
# The llvm cmake files get confused if the static libraries are
# not present even though we don't link against them.
BuildRequires: llvm4.0-devel-static
BuildRequires: clang4.0-devel
# Required clang libraries are built statically at the moment
BuildRequires: clang4.0-devel-static
BuildRequires: libedit-devel
BuildRequires: zlib-devel
BuildRequires: python-module-sphinx

Obsoletes: gccxml

%description
Parse C-family source files and optionally write a subset of the
Abstract Syntax Tree (AST) to a representation in XML.

Source files are parsed as complete translation units using the clang
compiler. XML output is enabled by the --castxml-gccxml option and
produces a format close to that of gccxml. Future versions of castxml
may support alternative output formats.

%prep
%setup
%patch1 -p1

# LLVM_LIBRARY_DIRS does not work, and can not be overridden with -D flag
#sed 's!${LLVM_LIBRARY_DIRS}!${LLVM_LIBRARY_DIR}!' -i CMakeLists.txt

%build
%cmake_insource -DCastXML_INSTALL_DOC_DIR:STRING=share/doc/%name \
       -DCastXML_INSTALL_MAN_DIR:STRING=share/man \
       -DCLANG_RESOURCE_DIR:PATH=$(clang -print-file-name=include)/.. \
       -DBUILD_TESTING:BOOL=ON \
       -DSPHINX_MAN:BOOL=ON \
       -DLLVM_DIR=$(llvm-config --cmakedir)
%make

%install
%make install DESTDIR=%buildroot
rm -f %buildroot%_datadir/doc/%name/LICENSE
rm -f %buildroot%_datadir/doc/%name/NOTICE

%check
ctest

%files
%_bindir/castxml
%_man1dir/castxml.1*
%dir %_datadir/%name
%_datadir/%name/clang
%_datadir/%name/detect_vs.c
%_datadir/%name/detect_vs.cpp
%_datadir/%name/empty.c
%_datadir/%name/empty.cpp
%doc LICENSE NOTICE

%changelog
