# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
%def_disable server
Name: ccnet
Version: 6.1.6
Release: alt0.M80P.1

Summary: Framework for writing networked applications in C

Group: Networking/File transfer
License: GPLv2 with permissions for OpenSSL
Url: https://github.com/haiwen/ccnet

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/haiwen/ccnet/archive/v%version.tar.gz
Source: %name-%version.tar

# manually removed: python-module-mwlib 
# Automatically added by buildreq on Fri Sep 06 2013
# optimized out: glib2-devel gnu-config libgio-devel pkg-config python-base python-devel python-module-distribute python-module-zope python-modules
BuildRequires: libevent-devel libssl-devel libuuid-devel python-module-paste python-module-peak

BuildRequires: libsqlite3-devel

BuildRequires: libsearpc-devel >= 3.0.4

BuildRequires: vala >= 0.8

%if_enabled server
# server requirements
BuildRequires: libzdb-devel >= 2.10.2
%endif

Requires: lib%name = %version-%release

%description
Ccnet is a framework for writing networked applications in C.

%package -n lib%name
Summary: Library of framework for writing networked applications in C
Group: Networking/File transfer
Requires: libsearpc >= 3.0.4


%description -n lib%name
Ccnet is a framework for writing networked applications in C.

%package -n lib%name-devel
Summary: Development files for lib%name
Requires: lib%name = %version-%release
Group: Networking/File transfer

%description -n lib%name-devel
The lib%name-devel package contains libraries and header files for
developing applications that use lib%name.

%package server
Summary: Ccnet server
Requires: lib%name = %version-%release
Requires: %name = %version-%release
Group: Networking/File transfer

%description server
Ccnet server part.
Ccnet is a framework for writing networked applications in C.

%package -n python-module-%name
Summary: Ccnet python module
Requires: lib%name = %version-%release
Group: Networking/File transfer

%description -n python-module-%name
Ccnet python module.

%prep
%setup
%__subst 's/(DESTDIR)//' libccnet.pc.in

%build
%autoreconf
%configure --disable-static \
           %subst_enable server

# smp build does not work
%make_build || %make

%install
%makeinstall_std

%files
%_bindir/ccnet
%_bindir/ccnet-init
#%_bindir/ccnet-tool

%files -n lib%name
%_libdir/*.so.*

%files -n python-module-%name
%python_sitelibdir/%name/

%if_enabled server
%files server
%_bindir/%name-server
%_bindir/%name-servtool
%endif

%files -n lib%name-devel
%doc HACKING
%_includedir/ccnet/
%_includedir/ccnet.h
%_libdir/*.so
%_pkgconfigdir/lib%name.pc

%changelog
