%def_without scglib
%def_disable xdao

%define cvsdate 20020925
%undefine cvsdate
%define rc_ver %nil

Name: cdrdao
Version: 1.2.3
%define release alt3.qa1%rc_ver

%ifdef cvsdate
#Release: %{release}cvs%cvsdate
%else
Release: %release
%endif

Summary: Cdrdao - Write audio CD-Rs in disk-at-once mode
Group: Archiving/Cd burning
License: GPLv2
Url: http://cdrdao.sourceforge.net

%ifndef cvsdate
#Source: http://prdownloads.sourceforge.net/%name/%name-%version.tar.bz2
Source: %name-%version%rc_ver.tar.bz2
%else
Source: %name-%version-%cvsdate.tar.bz2
%endif

Source1: %name.control
Patch: %name-1.1.9-alt-locale.patch
# from Fedora
Patch2: cdrdao-1.2.2-desktop.patch
Patch3: cdrdao-1.2.3-version.patch
Patch4: cdrdao-1.2.3-stat.patch

PreReq: control

BuildRequires: gcc-c++ libacl-devel libao-devel liblame-devel libmad-devel libvorbis-devel
BuildRequires: libGConf-devel

%description
Writes audio CD-Rs in disc-at-once (DAO) mode allowing
control over pre-gaps (length down to 0, nonzero audio data)
and sub-channel information like ISRC codes. All data that
is written to the disc must be specified with a text file.
Audio data may be in WAVE or raw format.

%package -n gcdmaster
Summary: Graphical front end to cdrdao for composing audio CDs
Group: Archiving/Cd burning
Requires: %name = %version-%release

%description -n gcdmaster
gcdmaster allows the creation of toc-files for cdrdao and
can control the recording process. Its main application is
the composition of audio CDs from one or more audio files.
It supports PQ-channel editing, entry of meta data like
ISRC codes/CD-TEXT and non destructive cut of the audio data.

%prep

%ifndef cvsdate
#%setup -q -n %name-%version
%setup -q -n %name-%version%rc_ver
%else
%setup -q -n %name-%version-%cvsdate
%endif
#%%patch -p1
%patch2 -p1 -b .desktop
%patch3 -p1 -b .version
%patch4 -p1 -b .stat

subst 's,<linux/../scsi/scsi.h>,<scsi/scsi.h>,' dao/sg_err.h

%build
%ifdef cvsdate
find -type d -name CVS -print0 | xargs -r0 %__rm -rf --
%define __autoconf autoconf_2.5
%__subst 's@autoconf@%__autoconf@' autogen.sh
./autogen.sh
%endif

%autoreconf

%configure \
	--with-mp3-support \
	--with-ogg-support \
	%{?_disable_xdao:--without-xdao} \
	%{subst_with scglib}

%make_build

%install
%makeinstall

# control support
install -pD -m755 %SOURCE1 %buildroot%_controldir/%name
chmod 700 %buildroot%_bindir/%name

%pre
%pre_control %name

%post
%post_control %name

%files
%_bindir/*
%_datadir/%name
%_man1dir/*
%config /etc/control.d/facilities/%name
%doc README CREDITS ChangeLog NEWS

%if_enabled xdao
%exclude %_bindir/gcdmaster
%exclude %_man1dir/gcdmaster*

%files -n gcdmaster
%_bindir/gcdmaster
%_datadir/applications/*
%_datadir/pixmaps/*
%_man1dir/gcdmaster*
%_menudir/gcdmaster
%endif

%changelog
