Name: cegui
Version: 0.8.4
Release: alt2.qa3
Summary: Free library providing windowing and widgets for graphics APIs / engines
Group: System/Libraries
License: MIT
Url: http://www.cegui.org.uk
Packager: Vitaly Kuznetsov <vitty@altlinux.ru>

Source: https://bitbucket.org/cegui/cegui/get/v0-8-4.tar.gz
Source1: http://downloads.sourceforge.net/crayzedsgui/CEGUI-DOCS-%version.tar.gz

BuildRequires: SILLY-devel gcc-c++ libGLU-devel libSM-devel libexpat-devel libfreetype-devel libpcre-devel libxerces-c-devel libxml2-devel tinyxml-devel tolua++-devel tzdata libogre-devel libdirectfb-devel

BuildPreReq: cmake libminizip-devel libfribidi-devel libGLEW-devel
BuildPreReq: libglm-devel libirrlicht-devel libGLES-devel
BuildPreReq: libdevil-devel libcorona-devel
BuildPreReq: python-devel boost-devel doxygen graphviz libgtk+2-devel
BuildPreReq: libglfw-devel rapidxml boost-python-devel

%description
Crazy Eddie's GUI System is a free library providing windowing and widgets for
graphics APIs / engines where such functionality is not natively available, or
severely lacking. The library is object orientated, written in C++, and
targeted at games developers who should be spending their time creating great
games, not building GUI sub-systems!

%package devel
Summary: Development files for cegui
Group: Development/C++
Requires: %name = %version-%release
Requires: libGLU-devel

%description devel
Development files for cegui

%package devel-doc
Summary: API documentation for cegui
Group: Documentation
Requires: cegui-devel = %version-%release
BuildArch: noarch

%description devel-doc
API and Falagard skinning documentation for cegui

%prep
%setup -qb1 -qn CEGUI

# Permission fixes for debuginfo RPM
#chmod -x include/falagard/*.h

# Delete zero length file
#rm -f documentation/api_reference/keepme

# Encoding fixes
iconv -f iso8859-1 AUTHORS -t utf8 > AUTHORS.conv && mv -f AUTHORS.conv AUTHORS
iconv -f iso8859-1 TODO -t utf8 > TODO.conv && mv -f TODO.conv TODO
iconv -f iso8859-1 README -t utf8 > README.conv && mv -f README.conv README

%build
%add_optflags -I%_includedir/pcre
cmake \
%if %_lib == lib64
	-DLIB_SUFFIX=64 \
%endif
	-DCMAKE_INSTALL_PREFIX:PATH=%prefix \
	-DCMAKE_C_FLAGS:STRING="%optflags" \
	-DCMAKE_CXX_FLAGS:STRING="%optflags" \
	-DCMAKE_Fortran_FLAGS:STRING="%optflags" \
	-DCEGUI_BUILD_RENDERER_NULL:BOOL=ON \
	.

%make_build VERBOSE=1

pushd doc/doxygen
doxygen
popd

%install
%makeinstall_std
find %buildroot -name '*.la' -exec rm -f {} ';'

%files
%doc README*
%_bindir/*
%_libdir/*.so.*
%_libdir/cegui-0.8

%files devel
%_libdir/*.so
%_pkgconfigdir/*.pc
%_includedir/*
%_datadir/cegui-0
%exclude %_datadir/cegui-0/xml_schemas

%files devel-doc
%_datadir/cegui-0/xml_schemas
%doc doc/doxygen/html

%changelog
