%define sover 0.7.6
%define oname cegui
Name: %oname%sover
Version: 0.7.6
Release: alt1.4.1
Summary: Free library providing windowing and widgets for graphics APIs / engines
Group: System/Legacy libraries
License: MIT
Url: http://www.cegui.org.uk
Packager: Vitaly Kuznetsov <vitty@altlinux.ru>

Source: http://downloads.sourceforge.net/crayzedsgui/CEGUI-%version.tar.gz
Source1: http://downloads.sourceforge.net/crayzedsgui/CEGUI-DOCS-%version.tar.gz
Patch: cegui-alt-ogre.patch

BuildRequires: SILLY-devel gcc-c++ libGLU-devel libSM-devel libexpat-devel libfreetype-devel libpcre-devel libxerces-c-devel libxml2-devel tinyxml-devel tolua++-devel tzdata libogre-devel libdirectfb-devel

%description
Crazy Eddie's GUI System is a free library providing windowing and widgets for
graphics APIs / engines where such functionality is not natively available, or
severely lacking. The library is object orientated, written in C++, and
targeted at games developers who should be spending their time creating great
games, not building GUI sub-systems!

%package devel
Summary: Development files for cegui
Group: Development/C++
Requires: %name = %version-%release
Requires: libGLU-devel
Conflicts: cegui-devel

%description devel
Development files for cegui

%package devel-doc
Summary: API documentation for cegui
Group: Documentation
Requires: cegui-devel = %version-%release
BuildArch: noarch

%description devel-doc
API and Falagard skinning documentation for cegui

%prep
%setup -qb1 -qn CEGUI-%version
%patch -p2

# Permission fixes for debuginfo RPM
#chmod -x include/falagard/*.h

# Delete zero length file
#rm -f documentation/api_reference/keepme

# Encoding fixes
iconv -f iso8859-1 AUTHORS -t utf8 > AUTHORS.conv && mv -f AUTHORS.conv AUTHORS
iconv -f iso8859-1 TODO -t utf8 > TODO.conv && mv -f TODO.conv TODO
iconv -f iso8859-1 README -t utf8 > README.conv && mv -f README.conv README

%build
%configure --disable-static --disable-corona \
           --enable-lua-module --disable-irrlicht-renderer --disable-samples \
           --with-default-xml-parser=ExpatParser --enable-silly \
           --with-default-image-codec=SILLYImageCodec --with-pici --enable-null-renderer

sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make

%install
%make_install install DESTDIR=%buildroot
find %buildroot -name '*.la' -exec rm -f {} ';'

%files
%doc doc/README
%_libdir/libCEGUI*-%version.so

%files devel
%_libdir/*.so
%exclude %_libdir/libCEGUI*-%version.so
%_pkgconfigdir/CEGUI-OPENGL.pc
%_pkgconfigdir/CEGUI-OGRE.pc
%_pkgconfigdir/CEGUI.pc
%_includedir/CEGUI
%_datadir/CEGUI
%exclude %_datadir/CEGUI/xml_schemas

#files devel-doc
#_datadir/CEGUI/xml_schemas

%changelog
