# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
# TODO
%def_with plugins

Name: certbot
Version: 0.31.0
Release: alt0.M80P.1

Summary: A free, automated certificate authority client

License: ASL 2.0
Group: Networking/Other
Url: https://certbot.eff.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# #Source-url: https://pypi.python.org/packages/source/l/%name/%name-%version.tar.gz
# Source-url: https://github.com/certbot/certbot/archive/v%version.tar.gz
Source: %name-%version.tar

BuildArch: noarch
BuildRequires: python-devel python-module-distribute

#Requires: python-module-%name = %version-%release
Provides: python-module-%name = %EVR
Obsoletes: python-module-%name < %EVR

Requires: python-module-zope.component
Requires: python-module-zope.interface >= 4.1.0
Requires: python-module-pyasn1 >= 0.1.8
Requires: python-module-cffi >= 1.4.2
# missed by autoreq
Requires: python-module-future
Requires: python-module-setuptools >= 13
# Due Prior to Python 2.7.9 the stdlib SSL module did not allow a user to configure
# See /usr/lib/python2.7/site-packages/acme/client.py
Requires: python-base >= 2.7.9

# Required for documentation
#BuildRequires: python-sphinx
#BuildRequires: python-sphinx_rtd_theme
#BuildRequires: python-repoze-sphinx-autointerface
#BuildRequires: python-sphinxcontrib-programoutput

BuildRequires: python-module-acme >= %version

Provides: letsencrypt = %version
Obsoletes: letsencrypt

%define certbotdir %_datadir/%name
%add_python_req_skip certbot

BuildRequires: rpm-build-compat >= 1.7.24

%description
Let's Encrypt is a free, automated certificate authority that aims
to lower the barriers to entry for encrypting all HTTP traffic on the internet.

# TODO: move to /usr/share/%name
%package -n python-module-%name
Group: Networking/Other
Requires: python-module-configargparse >= 0.10.0
# already in core python
#Requires: python-module-argparse
Requires: python-module-psutil >= 2.1.0
Requires: python-module-acme >= %version
#Recommends: letsencrypt-doc
Summary: Python 2 libraries used by %name

Provides: python-module-letsencrypt = %version
Obsoletes: python-module-letsencrypt


%description -n python-module-%name
The python2 libraries to interface with letsencrypt.

# TODO
%if_with plugins
%package apache
Group: Networking/Other
Summary: Certbot Apache plugin
AutoProv: no
Requires: %name = %version-%release

%description apache
Certbot Apache plugin.

%package nginx
Group: Networking/Other
Summary: Certbot nginx plugin
AutoProv: no
Requires: %name = %version-%release

%description nginx
Certbot nginx plugin.
%endif

%prep
%setup

%build
%python_build

cd certbot-apache
%python_build
cd ../certbot-nginx
%python_build


%install
%python_install --install-purelib=%certbotdir

cd certbot-apache
%python_install --install-purelib=%certbotdir
cd ../certbot-nginx
%python_install --install-purelib=%certbotdir
cd -

# TODO: remove compat dirs
mkdir -p %buildroot%_sysconfdir/letsencrypt
ln -s letsencrypt %buildroot%_sysconfdir/%name
mkdir -p %buildroot%_sharedstatedir/letsencrypt
ln -s letsencrypt %buildroot%_sharedstatedir/%name
mkdir -p %buildroot%_logdir/letsencrypt
ln -s letsencrypt %buildroot%_logdir/%name

ln -s %name %buildroot%_bindir/letsencrypt

#  it is better do not require argparse on python >= 2.7.
#__subst "s|^argparse$||" %buildroot%python_sitelibdir/%name-%{version}*.egg-info/requires.txt

%__subst 's|^__requires__.*|\
# ALT: use own package dir\
import site\
site.addsitedir("%certbotdir")|' %buildroot%_bindir/%name

%check
#python_test

%files
%doc LICENSE.txt
%doc README.rst CHANGELOG.md CONTRIBUTING.md
%_bindir/%name
#%doc %attr(0644,root,root) %_man1dir/%{name}*
%dir %_sysconfdir/%name/
%dir %_sharedstatedir/%name/
%dir %_logdir/%name/
# compats
%_bindir/letsencrypt
%dir %_sysconfdir/letsencrypt/
%dir %_sharedstatedir/letsencrypt/
%dir %_logdir/letsencrypt/

#files -n python-module-%name
#doc LICENSE.txt
%dir %certbotdir/
%certbotdir/%name/
%certbotdir/%name-%{version}*.egg-info

%if_with plugins
%files nginx
%doc LICENSE.txt
%certbotdir/certbot_nginx/
%certbotdir/certbot_nginx-%{version}*.egg-info

%files apache
%doc LICENSE.txt
%certbotdir/certbot_apache/
%certbotdir/certbot_apache-%{version}*.egg-info
%endif

%changelog
