%def_disable nacl
%def_disable clang
%def_enable  gtk3
%def_enable  shared_libraries
%def_disable libchromiumcontent
%def_enable  widevine
%def_disable wayland
%def_enable  google_api_keys

%define is_enabled() %{expand:%%{?_enable_%{1}:true}%%{!?_enable_%{1}:false}}

#global gcc_version 5
#set_gcc_version #gcc_version

%set_verify_elf_method rpath=relaxed textrel=relaxed lfs=relaxed lint=relaxed

# Leave this alone, please.
%global target out/Release

# Set up Google API keys, see http://www.chromium.org/developers/how-tos/api-keys .
# Note: these are for ALT Linux use ONLY. For your own distribution,
# please get your own set of keys.
%define api_key               AIzaSyAIIWz7zaCwYcUSe3ZaRPviXjMjkBP4-xY
%define default_client_id     1018394967181.apps.googleusercontent.com
%define default_client_secret h_PrTP1ymJu83YTLyz-E25nP

Name:           chromium
Version:        61.0.3163.100
Release:        alt0.M80P.1

Summary:        An open source web browser developed by Google
License:        BSD-3-Clause and LGPL-2.1+
Group:          Networking/WWW
Url:            http://www.chromium.org

Source0:        chromium.tar.zst
Source1:        depot_tools.tar
Source2:        libchromiumcontent.tar

Source30:       master_preferences
Source31:       default_bookmarks.html
Source100:      chromium.sh
Source101:      chromium.desktop
Source102:      chromium.xml
Source200:      chromium.default

Provides:       chromium-browser = %version
Obsoletes:      chromium-browser < %version
Obsoletes:      chromium-stable <= %version

### Start Patches
Patch001: 0001-OPENSUSE-enables-reading-of-the-master-preference.patch
Patch002: 0002-OPENSUSE-Compile-the-sandbox-with-fPIE-settings.patch
Patch003: 0003-ALT-Fix-krb5-includes-path.patch
Patch004: 0004-ALT-Set-appropriate-desktop-file-name-for-default-br.patch
Patch005: 0005-DEBIAN-manpage-updates-fixes.patch
Patch006: 0006-DEBIAN-change-icon.patch
Patch007: 0007-ALT-gcc6-fixes.patch
Patch008: 0008-DEBIAN-disable-third-party-cookies-by-default.patch
Patch009: 0009-DEBIAN-add-ps-printing-capability-gtk2.patch
Patch010: 0010-ALT-fix-shrank-by-one-character.patch
Patch011: 0011-DEBIAN-10-seconds-may-not-be-enough-so-do-not-kill-t.patch
Patch012: 0012-FEDORA-path-max.patch
Patch013: 0013-FEDORA-Ignore-broken-nacl-open-fd-counter.patch
Patch014: 0014-FEDORA-Use-libusb_interrupt_event_handler-from-curre.patch
Patch015: 0015-FEDORA-Enable-ARM-CPU-detection-for-webrtc-from-arch.patch
Patch016: 0016-FEDORA-Fix-last-commit-position-issue.patch
Patch017: 0017-FEDORA-Fix-issue-where-timespec-is-not-defined-when-.patch
Patch018: 0018-ALT-gzip-does-not-support-the-rsyncable-option.patch
Patch019: 0019-UBUNTU-Specify-max-resolution.patch
Patch020: 0020-ALT-Use-rpath-link-and-absolute-rpath.patch
Patch021: 0021-Remove-third_party-libva.patch
Patch022: 0022-Enable-VAVDA-VAVEA-and-VAJDA-on-linux-with-VAAPI-onl.patch
Patch023: 0023-wip.patch
Patch024: 0024-GENTOO-disable-safe_math_shared.patch
Patch025: 0025-GENTOO-fix-atk-state.patch
Patch026: 0026-replace-struct-ucontext-with-ucontext_t.patch
Patch027: 0027-GENTOO-gcc5-r1.patch
### End Patches

BuildRequires: /proc

BuildRequires:  bison
BuildRequires:  bzlib-devel
BuildRequires:  flex
BuildRequires:  chrpath
BuildRequires:  gcc-c++
BuildRequires:  glibc-kernheaders
%if_enabled clang
BuildRequires:  clang4.0
BuildRequires:  clang4.0-devel
BuildRequires:  clang4.0-devel-static
%endif
BuildRequires:  gperf
BuildRequires:  libcups-devel
BuildRequires:  libyasm-devel
%if_enabled wayland
BuildRequires:  libwayland-server-devel
BuildRequires:  libwayland-client-devel
BuildRequires:  libwayland-cursor-devel
%endif
BuildRequires:  perl-Switch
BuildRequires:  pkg-config
BuildRequires:  pkgconfig(alsa)
BuildRequires:  pkgconfig(atk)
BuildRequires:  pkgconfig(cairo) >= 1.6
BuildRequires:  pkgconfig(dbus-1)
BuildRequires:  pkgconfig(dbus-glib-1)
BuildRequires:  pkgconfig(gconf-2.0)
BuildRequires:  pkgconfig(glib-2.0)
BuildRequires:  pkgconfig(gnome-keyring-1)
BuildRequires:  pkgconfig(gtk+-2.0)
%if_enabled gtk3
BuildRequires:  pkgconfig(gtk+-3.0)
%endif
BuildRequires:  pkgconfig(expat)
BuildRequires:  pkgconfig(libffi)
BuildRequires:  pkgconfig(libpulse)
BuildRequires:  pkgconfig(libpci)
BuildRequires:  pkgconfig(krb5-gssapi)
BuildRequires:  pkgconfig(nspr)
BuildRequires:  pkgconfig(nss)
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(xcomposite)
BuildRequires:  pkgconfig(xcursor)
BuildRequires:  pkgconfig(xdamage)
BuildRequires:  pkgconfig(xext)
BuildRequires:  pkgconfig(xfixes)
BuildRequires:  pkgconfig(xi)
BuildRequires:  pkgconfig(xtst)
BuildRequires:  pkgconfig(xkbcommon)
BuildRequires:  pkgconfig(xrandr)
BuildRequires:  pkgconfig(xrender)
BuildRequires:  pkgconfig(xscrnsaver)
BuildRequires:  pkgconfig(xt)
BuildRequires:  python
BuildRequires:  python-modules-json
BuildRequires:  yasm
BuildRequires:  usbids
BuildRequires:  xdg-utils
BuildRequires:  libva-devel

Provides:       webclient, /usr/bin/xbrowser
BuildPreReq:    alternatives >= 0.2.0
PreReq(post,preun): alternatives >= 0.2

Requires: libva

%description
Chromium is an open-source browser project that aims to build a safer,
faster, and more stable way for all Internet users to experience the web.

%package kde
Summary:        Update to chromium to use KDE's kwallet to store passwords
License:        BSD-3-Clause and LGPL-2.1+
Group:          Networking/WWW
Conflicts:      chromium-gnome
Conflicts:      chromium-desktop-gnome
Provides:       chromium-password = %version
Provides:       chromium-desktop-kde = %version
Obsoletes:      chromium-desktop-kde < %version
Requires:       %name = %version
Requires:       kde4base-runtime-core

%description kde
By using the update-alternatives the password store for Chromium is
changed to utilize KDE's kwallet. Please be aware that by this change
the old password are no longer accessible and are also not converted
to kwallet.

%package gnome
Summary:        Update to chromium to use Gnome keyring to store passwords
License:        BSD-3-Clause and LGPL-2.1+
Group:          Networking/WWW
Conflicts:      chromium-desktop-kde
Conflicts:      chromium-kde
Provides:       chromium-password = %version
Provides:       chromium-desktop-gnome = %version
Obsoletes:      chromium-desktop-gnome < %version
Requires:       %name = %version
Requires:       gnome-keyring

%description gnome
By using the update-alternatives the password store for Chromium is
changed to utilize Gnome's Keyring. Please be aware that by this change
the old password are no longer accessible and are also not converted
to Gnome's Keyring.

%prep
%setup -q -n chromium
tar -xf %SOURCE1
tar -xf %SOURCE2
cp -a libchromiumcontent/chromiumcontent .

### Begin to apply patches
%patch001 -p1
%patch002 -p1
%patch003 -p1
%patch004 -p1
%patch005 -p1
%patch006 -p1
%patch007 -p1
%patch008 -p1
%patch009 -p1
%patch010 -p1
%patch011 -p1
%patch012 -p1
%patch013 -p1
%patch014 -p1
%patch015 -p1
%patch016 -p1
%patch017 -p1
%patch018 -p1
%patch019 -p1
%patch020 -p1
%patch021 -p1
%patch022 -p1
%patch023 -p1
%patch024 -p1
%patch025 -p1
%patch026 -p1
%patch027 -p1
### Finish apply patches

# Enable support for the Widevine CDM plugin
# libwidevinecdm.so is not included, but can be copied over from Chrome
# (Version string doesn't seem to matter so let's go with "Pinkie Pie")
sed '14i#define WIDEVINE_CDM_VERSION_STRING "Pinkie Pie"' -i third_party/widevine/cdm/stub/widevine_cdm_version.h
echo > "third_party/adobe/flash/flapper_version.h"

# Work around bug in blink in which GCC 6 optimizes away null pointer checks
# https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=833524
# https://gcc.gnu.org/bugzilla/show_bug.cgi?id=68853#c2
sed -i '/config("compiler")/ a cflags_cc = [ "-fno-delete-null-pointer-checks" ]' \
	build/config/linux/BUILD.gn

%build
%if_enabled clang
export CC="clang"
export CXX="clang++"
%endif

export AR="ar"
export RANLIB="ranlib"
export PATH="$PWD/.rpm/depot_tools:$PATH"
export CHROMIUM_RPATH="%_libdir/%name"

# gn args --list <builddir>
CHROMIUM_GN_DEFINES="\
 is_debug=false \
 is_desktop_linux=true \
 use_custom_libcxx=false \
 use_sysroot=false \
 use_gio=true \
 use_gconf=false \
 use_glib=true \
 use_libpci=true \
 use_pulseaudio=true \
 use_aura=true \
 use_cups=true \
 use_kerberos=true \
 use_gold=false \
 use_pulseaudio=true \
 use_vaapi=true \
 use_vulcanize=false \
 use_system_freetype=false \
 use_system_harfbuzz=false \
 link_pulseaudio=true \
 ffmpeg_branding=\"ChromeOS\" \
 proprietary_codecs=true \
 enable_hangout_services_extension=true \
 fieldtrial_testing_like_official_build=true \
 linux_use_bundled_binutils=false \
 treat_warnings_as_errors=false \
 fatal_linker_warnings=false \
 system_libdir=\"%_lib\" \
 use_allocator=\"tcmalloc\" \
 symbol_level=0 \
 remove_webcore_debug_symbols=true \
 is_clang=%{is_enabled clang} \
 enable_nacl=%{is_enabled nacl} \
 is_component_ffmpeg=%{is_enabled shared_libraries} \
 is_component_build=%{is_enabled shared_libraries} \
 enable_widevine=%{is_enabled widevine} \
 use_gtk3=%{is_enabled gtk3} \
 enable_wayland_server=%{is_enabled wayland} \
%if_enabled google_api_keys
 google_api_key=\"%api_key\" \
 google_default_client_id=\"%default_client_id\" \
 google_default_client_secret=\"%default_client_secret\" \
%endif
"

tools/gn/bootstrap/bootstrap.py -v \
	--gn-gen-args "$CHROMIUM_GN_DEFINES"

%target/gn gen %target \
	-v \
	--args="$CHROMIUM_GN_DEFINES"

ninja \
	-v \
	-j 3 \
	-C %target \
	chrome \
	chrome_sandbox \
	chromedriver \
	clearkeycdm \
	widevinecdmadapter

%install
mkdir -p -- \
	%buildroot/%_bindir \
	%buildroot/%_man1dir \
	%buildroot/%_libdir/%name \
	%buildroot/%_sysconfdir/%name \
#
install -m 755 %SOURCE100 %buildroot%_libdir/%name/%name-generic
install -m 644 %SOURCE200 %buildroot%_sysconfdir/%name/default

# x86_64 capable systems need this
sed -i -e 's,/usr/lib/chromium,%_libdir/%name,g' %buildroot%_libdir/%name/%name-generic
ln -s %name-generic %buildroot%_libdir/%name/%name-kde
ln -s %name-generic %buildroot%_libdir/%name/%name-gnome

pushd %target
cp -a chrome         %buildroot%_libdir/%name/%name
cp -a chrome_sandbox %buildroot%_libdir/%name/chrome-sandbox
cp -a chromedriver   %buildroot%_libdir/%name/chromedriver

ln -s -- %_libdir/%name/chromedriver %buildroot/%_bindir/chromedriver

cp -at %buildroot%_libdir/%name -- \
 *.bin *.so* *.pak \
 swiftshader \
 locales \
 icudtl.dat \
#

# Remove garbage
find -name '*.TOC' -delete

cp -a chrome.1 %buildroot/%_man1dir/%name.1
ln -s %name.1  %buildroot/%_man1dir/chrome.1

# NaCl
%if_enabled nacl
cp -at %buildroot%_libdir/%name -- \
 nacl_helper \
 nacl_helper_bootstrap \
 nacl_irt_*.nexe
%endif
popd

# Icons
for size in 22 24 48 64 128 256; do
	install -Dm644 "chrome/app/theme/chromium/product_logo_$size.png" \
		"%buildroot/%_iconsdir/hicolor/${size}x${size}/apps/%name.png"
done
for size in 16 32; do
	install -Dm644 "chrome/app/theme/default_100_percent/chromium/product_logo_$size.png" \
		"%buildroot/%_iconsdir/hicolor/${size}x${size}/apps/%name.png"
done

# Desktop file
install -Dm0644 %SOURCE101 %buildroot/%_desktopdir/%name.desktop

mkdir -p -- %buildroot%_datadir/gnome-control-center/default-apps/
cp -a %SOURCE102 %buildroot%_datadir/gnome-control-center/default-apps/%name.xml

# link to browser plugin path.  Plugin patch doesn't work. Why?
mkdir -p -- %buildroot%_libdir/browser-plugins
ln -s -- %_libdir/browser-plugins %buildroot%_libdir/%name/plugins

# Install the master_preferences file
mkdir -p -- %buildroot%_sysconfdir/%name
install -m 0644 %SOURCE30 %buildroot%_sysconfdir/%name
install -m 0644 %SOURCE31 %buildroot%_sysconfdir/%name

# Set alternative to xbrowser
mkdir -p -- %buildroot%_altdir
printf '%_bindir/xbrowser\t%_bindir/%name\t50\n'            > %buildroot%_altdir/%name
printf '%_bindir/%name\t%_libdir/%name/%name-generic\t10\n' > %buildroot%_altdir/%name-generic
printf '%_bindir/%name\t%_libdir/%name/%name-kde\t15\n'     > %buildroot%_altdir/%name-kde
printf '%_bindir/%name\t%_libdir/%name/%name-gnome\t15\n'   > %buildroot%_altdir/%name-gnome

(set +x;
	find %buildroot/%_libdir/%name -type f |
	while read f; do
		t="$(readlink -ev "$f")"

		file "$t" | fgrep -qs ELF || continue

		# Strip Chromium executables to disable debuginfo generation (became too huge)
		#strip -d "$t" ||:

		# Add real RPATH
		chrpath -r '%_libdir/%name' "$t" ||:
	done
)

%files
%doc AUTHORS LICENSE
%dir %_datadir/gnome-control-center
%dir %_datadir/gnome-control-center/default-apps
%dir %_sysconfdir/%name
%config %_sysconfdir/%name/*
%attr(4711,root,root) %_libdir/%name/chrome-sandbox
%_libdir/%name
%_bindir/*
%_man1dir/*
%_desktopdir/%name.desktop
%_datadir/gnome-control-center/default-apps/*.xml
%_iconsdir/hicolor/*/apps/*.png
%_altdir/%name
%_altdir/%name-generic
%exclude %_libdir/%name/%name-kde
%exclude %_libdir/%name/%name-gnome

%files kde
%attr(755, root, root) %_libdir/%name/%name-kde
%_altdir/%name-kde

%files gnome
%attr(755, root, root) %_libdir/%name/%name-gnome
%_altdir/%name-gnome

%changelog
