%def_enable gtk_doc

Name: cinnamon
Version: 3.4.6
Release: alt1.M80P.2

Summary: Window management and application launching for GNOME
License: GPLv2+
Group: Graphical desktop/GNOME

Url: http://cinnamon.linuxmint.com
# To generate tarball
# wget https://github.com/linuxmint/Cinnamon/tarball/1.6.4 -O cinnamon-1.6.4.tar.gz
Source0: %name-%version.tar
Source2: org.%name.settings-users.policy
Source3: polkit-%name-authentication-agent-1.desktop

Patch: %name-%version-%release.patch

%define clutter_ver 1.7.5
%define gtk_ver 3.0.0
%define gi_ver 0.10.1
%define muffin_ver 1.7.3
%define eds_ver 2.91.6
%define json_glib_ver 0.13.2
%define cjs_ver 0.0.1
%define tp_glib_ver 0.15.5
%define tp_logger_ver 0.2.4
%define polkit_ver 0.100
%define folks_ver 0.5.2
%define bt_ver 3.0.0

Provides: desktop-notification-daemon

Requires: upower
Requires: polkit >= %polkit_ver
# needed for session files
Requires: cinnamon-session >= 2.6.2
Requires(post,preun):  GConf
# needed for on-screen keyboard
Requires: caribou
Requires: cinnamon-freedesktop-menu
Requires: %name-data = %version-%release
Requires: muffin >= %muffin_ver
Requires: libmuffin-gir >= %muffin_ver
Requires: %name-translations
Requires: mintlocale
Requires: gstreamer1.0

# needed for settings (python.req ignores /usr/share/cinnamon-settings/cinnamon-settings.py)
Requires: python-module-dbus
Requires: python-module-pygnome-gconf
Requires: python-modules-json
Requires: python-module-lxml
Requires: polkit-gnome
Requires: typelib(Keybinder) >= 3.0
Requires: python-module-PAM
# Cinnamon up to 3.8 had mix of python2/python3 scripts. We are not going to fix it.
# For now we just duplicate all python2 requirements for python3
Requires: python3-module-dbus
Requires: python3-module-lxml
Requires: python3-module-pygobject3

Requires: xapps-utils
# required by keyboard applet
Requires: libxapps-gir

BuildPreReq: rpm-build-gir >= 0.7.1-alt6
BuildPreReq: libclutter-devel >= %clutter_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libcjs-devel >= %cjs_ver
BuildPreReq: libjson-glib-devel >= %json_glib_ver
BuildPreReq: evolution-data-server-devel >= %eds_ver
BuildRequires: gcc-c++
BuildRequires: libcinnamon-desktop-devel libgnome-keyring-devel libcinnamon-menus-devel libstartup-notification-devel
BuildRequires: libpolkit-devel libupower-devel libgudev-devel libsoup-devel libnm-glib-devel
BuildRequires: libcanberra-gtk3-devel libcroco-devel GConf libGConf-devel
BuildRequires: gobject-introspection >= %gi_ver libupower-gir-devel libgudev-gir-devel libsoup-gir-devel libfolks-gir-devel
BuildRequires: libtelepathy-glib-gir-devel libtelepathy-logger-gir-devel libcinnamon-menus-gir-devel NetworkManager-glib-gir-devel
BuildRequires: libclutter-gir-devel

# for barriers
BuildRequires: libXfixes-devel >= 5.0
# used in unused BigThemeImage
BuildRequires: librsvg-devel
BuildRequires: libmuffin-devel >= %muffin_ver
BuildRequires: libmuffin-gir-devel >= %muffin_ver
BuildRequires: libpulseaudio-devel

BuildRequires: desktop-file-utils
BuildRequires: gtk-doc gnome-common intltool
BuildRequires: at-spi2-atk-devel

# There is already registered upstream issue https://github.com/linuxmint/muffin/issues/199
# But untill it will be fixed by Cinnamon devs we handle it manually.
# Note: to handle dependency we require libmuffin-gir explicitly
%filter_from_requires /typelib(Meta)/d

%description
Cinnamon is a Linux desktop which provides advanced innovative features
and a traditional user experience.

The desktop layout is similar to Gnome 2. The underlying technology is
forked from Gnome Shell. The emphasis is put on making users feel at
home and providing them with an easy to use and comfortable desktop
experience.

%package data
Summary: Arch independent files for Cinnamon
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: python2.7(cme)

%description data
This package provides noarch data needed for Cinnamon to work.

%package devel-doc
Summary: Development doc package for Cinnamon
Group: Development/Documentation
BuildArch: noarch

%description devel-doc
Development docs package for Cinnamon.

%add_verify_elf_skiplist %_bindir/%name

# Cinnamon.typelib should be installed in %%_typelibdir for automatic provides,
# but other typelibs (Gvs, St) conflict with gnome-shell
# Provides: typelib(Cinnamon)
# since rpm-build-gir-0.7.1-alt6 we can use
%set_typelibdir %_libdir/%name
# for detection and annihilation internal typelib-dependencies

%prep
%setup -n %name-%version
%patch0 -p1

rm -rf debian

%build
export CFLAGS="$RPM_OPT_FLAGS -Wno-error=deprecated-declarations"
(if ! test -x configure; then NOCONFIGURE=1 ./autogen.sh; fi;
%configure --disable-static --enable-compile-warnings=yes --without-ca-certificates %{?_enable_gtk_doc:--enable-gtk-doc})

%make_build

%install
export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
%makeinstall_std

# Remove .la file
rm -rf $RPM_BUILD_ROOT/%_libdir/cinnamon/libcinnamon.la

rm -f $RPM_BUILD_ROOT/%_datadir/man/man1/gnome-session-cinnamon.1
rm -f $RPM_BUILD_ROOT/%_datadir/man/man1/gnome-session-cinnamon2d.1

desktop-file-validate $RPM_BUILD_ROOT%_datadir/applications/cinnamon.desktop
desktop-file-validate $RPM_BUILD_ROOT%_datadir/applications/cinnamon2d.desktop

desktop-file-install                                 \
 --add-category="Utility"                            \
 --remove-category="DesktopSettings"                 \
 --remove-key="Encoding"                             \
 --add-only-show-in="GNOME"                          \
 --delete-original                                   \
 --dir=$RPM_BUILD_ROOT%_datadir/applications       \
 $RPM_BUILD_ROOT%_datadir/applications/cinnamon-settings.desktop

#install polkit files
install -m 0755 -d $RPM_BUILD_ROOT/%{_datadir}/polkit-1/actions/
install -D -p -m 0644 %{SOURCE2} $RPM_BUILD_ROOT/%{_datadir}/polkit-1/actions/
install -D -p -m 0644 %{SOURCE3} $RPM_BUILD_ROOT/%{_datadir}/applications/

%filter_from_requires /typelib[(]CDesktopEnums.MediaKeyType[)]/d

%files
%exclude %_bindir/%{name}-launcher
%_bindir/*
%_libdir/cinnamon/
%dir %_libexecdir/cinnamon/
%_libexecdir/cinnamon/cinnamon-hotplug-sniffer
%_libexecdir/cinnamon/cinnamon-perf-helper

%files data
%exclude %_xdgmenusdir/cinnamon-applications-merged
%exclude %_xdgmenusdir/cinnamon-applications.menu
%_datadir/glib-2.0/schemas/*.xml
%_datadir/applications/*.desktop
%exclude %_datadir/xsessions/*.desktop
%_datadir/cinnamon/
%_datadir/polkit-1/actions/org.cinnamon.settings-users.policy
%_datadir/icons/hicolor/*/actions/*.svg
%_datadir/icons/hicolor/*/apps/*.svg
%_datadir/icons/hicolor/*/categories/*.svg
%_datadir/icons/hicolor/*/emblems/*.svg
%_datadir/icons/hicolor/*/devices/*.svg
%_datadir/desktop-directories/*.directory
%exclude %_datadir/cinnamon-session/sessions/*.session

%_datadir/dbus-1/services/org.Cinnamon.HotplugSniffer.service
%_datadir/dbus-1/services/org.Cinnamon.Melange.service
%_datadir/dbus-1/services/org.Cinnamon.Slideshow.service
%_mandir/man1/*.1.*

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%changelog
