%define ver_major 3.2

Name: cinnamon-meta
Version: %ver_major.0
Release: alt1.M80P.3

Summary: Cinnamon desktop meta package
License: %gpl2plus
Group: Graphical desktop/GNOME

Url: https://github.com/linuxmint/Cinnamon
Packager: Vladimir Didenko <cow@altlinux.org>
BuildArch: noarch

BuildPreReq: rpm-build-licenses


%description
A set of virtual packages for Cinnamon Desktop installation.


%package -n cinnamon-minimal
Summary: A minimal Cinnamon desktop meta package
Group: Graphical desktop/GNOME

# Cinnamon Desktop Core
Requires: cinnamon >= %ver_major
Requires: cinnamon-session
# Window manager
Requires: muffin >= %ver_major

# Nemo and cinnamon-screensaver are required components in cinnamon.session
# files.
Requires: nemo
Requires: cinnamon-screensaver

%description -n cinnamon-minimal
This package provides minimal set of components to run
Cinnamon desktop.

%package -n cinnamon-default
Summary: A default Cinnamon desktop meta package
Group: Graphical desktop/GNOME

Requires: cinnamon-minimal = %version-%release
Provides: cinnamon-full = %version-%release
# Sound support
Requires: pulseaudio-daemon alsa-plugins-pulse
# Samba support for nemo
Requires: nemo-share
# Control Center
Requires: cinnamon-control-center
# Default terminal
Requires: gnome-terminal
# Screensaver
Requires: cinnamon-screensaver
#Gvfs
Requires: gvfs gvfs-backends gvfs-utils
# Char map - required by cinnamon keyboard applet
Requires: gucharmap

# Look and Feel
Requires: gnome-icon-theme
Requires: gnome-icon-theme-symbolic
Requires: gnome-themes-standard
Requires: libgtk2-engine-adwaita
Requires: gnome-backgrounds
# default font
Requires: fonts-otf-abattis-cantarell

# Cinnamon uses yelp to show help
Requires: yelp

%description -n cinnamon-default
This package provides the various bits and pieces
for a default Cinnamon desktop.

%package -n cinnamon-regular
Summary: Meta package for Cinnamon desktop and set of default applications
Group: Graphical desktop/GNOME

Requires: cinnamon-default = %version-%release

# Color manager
Requires: gnome-color-manager
# Password keeper
Requires: gnome-keyring
# Encryption keys management
Requires: seahorse
# Clipboard manager
Requires: parcellite
# Display manager
Requires: lightdm lightdm-gtk-greeter

# Default web-browser
Requires: firefox
# Default mailer
Requires: thunderbird
# Default messenger
Requires: pidgin

# Default Document viewer
Requires: xreader
# Default text editor
Requires: xed

# Utilities
Requires: gnome-utils
Requires: gconf-editor >= 3.0
Requires: dconf-editor >= 0.10
Requires: gcalctool

# Default music player
Requires: gnome-music
# Default video player
# segfault xplayer on i586, see ALT bug 34618
#Requires: gst-libav xplayer
Requires: smplayer-mpv
# Default image viewer
Requires: xviewer
# Default CD/DVD burning interface
Requires: brasero

Requires: gnome-power-manager
Requires: NetworkManager-gnome >= 0.8.995
#Bluetooth configuration
Requires: blueberry

# Integration with fileroller (see #34711)
Requires: nemo-fileroller

%description -n cinnamon-regular
This package provides Cinnamon desktop and set
of default applications.

%prep

%files -n cinnamon-minimal
%files -n cinnamon-default
%files -n cinnamon-regular

%changelog
