Name: clisp
Version: 2.48
Release: alt1.qa1
Serial: 1

Summary: Common Lisp (ANSI CL) implementation
License: GPL
Group: Development/Lisp
Url: http://clisp.cons.org/

Packager: Ilya Mashkin <oddity at altlinux dot ru>

Source: clisp-%version.tar.bz2

# Automatically added by buildreq on Tue Oct 21 2008
BuildRequires: gcc gcc-fortran ghostscript-utils glibc-devel-static
BuildRequires: groff-base imake libICE-devel libX11-devel libncurses-devel libreadline-devel libfcgi-devel libffcall-devel libgdbm-devel gettext
BuildRequires: libsigsegv-devel termutils xorg-cf-files libsigsegv

BuildRequires: libtinfo-devel libffi-devel diffutils
BuildRequires: pcre-devel postgresql-devel zlib-devel


%description
Common Lisp is a high-level, general-purpose programming language.

GNU CLISP is a Common Lisp implementation by Bruno Haible of Karlsruhe
University and Michael Stoll of Munich University, both in Germany.
It mostly supports the Lisp described in the ANSI Common Lisp standard.
It runs on microcomputers (Windows NT/2000/XP, Windows 95/98/ME) as well
as on Unix workstations (Linux, SVR4, Sun4, DEC Alpha OSF, HP-UX, BeOS,
NeXTstep, SGI, AIX and others) and needs only 2 MB of RAM.

It is Free Software and may be distributed under the terms of GNU GPL,
while it is possible to distribute commercial applications compiled
with GNU CLISP.

The user interface comes in German, English, French, Spanish, Dutch,
Russian and Danish.

GNU CLISP includes an interpreter, a compiler, a debugger, CLOS,
a foreign language interface, sockets, i18n, fast bignums and more.
An X11 interface is available through CLX, Garnet, CLUE/CLIO.
GNU CLISP runs Maxima, ACL2 and many other Common Lisp packages.

%prep
%setup -q

%build
#set_automake_version 1.10
#set_autoconf_version 2.5

#export CXX=g++-4.1

CC="gcc -falign-functions=4"`echo "%optflags" | %__sed -e "s:%optflags_default::"`
export CC
./configure --with-libsigsegv-prefix=${prefix} --prefix=%prefix
##./configure --prefix=%prefix --host=%_target_platform

(cd src
./makemake --with-readline --with-libsigsegv --with-gettext --with-dynamic-ffi > Makefile
%make config.lisp
%make
%make check
%make testsuite
)

%install
(cd src
make prefix=%prefix DESTDIR=%buildroot \
      docdir=%_docdir/%name-%version \
      lispdocdir=%_docdir/%name-%version \
      libdir=%_libdir \
      mandir=%_mandir install
)


%find_lang %name
%find_lang --append --output=%name.lang %{name}low

%files -f %name.lang
%_bindir/clisp
%_libdir/clisp*
%_emacslispdir/*
%exclude %_libdir/clisp*/full
%_datadir/aclocal/clisp.m4
%_mandir/man?/*
%_docdir/%name-%version
%exclude %_datadir/vim

%changelog
