%set_verify_elf_method unresolved=strict
%def_without check
Name: cmake
Version: 3.6.3
Release: alt0.1.M80P.1

Summary: Cross-platform, open-source make system

License: BSD
Group: Development/Tools
Url: http://cmake.org/

Packager: Slava Dubrovskiy <dubrsl@altlinux.org>

Source: %name-%version.tar
Source1: %name.macros
Source2: CMakeCache.txt
Patch: %name-%version-%release.patch

BuildRequires: bzlib-devel gcc-c++ libarchive-devel >= 2.8.4
BuildRequires: libcurl-devel libexpat-devel libncurses-devel qt5-base-devel libxml2-devel
BuildRequires: liblzma-devel jsoncpp-devel doxygen graphviz zlib-devel
BuildRequires: python-module-sphinx-devel
BuildRequires: shared-mime-info rpm-build-vim
%{?!_without_check:%{?!_disable_check:BuildRequires: /proc gcc-fortran java-devel cvs subversion mercurial git-core}}

Obsoletes: cpack < 2.4.5-alt3
Provides: cpack = %version-%release

Requires: %name-modules = %version-%release
Requires: rpm-macros-%name = %version-%release

%define _unpackaged_files_terminate_build 1

%add_findreq_skiplist %_datadir/CMake/Templates/cygwin-package.sh.in


%description
CMake is used to control the software compilation process using
simple platform and compiler independent configuration files.
CMake generates native makefiles and workspaces that can be
used in the compiler environment of your choice. CMake is quite
sophisticated: it is possible to support complex environments
requiring system configuration, pre-processor generation, code
generation, and template instantiation.


%package modules
Summary: Standard CMake modules
Group: Development/Tools
BuildArch: noarch

%description modules
CMake is used to control the software compilation process using
simple platform and compiler independent configuration files.

This package contains the standard modules from the CMake distribution.


%package -n ccmake
Summary: Curses interface for CMake
Group: Development/Tools
Requires: %name = %version-%release

%description -n ccmake
The "ccmake" executable is the CMake curses interface. Project
configuration settings may be specified interactively through this GUI.
Brief instructions are provided at the bottom of the terminal when the
program is running.


%package -n ctest
Summary: CMake test driver program
Group: Development/Tools
Requires: %name = %version-%release

%description -n ctest
The ctest executable is the CMake test driver program. CMake-generated
build trees created for projects that use the ENABLE_TESTING and
ADD_TEST commands have testing support. This program will run the tests
and report results.


%package gui
Summary: Qt interface for CMake
Group: Development/Tools
Requires: %name = %version-%release

%description gui
The "cmake-gui" executable is the CMake GUI.  Project configuration settings
may be specified interactively.  Brief instructions are provided at the
bottom of the window when the program is running.


%package doc
Summary: CMake docs
Group: Documentation
BuildArch: noarch

%description doc
This package contains CMake docs in DocBook, html and txt formats.


%package -n vim-plugin-%name
Summary: Vim plugins for CMake files
Group: Editors
BuildArch: noarch

%description -n vim-plugin-%name
This package contains updated indent and syntax Vim plugins for CMake files.

%package -n bash-completion-%name
Summary: bash completion for CMake
Group: Shells
BuildArch: noarch

%description -n bash-completion-%name
bash completion for CMake


%package -n rpm-macros-%name
Summary: Set of RPM macros for packaging applications that use cmake
Group: Development/Other
Conflicts: cmake = 2.8.0-alt1
Conflicts: rpm-build-compat <= 1.5.1-alt1

%description -n rpm-macros-%name
Set of RPM macros for packaging applications that use cmake.


%prep
%setup
%patch -p1

%build
mkdir build
pushd build
install -m644 %SOURCE2 ./

CFLAGS="%optflags" CXXFLAGS="%optflags" ../bootstrap \
	--verbose \
	--parallel=%__nprocs \
	--system-libs \
	--qt-gui \
	--sphinx-man \
	--sphinx-html \
	--prefix=%prefix \
	--datadir=/share/CMake \
	--mandir=/share/man \
	--docdir=/share/doc/%name-%version


export LD_LIBRARY_PATH=$PWD/Source:$PWD/Source/kwsys/:$PWD/Source/CursesDialog/form
%make_build VERBOSE=1
popd


%install
pushd build
export LD_LIBRARY_PATH=$PWD/Source:$PWD/Source/kwsys/:$PWD/Source/CursesDialog/form
%makeinstall_std
popd
#install -m644 ChangeLog.manual %buildroot%_docdir/%name-%version
mv %buildroot/usr/lib %buildroot%_libdir || :
for i in 32 128; do
    install -pD -m644 Source/QtDialog/CMakeSetup$i.png %buildroot%_iconsdir/hicolor/${i}x$i/apps/CMakeSetup.png
done
mkdir -p %buildroot{%vim_indent_dir,%vim_syntax_dir,%_sysconfdir/bash_completion.d}
install -m644 Auxiliary/cmake-indent.vim %buildroot%vim_indent_dir/%name.vim
install -m644 Auxiliary/cmake-syntax.vim %buildroot%vim_syntax_dir/%name.vim
install -pD -m644 %SOURCE1 %buildroot%_rpmmacrosdir/%name

mv -f %buildroot%_datadir/CMake/completions %buildroot%_sysconfdir/bash_completion.d

install -p  build/Source/kwsys/libcmsys.so  %buildroot%_libdir/libcmsys.so
install -p  build/Source/kwsys/libcmsys_c.so  %buildroot%_libdir/libcmsys_c.so

%check
%if_with check
# CTest.UpdateGIT fails, see #20884
unset GIT_DIR
unset GIT_INDEX_FILE
unset GIT_OBJECT_DIRECTORY
unset DISPLAY
pushd build
export LD_LIBRARY_PATH=%buildroot%_libdir
%make_build test ARGS="--output-on-failure -E 'CMake.FileDownload|CTestTestUpload'"
popd
%endif

%files
%_bindir/cmake
%_bindir/cpack
%_libdir/libCMakeLib.so
%_libdir/libCPackLib.so
%_libdir/libcmcompress.so
%_libdir/libcmsys.so
%_libdir/libcmsys_c.so
%_datadir/CMake/
%_aclocaldir/*
%_man1dir/cmake*.*
%_man1dir/cpack.*
%_man7dir/*
%dir %_docdir/%name-%version/
#_docdir/%name-%version/ChangeLog.manual
%_docdir/%name-%version/Copyright.txt
%_docdir/%name-%version/cmcompress/
%_docdir/%name-%version/cmsys/
%exclude %_datadir/CMake/Modules/

%files modules
%dir %_datadir/CMake/
%_datadir/CMake/Modules/


%files -n ccmake
%_bindir/ccmake
#_libdir/libcmForm.so
%_man1dir/ccmake.*


%files -n ctest
%_bindir/ctest
%_libdir/libCTestLib.so
%_man1dir/ctest.*


%files gui
%_bindir/cmake-gui
%_desktopdir/CMake.desktop
%_xdgmimedir/packages/cmakecache.xml
%_iconsdir/*/*/*/CMakeSetup.png
#_pixmapsdir/*


%files doc
%dir %_docdir/%name-%version
#_docdir/%name-%version/ccmake.*
#_docdir/%name-%version/cmake*
#_docdir/%name-%version/cpack*
#_docdir/%name-%version/ctest.*
%_docdir/%name-%version/html


%files -n vim-plugin-%name
%vim_indent_dir/*
%vim_syntax_dir/*

%files -n bash-completion-%name
%_sysconfdir/bash_completion.d/*

%files -n rpm-macros-%name
%_rpmmacrosdir/*

%filter_from_requires /^gnustep-Backbone.*/d

%changelog
