%def_enable apache
%def_enable bind
%def_enable cgi
%def_enable curl
%def_enable dbi
%def_enable ganglia
%def_enable ipmi
%def_enable virt
%def_enable memcached
%def_disable modbus
%def_disable monitorus
%def_enable mysql
%def_disable netlink
%def_enable nginx
%def_enable notify_desktop
%def_enable notify_email
%def_enable nut
%def_enable openvz
%def_enable perl
%def_enable ping
%def_enable postgresql
%def_enable rrdcached
%def_enable rrdtool
%def_enable sensors
%def_enable snmp
%def_enable tokyotyrant
%def_enable xmms

%def_disable static

Name: collectd
Version: 5.7.2
Release: alt2.M80P.1

Summary: (Multi-)System statistics collection
License: GPL
Group: Monitoring

Url: http://collectd.org
Source0: %url/files/%name-%version.tar
Patch0: %name-%version-alt.patch

### NB: part of BRs is conditional (see subpackages below)
# Automatically added by buildreq on Thu May 14 2009 (-bi)
#BuildRequires: flex gcc-c++ iptables-devel libMySQL-devel libcurl-devel libdbi-devel libesmtp-devel libgcrypt-devel libnet-snmp-devel libnetlink-devel libnotify-devel liboping-devel libpcap-devel librrd-devel libsensors-devel libvirt-devel libxfs-devel libxml2-devel libxmms-devel nut-devel perl-devel perl-threads perl-Regexp-Common postgresql-devel
BuildRequires: flex gcc-c++ iptables-devel libgcrypt-devel libpcap-devel libxfs-devel
BuildRequires: libstatgrab-devel
BuildRequires(pre):rpm-build-ubt

%if_enabled perl
BuildRequires: perl-devel perl-threads perl-Regexp-Common perl-Pod-Parser

# http://mailman.verplant.org/pipermail/collectd/2008-April/001766.html
%set_perl_req_method relaxed
%endif

%set_verify_elf_method unresolved=relaxed textrel=relaxed
%add_verify_elf_skiplist %_libdir/%name/*/*

%define libname lib%{name}client
%define nginxdir %_sysconfdir/nginx/sites-enabled.d

%description
collectd is a small program written in C for performance. It reads various
system statistics and updates RRD files, creating them if neccessary.
Since it doesn't need to startup every time it wants to update the files
it's very fast and easy on the system. Also, the statistics are very
fine grained since the files are updated every 10 seconds.

WARNING: 5.x is INCOMPATIBLE with 4.x data!  You HAVE to perform
custom MIGRATION as described in documentation OR drop the HISTORY!
>> http://collectd.org/wiki/index.php/V4_to_v5_migration_guide <<

NB: syslog plugin might be helpful at configuration stage
but not in production since it generates LOTS of logfile records!

%package -n %libname
Summary: Shared library for %name clients
Group: System/Libraries

%description -n %libname
This package contains shared library for %name clients.

%package -n %libname-devel
Summary: Library headers to build %name clients
Group: Development/C
Requires: %libname = %version-%release

%description -n %libname-devel
This package contains development part of %libname.

%if_enabled perl
%package -n perl-Collectd
Summary: Perl module for %name
Group: Development/Perl
BuildArch: noarch

%description -n perl-Collectd
This package contains Perl part of %name.
%endif

%package cluster
Summary: Cluster metapackage for %name plugins
Group: Monitoring
BuildArch: noarch
%{?_enable_ganglia:Requires: %name-ganglia}
%{?_enable_ipmi:Requires: %name-ipmi}
%{?_enable_modbus:Requires: %name-modbus}
%{?_enable_snmp:Requires: %name-snmp}

%description cluster
This package pulls in plugins which might be useful at a cluster

%package full
Summary: Meta package for %name plugins
Group: Monitoring
BuildArch: noarch
%{?_enable_apache:Requires: %name-apache}
%{?_enable_bind:Requires: %name-bind}
%{?_enable_cgi:Requires: %name-cgi}
%{?_enable_curl:Requires: %name-curl}
%{?_enable_dbi:Requires: %name-dbi}
%{?_enable_ipmi:Requires: %name-ipmi}
%{?_enable_virt:Requires: %name-virt}
%{?_enable_mysql:Requires: %name-mysql}
%{?_enable_netlink:Requires: %name-netlink}
%{?_enable_nginx:Requires: %name-nginx}
%{?_enable_notify_desktop:Requires: %name-notify_desktop}
%{?_enable_notify_email:Requires: %name-notify_email}
%{?_enable_nut:Requires: %name-nut}
%{?_enable_ping:Requires: %name-ping}
%{?_enable_postgresql:Requires: %name-postgresql}
%{?_enable_rrdcached:Requires: %name-rrdcached}
%{?_enable_rrdtool:Requires: %name-rrdtool}
%{?_enable_sensors:Requires: %name-sensors}
%{?_enable_snmp:Requires: %name-snmp}
%{?_enable_tokyotyrant:Requires: %name-tokyotyrant}
%{?_enable_xmms:Requires: %name-xmms}

%description full
This package pulls in all the different plugins and might
come handy if you don't mind extra dependencies on the system

%if_enabled apache
%package apache
Summary: apache2 support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires(pre): apache2-devel
BuildRequires(pre): rpm-macros-apache2

%description apache
This plugin provides apache 2.x support for collectd
%endif

%if_enabled bind
%package bind
Summary: ISC BIND support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: libcurl-devel libxml2-devel

%description bind
This plugin provides ISC BIND support for collectd
%endif

%if_enabled cgi
%package cgi
Summary: CGI script for collectd
Group: Monitoring
Requires: collectd = %version
Requires: webserver-common perl-RRD perl-HTML-Parser
BuildRequires: perl-CGI
BuildRequires(pre): apache2-devel
BuildRequires(pre): rpm-macros-apache2
BuildArch: noarch

%description cgi
This CGI frontend for collectd allows to browse the stats online,
check out http://localhost/cgi-bin/%name/collection.cgi

%if_enabled apache
%package cgi-apache2
Summary: CGI script for collectd (apache2 config and glue)
Group: Monitoring
Requires: collectd-cgi = %version
Requires: apache2-base apache2-cgi-bin
BuildArch: noarch

%description cgi-apache2
apache2 configuration and glue to run collectd CGI script.

See %apache2_extra_available/%name.conf for details,
including access restrictions to be imposed.
%endif

%if_enabled nginx
%package cgi-nginx
Summary: CGI script for collectd (nginx config and glue)
Group: Monitoring
Requires: collectd-cgi = %version
Requires: nginx fcgiwrap spawn-fcgi
BuildArch: noarch

%description cgi-nginx
nginx configuration and glue to run collectd CGI script.

See %nginxdir/%name.conf for details,
including access restrictions to be imposed,
and %_sysconfdir/sysconfig/spawn-fcgi just in case

NB: this reconfigures spawn-fcgi and sets it to autostart!
%endif
%endif

%if_enabled curl
%package curl
Summary: CURL support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: libcurl-devel

%description curl
This plugin provides CURL (proxy, etc) support for collectd
%endif

%if_enabled dbi
%package dbi
Summary: DBI support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: libdbi-devel

%description dbi
This plugin provides DBI support for collectd
%endif

%if_enabled ganglia
%package ganglia
Summary: Ganglia support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: libganglia-devel

%description ganglia
This plugin provides Ganglia support for collectd
%endif

%if_enabled ipmi
%package ipmi
Summary: IPMI support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
Requires: libopenipmi
BuildRequires: libopenipmi-devel

%description ipmi
This plugin provides ipmi support for collectd
%endif

%if_enabled virt
%package virt
Summary: virt support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: libvirt-devel libxml2-devel
Provides: %name-libvirt = %version
Obsoletes: %name-libvirt < %version

%description virt
This plugin provides virtual machines support for collectd
%endif

%if_enabled memcached
%package memcached
Summary: memcached support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: libmemcached-devel

%description memcached
This plugin provides memcached support for collectd, see
http://collectd.org/wiki/index.php/Plugin:memcached
http://collectd.org/wiki/index.php/Plugin:memcachec
%endif

%if_enabled modbus
%package modbus
Summary: ModBus support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
# libmodbus-2.9.3+ is going to be supported when a stable version
# is available, 2.0.3 should get fixed with 4.10.3:
# http://www.mail-archive.com/collectd@verplant.org/msg01126.html
BuildRequires: libmodbus-devel < 2.9

%description modbus
This plugin provides ModBus support for collectd
%endif

%if_enabled monitorus
%package monitorus
Summary: Monitorus support module for collectd
Group: Monitoring
BuildArch: noarch
Requires: collectd = %version-%release
Requires: perl-Collectd = %version-%release

%description monitorus
This plugin provides Monitorus support for collectd
%endif

%if_enabled mysql
%package mysql
Summary: MySQL support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: libMySQL-devel

%description mysql
This plugin provides MySQL server support for collectd
%endif

%if_enabled netlink
%package netlink
Summary: netlink support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: libnetlink-devel

%description netlink
This plugin provides netlink support for collectd
%endif

%if_enabled nginx
%package nginx
Summary: nginx support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: libcurl-devel

%description nginx
This plugin provides nginx support for collectd
%endif

%if_enabled notify_desktop
%package notify_desktop
Summary: desktop notification support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: libnotify-devel

%description notify_desktop
This plugin provides desktop notification support for collectd
%endif

%if_enabled notify_email
%package notify_email
Summary: email notification support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: libesmtp-devel

%description notify_email
This plugin provides email notification support for collectd
%endif

%if_enabled nut
%package nut
Summary: Network UPS Tools support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
Requires: libnut
BuildRequires: libupsclient-devel

%description nut
This plugin provides UPS support for collectd (with NUT)
%endif

%if_enabled openvz
%package openvz
Summary: OpenVZ support module for collectd
Group: Monitoring
BuildArch: noarch
Requires: collectd = %version-%release
Requires: perl-Collectd = %version-%release

%description openvz
This plugin provides OpenVZ support for collectd
%endif

%if_enabled rrdcached
%package rrdcached
Summary: RRDCacheD support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: librrd-devel >= 1.4

%description rrdcached
This plugin provides RRDCacheD support for collectd
(see http://collectd.org/wiki/index.php/Plugin:RRDCacheD)
%endif

%if_enabled rrdtool
%package rrdtool
Summary: rrdtool support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
Requires: rrdtool
BuildRequires: librrd-devel

%description rrdtool
This plugin provides RRD Tool support for collectd
%endif

%if_enabled ping
%package ping
Summary: ICMP support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: liboping-devel

%description ping
This plugin provides ICMP (ping check) support for collectd
%endif

%if_enabled postgresql
%package postgresql
Summary: PostgreSQL support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: postgresql-devel

%description postgresql
This plugin provides PostgreSQL support for collectd
%endif

%if_enabled sensors
%package sensors
Summary: lm_sensors support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
Requires: lm_sensors3
BuildRequires: libsensors3-devel >= 3.1.0-alt4

%description sensors
This plugin provides sensors support for collectd (with lm_sensors)
%endif

%if_enabled snmp
%package snmp
Summary: SNMP support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
Requires: libnet-snmp
BuildRequires: libnet-snmp-devel net-snmp-common

%description snmp
This plugin provides SNMP support for collectd
%endif

%if_enabled tokyotyrant
%package tokyotyrant
Summary: Tokyo Tyrant support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
BuildRequires: libtokyotyrant-devel

%description tokyotyrant
This plugin provides Tokyo Tyrant support for collectd
%endif

%if_enabled xmms
%package xmms
Summary: XMMS support module for collectd
Group: Monitoring
Requires: collectd = %version-%release
Requires: libxmms
BuildRequires: libxmms-devel

%description xmms
This plugin provides XMMS support for collectd
%endif

%package -n nagios-plugins-%name
Summary: Nagios plugin to use data from collectd
Group: Monitoring
Requires: nagios-common

%description -n nagios-plugins-%name
This Nagios plugin provides possibility to feed statistics
from collectd into nagios to avoid extra sensor-caused load

%prep
%setup
%patch0 -p1
sed -i 's/ -Werror//' src/Makefile.*
mkdir libltdl

%build
#libtoolize --ltdl --copy --force
#%autoreconf
./build.sh

# fixed warnings:
# python.so: underlinked libraries: /lib64/libpthread.so.0
# gmond.so: underlinked libraries: /lib64/libpthread.so.0
# rrdcached.so: underlinked libraries: /lib64/libpthread.so.0
# rrdtool.so: underlinked libraries: /lib64/libpthread.so.0
# notify_desktop.so: underlinked libraries: /usr/lib64/libgobject-2.0.so.0
%add_optflags -lpthread -lgobject-2.0 -std=gnu99

# seems like mainstream uses /var for localstatedir, ALT uses /var/lib
%configure \
	--disable-apple_sensors \
	--disable-ascent \
	--disable-java \
	--without-java \
	--disable-debug \
	%{subst_enable apache} \
	%{subst_enable curl} \
	%{subst_enable dbi} \
	%{subst_enable ganglia} \
	%{subst_enable ipmi} \
	%{subst_enable virt} \
	%if_enabled memcached
	--enable-memcachec \
	%endif
	%{subst_enable memcached} \
	%{subst_enable modbus} \
	%{subst_enable monitorus} \
	%{subst_enable mysql} \
	%{subst_enable netlink} \
	%{subst_enable nginx} \
	%{subst_enable notify_desktop} \
	%{subst_enable notify_email} \
	%{subst_enable nut} \
	%{subst_enable openvz} \
	%{subst_enable perl} \
	%{subst_enable ping} \
	%{subst_enable postgresql} \
	%{subst_enable rrdcached} \
	%{subst_enable rrdtool} \
	%if_enabled sensors
	--with-libsensors=%_prefix \
	%{subst_enable sensors} \
	%endif
	%{subst_enable snmp} \
	%{subst_enable tokyotyrant} \
	%{subst_enable xmms} \
	%{subst_enable static} \
	--localstatedir=%_var \
# </configure>
%make_build INSTALLMAN1DIR=%_man1dir

%install
%makeinstall_std INSTALLDIRS=vendor
install -pDm644 src/collectd.conf %buildroot%_sysconfdir/%name.conf
sed -i 's,/usr/var,%_var,g' %buildroot%_sysconfdir/%name.conf
install -pDm755 contrib/altlinux/%name.init %buildroot%_initdir/%name
install -d %buildroot%_libdir/%name/ %buildroot%_localstatedir/%name/
rm %buildroot%_libdir/%name/*.la

# TODO: package collection3 and maybe other frontends as well
%if_enabled cgi
%if_enabled apache
install -pDm644 contrib/altlinux/%name.apache2 %buildroot%apache2_extra_available/%name.conf
%endif
%if_enabled nginx
install -pDm644 contrib/altlinux/%name.nginx %buildroot%nginxdir/%name.conf
%endif
install -pDm755 contrib/collection.cgi %buildroot%apache2_cgibindir/%name/collection.cgi
cat >> %buildroot%_sysconfdir/collection.conf << EOF
datadir: "%_localstatedir/%name"
libdir: "%_localstatedir/%name"
EOF
%endif

install -pDm644 contrib/systemd.collectd.service %buildroot%_unitdir/collectd.service

# --disable-monitorus is not working
%if_disabled monitorus
rm -f %buildroot%perl_vendor_privlib/*/*/Monitorus.pm
%endif

%pre
# Plugin libvirt renamed to virt in 5.5.0
sed -i "s/Plugin libvirt/Plugin virt/g" %_sysconfdir/%name.conf 2>/dev/null ||:

%post
%post_service %name

%preun
%preun_service %name

%post cgi-apache2
a2enmod cgi && a2enextra %name ||:

%preun cgi-apache2
a2disextra %name ||:

%post cgi-nginx
# FIXME: this must be properly done with control(8) in spawn-fcgi
echo -n "reconfiguring spawn-fcgi to use fcgiwrap... "
if sed -i \
	-e 's,^FCGIPROGRAM=.*$,FCGIPROGRAM="/usr/sbin/fcgiwrap",' \
	-e 's,^FCGILISTEN=.*$,#&,' \
	-e 's,^FCGIPORT=.*$,#&,' \
	-e 's,^#\(SOCKETGROUP=_nginx\)$,\1,' \
	-e 's,^#\(SOCKETMODE=0770\)$,\1,' \
	%_sysconfdir/sysconfig/spawn-fcgi;
then
	echo "done"
	echo "consider: chkconfig spawn-fcgi on && service spawn-fcgi start"
fi

%post rrdtool
service %name condrestart ||:

%postun rrdtool
service %name condrestart ||:

%files
%doc AUTHORS ChangeLog README ChangeLog
%doc contrib/
%config(noreplace) %_sysconfdir/%name.conf
%_initdir/%name
%_sbindir/%name
%_sbindir/collectdmon
%_bindir/collectdctl
%_bindir/collectd-tg
%_man1dir/*.1*
%_man5dir/*.5*
%_datadir/%name/
%dir %_localstatedir/%name/
%dir %_libdir/%name/
%_libdir/%name/*.so
%{?_enable_apache:%exclude %_libdir/%name/apache.so}
%{?_enable_bind:%exclude %_libdir/%name/bind.so}
%{?_enable_curl:%exclude %_libdir/%name/curl.so}
%{?_enable_dbi:%exclude %_libdir/%name/dbi.so}
%{?_enable_ganglia:%exclude %_libdir/%name/gmond.so}
%{?_enable_ipmi:%exclude %_libdir/%name/ipmi.so}
%{?_enable_virt:%exclude %_libdir/%name/virt.so}
%{?_enable_memcached:%exclude %_libdir/%name/memcachec.so}
%{?_enable_memcached:%exclude %_libdir/%name/memcached.so}
%{?_enable_modbus:%exclude %_libdir/%name/modbus.so}
%{?_enable_mysql:%exclude %_libdir/%name/mysql.so}
%{?_enable_netlink:%exclude %_libdir/%name/netlink.so}
%{?_enable_nginx:%exclude %_libdir/%name/nginx.so}
%{?_enable_notify_email:%exclude %_libdir/%name/notify_email.so}
%{?_enable_notify_desktop:%exclude %_libdir/%name/notify_desktop.so}
%{?_enable_nut:%exclude %_libdir/%name/nut.so}
%{?_enable_ping:%exclude %_libdir/%name/ping.so}
%{?_enable_postgresql:%exclude %_libdir/%name/postgresql.so}
%{?_enable_rrdcached:%exclude %_libdir/%name/rrdcached.so}
%{?_enable_rrdtool:%exclude %_libdir/%name/rrdtool.so}
%{?_enable_sensors:%exclude %_libdir/%name/sensors.so}
%{?_enable_snmp:%exclude %_libdir/%name/snmp.so}
%{?_enable_tokyotyrant:%exclude %_libdir/%name/tokyotyrant.so}
%{?_enable_xmms:%exclude %_libdir/%name/xmms.so}
%_unitdir/collectd.service

%files -n %libname
%_libdir/%libname.so.*

%files -n %libname-devel
%_includedir/%name/
%_libdir/%libname.so
%_pkgconfigdir/*

%if_enabled perl
%files -n perl-Collectd
%dir %perl_vendor_privlib/Collectd
%perl_vendor_privlib/*.pm
%perl_vendor_privlib/*/*.pm
%endif

%if_enabled apache
%files apache
%_libdir/%name/apache.so
%endif

%if_enabled bind
%files bind
%_libdir/%name/bind.so
%endif

%if_enabled cgi
%files cgi
%dir %apache2_cgibindir/%name/
%apache2_cgibindir/%name/collection.cgi
%config(noreplace) %_sysconfdir/collection.conf

%if_enabled apache
%files cgi-apache2
%config(noreplace) %apache2_extra_available/%name.conf
%endif

%if_enabled nginx
%files cgi-nginx
%config(noreplace) %nginxdir/%name.conf
%endif
%endif

%if_enabled curl
%files curl
%_libdir/%name/curl.so
%endif

%if_enabled dbi
%files dbi
%_libdir/%name/dbi.so
%endif

%if_enabled ganglia
%files ganglia
%_libdir/%name/gmond.so
%endif

%if_enabled ipmi
%files ipmi
%_libdir/%name/ipmi.so
%endif

%if_enabled virt
%files virt
%_libdir/%name/virt.so
%endif

%if_enabled memcached
%files memcached
%_libdir/%name/memcachec.so
%_libdir/%name/memcached.so
%endif

%if_enabled modbus
%files modbus
%_libdir/%name/modbus.so
%endif

%if_enabled monitorus
%files monitorus
%dir %perl_vendor_privlib/Collectd/Plugins
%perl_vendor_privlib/*/*/Monitorus.pm
%endif

%if_enabled mysql
%files mysql
%_libdir/%name/mysql.so
%endif

%if_enabled netlink
%files netlink
%_libdir/%name/netlink.so
%endif

%if_enabled nginx
%files nginx
%_libdir/%name/nginx.so
%endif

%if_enabled notify_desktop
%files notify_desktop
%_libdir/%name/notify_desktop.so
%endif

%if_enabled notify_email
%files notify_email
%_libdir/%name/notify_email.so
%endif

%if_enabled nut
%files nut
%_libdir/%name/nut.so
%endif

%if_enabled openvz
%files openvz
%dir %perl_vendor_privlib/Collectd/Plugins
%perl_vendor_privlib/*/*/OpenVZ.pm
%endif

%if_enabled ping
%files ping
%_libdir/%name/ping.so
%endif

%if_enabled postgresql
%files postgresql
%_libdir/%name/postgresql.so
%endif

%if_enabled rrdcached
%files rrdcached
%_libdir/%name/rrdcached.so
%endif

%if_enabled rrdtool
%files rrdtool
%_libdir/%name/rrdtool.so
%dir %_localstatedir/%name
%endif

%if_enabled sensors
%files sensors
%_libdir/%name/sensors.so
%endif

%if_enabled snmp
%files snmp
%_libdir/%name/snmp.so
%endif

%if_enabled tokyotyrant
%files tokyotyrant
%_libdir/%name/tokyotyrant.so
%endif

%if_enabled xmms
%files xmms
%_libdir/%name/xmms.so
%endif

%files cluster

%files full

%files -n nagios-plugins-%name
%_bindir/collectd-nagios

# TODO:
# - reenable netlink plugin
# - consider building with: libiokit, liboconfig (system),
#   libiptc [kernhdrs], libjvm?, libkvm, libcredis,
#   libnotify, librabbitmq, libvarnish, libyajl, ipvs
# - macroize repetitive sections

%changelog
