%def_disable snapshot
%define ver_major 0.9.13

Name: compiz
Version: %ver_major.1
Release: alt0.M80P.1

Summary: OpenGL window and compositing manager
License: MIT/X11 GPL
Group: System/X11
Url: http://www.compiz.org/
# https://launchpad.net/compiz
Packager: Valery Inozemtsev <shrek@altlinux.ru>

ExclusiveArch: i586 x86_64
Provides: libcompizconfig compiz-fusion-plugins-extra compiz-gtk python-module-compizconfig compiz-gnome
Provides: compiz-fusion-plugins-main compizconfig-backend-gconf ccsm emerald
Obsoletes: libcompizconfig compiz-fusion-plugins-extra compiz-gtk python-module-compizconfig compiz-gnome
Obsoletes: compiz-fusion-plugins-main compizconfig-backend-gconf ccsm emerald

%if_disabled snapshot
Source: https://launchpad.net/%name/%ver_major/%version/+download/%name-%version.tar.bz2
#Source: %name-%version.tar.xz
%else
# bzr export --format=tar --root=compiz-0.9.13.0 compiz-0.9.13.0.tar
Source: %name-%version.tar
%endif

Patch0: compiz-0.9.13.0-alt-python_sitelibdir.patch
Patch1: compiz-0.9.13.0-alt-mate-window-settings.patch
Patch2: compiz-0.9.13.0-alt-po.patch

BuildRequires: boost-devel-headers cmake gcc-c++ intltool libGLU-devel libSM-devel libXcomposite-devel
BuildRequires: libXcursor-devel libXdamage-devel libXi-devel libXinerama-devel libXrandr-devel libdbus-devel
BuildRequires: libglibmm-devel libjpeg-devel libmetacity3.0-devel libnotify-devel libprotobuf-devel librsvg-devel
BuildRequires: libstartup-notification-devel libwnck3-devel libxslt-devel protobuf-compiler python-module-Pyrex xsltproc
BuildRequires: pkgconfig(mate-window-settings-2.0) pkgconfig(gnome-desktop-2.0)

%description
Compiz is an OpenGL compositing manager that use GLX_EXT_texture_from_pixmap
for binding redirected top-level windows to texture objects. It has a flexible
plug-in system and it is designed to run well on most graphics hardware.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1

%build
%define lib_suffix %nil
%ifarch x86_64
%define lib_suffix 64
%endif
mkdir -p %_target_platform
pushd %_target_platform
cmake .. \
	-DCMAKE_INSTALL_PREFIX=%prefix \
	-DCMAKE_BUILD_TYPE=Release \
	-DCMAKE_CXX_FLAGS_RELEASE='%optflags' \
	-DCOMPIZ_PACKAGING_ENABLED=TRUE \
	-DLIB_SUFFIX=%lib_suffix \
	-DCOMPIZ_BUILD_WITH_RPATH=FALSE \
	-DCOMPIZ_DISABLE_GS_SCHEMAS_INSTALL=OFF \
	-DCOMPIZ_DISABLE_PLUGIN_KDE=ON \
	-DCOMPIZ_BUILD_TESTING=OFF \
	-DUSE_KDE4=OFF
popd
%make_build -C %_target_platform

%install
%make -C %_target_platform DESTDIR=%buildroot install

mkdir -p %buildroot%_sysconfdir/compizconfig
cat << __EOF__ > %buildroot%_sysconfdir/compizconfig/config
[general]
backend = gsettings
profile = mate
integration = true
plugin_list_autosort = true
__EOF__
cat << __EOF__ > %buildroot%_sysconfdir/compizconfig/mate.ini
[core]
s0_active_plugins = core;composite;opengl;decor;matecompat;move;resize;imgpng;wall;session;copytex;compiztoolbox;wobbly;switcher;scale;
__EOF__

%ifarch x86_64
mv %buildroot%python_sitelibdir_noarch/* %buildroot%python_sitelibdir/
%endif

rm -fr %buildroot%_datadir/compiz/cmake
rm -f %buildroot%_bindir/compiz-decorator
#rm -f %buildroot%_libdir/*.so
rm -fr %buildroot%_includedir
rm -fr %buildroot%_pkgconfigdir
rm -fr %buildroot%_datadir/cmake*

%find_lang --output=global.lang %name ccsm

%files -f global.lang
%dir %_sysconfdir/compizconfig
%config(noreplace) %_sysconfdir/compizconfig/*
%_bindir/*
%_libdir/%name
%_libdir/compizconfig
%_libdir/lib*.so.*
%_libdir/libcompizconfig_gsettings_backend.so
%python_sitelibdir/c*
%_desktopdir/*.desktop
%_datadir/ccsm
%_datadir/%name
%_datadir/glib-2.0/schemas/*.gschema.xml
%_iconsdir/hicolor/*/apps/*.png
%_iconsdir/hicolor/*x*/apps/*.svg
%_iconsdir/hicolor/scalable/apps/*.svg


%changelog
