
%define courier_piddir %_var/run
%define _ssldir %_localstatedir/ssl
%define _pemdir %_ssldir/private
%define rev %nil

Name: courier-imap
Version: 4.10.0
Release: alt0.2%rev

Summary: IMAP/POP3 server with Maildir support
License: GPL
Group: System/Servers
URL: http://www.courier-mta.org

Requires(pre): cert-sh-functions >= 0.1-alt2 shadow-utils
Requires(post,preun): service
Requires: courier-imap-utils = %version
Requires: libgamin-fam

Source0: %name-%version%rev.tar.bz2
Source1: courier-imapd.init
Source2: courier-imaps.init
Source3: courier-pop3d.init
Source4: courier-pop3s.init
Source7: %name.README-ALT

Patch0: %name-4.10.0-alt-pkgname.patch
Patch1: %name-4.5.0-alt-pamconf.patch
Patch2: %name-3.0.8-alt-quotawarn.patch
Patch3: %name-4.10.0-alt-config.patch
Patch4: %name-4.5.0-alt-shareddir.patch
Patch5: %name-4.4.1-alt-makefile.patch
Patch6: %name-4.4.1-alt-configure.patch

BuildPreReq: libcourier-authlib-devel = 0.63.0

# Automatically added by buildreq on Sun Apr 27 2008
BuildRequires: gcc-c++ libdb4-devel libgamin-devel libkrb5-devel libpcre-devel libssl-devel openssl libpam-devel pam-config libidn-devel

%description
Courier-IMAP is an IMAP server for Maildir mailboxes.  This package contains
the standalone version of the IMAP server that's included in the Courier
mail server package.  This package is a customized version for use with
other mail servers.


%package utils
Summary: Maildir utilities
Group: Networking/Mail
Provides: courier-common-utils
Requires: courier-authlib
Conflicts: maildrop-utils
Conflicts: courier-maildrop-utils

%description utils
Some common maildir utilities for courier-maildrop
and courier-imap packages.

%prep
%setup -q -n %name-%version%rev
%patch0 -p2 -b .p0
%patch1 -p1 -b .p1
%patch2 -p1 -b .p2
%patch3 -p2 -b .p3
%patch4 -p2 -b .p4
%patch5 -p1 -b .p5
%patch6 -p1 -b .p6

%build
#libtoolize --force --install
%configure \
    --enable-unicode \
    --with-userdb=%_sysconfdir/%name/userdb \
    --with-makedatprog=%_datadir/%name/makedatprog \
    --with-db=db \
    --with-certsdir=%_localstatedir/ssl/private \
    --with-certdb=%_datadir/ca-certificates/ca-bundle.crt \
    --with-piddir=%courier_piddir \
    --without-ipv6 \
    --with-redhat

%make_build

%install

# adjust $RPM_BUILD for install
%__mkdir_p %buildroot/%_sysconfdir/pam.d
%__mkdir_p %buildroot/%_initdir
%__mkdir_p %buildroot/%_localstatedir/%name
touch %buildroot/%_localstatedir/%name/couriersslcache

%__make DESTDIR=%buildroot install

# tune configfiles
for i in `ls %buildroot/%_sysconfdir/%name/*.dist | %__sed -e 's/\.dist//'`; do
	%__mv $i.dist $i
done

# install configs and inint scripts
%__install -m 0755 %SOURCE1 %buildroot/%_initdir/courier-imapd
%__install -m 0755 %SOURCE2 %buildroot/%_initdir/courier-imaps
%__install -m 0755 %SOURCE3 %buildroot/%_initdir/courier-pop3d
%__install -m 0755 %SOURCE4 %buildroot/%_initdir/courier-pop3s

%__mkdir_p -m 0755 %buildroot%_pemdir
touch %buildroot%_pemdir/imapd.pem
touch %buildroot%_pemdir/pop3d.pem

%__mv %buildroot/%_sysconfdir/%name/quotawarnmsg.example %buildroot/%_sysconfdir/%name/quotawarnmsg

# root src documentation
%__mkdir_p %buildroot/%_docdir/%name-%version/html
%__install -m 0644 %SOURCE7 %buildroot/%_docdir/%name-%version/README-ALT.koi8-r
%__install -m 0644 AUTHORS %buildroot/%_docdir/%name-%version
%__install -m 0644 INSTALL %buildroot/%_docdir/%name-%version
%__install -m 0644 NEWS    %buildroot/%_docdir/%name-%version
%__install -m 0644 README  %buildroot/%_docdir/%name-%version
%__install -m 0644 INSTALL.html %buildroot/%_docdir/%name-%version/html
%__install -m 0644 NEWS.html    %buildroot/%_docdir/%name-%version/html

# imap documentation
%__install -m 0644 imap/BUGS      %buildroot/%_docdir/%name-%version
%__install -m 0644 imap/ChangeLog %buildroot/%_docdir/%name-%version
%__install -m 0644 imap/README    %buildroot/%_docdir/%name-%version/README.imap
%__install -m 0644 imap/README.proxy %buildroot/%_docdir/%name-%version
%__install -m 0644 imap/BUGS.html    %buildroot/%_docdir/%name-%version/html
%__install -m 0644 imap/courierpop3d.html %buildroot/%_docdir/%name-%version/html
%__install -m 0644 imap/README.html       %buildroot/%_docdir/%name-%version/html/README.imap.html
%__install -m 0644 imap/README.proxy.html %buildroot/%_docdir/%name-%version/html

# maildir documentation
%__install -m 0644 maildir/README.maildirquota.txt  %buildroot/%_docdir/%name-%version
%__install -m 0644 maildir/README.sharedfolders.txt %buildroot/%_docdir/%name-%version
%__install -m 0644 maildir/maildiracl.html %buildroot/%_docdir/%name-%version/html
%__install -m 0644 maildir/maildir.html    %buildroot/%_docdir/%name-%version/html
%__install -m 0644 maildir/maildirkw.html  %buildroot/%_docdir/%name-%version/html
%__install -m 0644 maildir/maildirmake.html  %buildroot/%_docdir/%name-%version/html
%__install -m 0644 maildir/maildirquota.html %buildroot/%_docdir/%name-%version/html
%__install -m 0644 maildir/README.imapkeywords.html  %buildroot/%_docdir/%name-%version/html
%__install -m 0644 maildir/README.maildirfilter.html %buildroot/%_docdir/%name-%version/html
%__install -m 0644 maildir/README.maildirquota.html  %buildroot/%_docdir/%name-%version/html
%__install -m 0644 maildir/README.sharedfolders.html %buildroot/%_docdir/%name-%version/html

# tcpd documentation
%__install -m 0644 tcpd/README.couriertls %buildroot/%_docdir/%name-%version

%post
# adjust config for generating SSL certs
HOSTNAME=`hostname -f`
for i in `ls %_sysconfdir/%name/*.cnf`; do
   %__subst "s|^CN=.*$|CN=$HOSTNAME|g;s|^emailAddress=.*$|emailAddress=root@$HOSTNAME|g" $i
done

%__subst "s|__HOSTNAME__|$HOSTNAME|g" %_sysconfdir/%name/quotawarnmsg

# try to update configs from .rpmsave
for i in imapd pop3d; do
	if [ -f %_sysconfdir/%name/$i.rpmsave ]; then
		. %_sysconfdir/%name/$i.rpmsave
		%__subst "s|^ADDRESS=127.0.0.1|ADDRESS=$ADDRESS|" %_sysconfdir/%name/$i
	fi
done
for i in imapd-ssl pop3d-ssl; do
	if [ -f %_sysconfdir/%name/$i.rpmsave ]; then
		. %_sysconfdir/%name/$i.rpmsave
		%__subst "s|^SSLADDRESS=127.0.0.1|SSLADDRESS=$SSLADDRESS|" %_sysconfdir/%name/$i
	fi
done

%post_service courier-imapd
%post_service courier-pop3d
%post_service courier-imaps
%post_service courier-pop3s
 
%preun
%preun_service courier-imapd
%preun_service courier-imaps
%preun_service courier-pop3d
%preun_service courier-pop3s

%files
%dir %_sysconfdir/%name
%dir %_datadir/%name
%_initdir/courier-imapd
%_initdir/courier-imaps
%_initdir/courier-pop3d
%_initdir/courier-pop3s
%config %_sysconfdir/%name/imapd
%config %_sysconfdir/%name/pop3d
%config %_sysconfdir/%name/imapd-ssl
%config %_sysconfdir/%name/pop3d-ssl
%config(noreplace) %_sysconfdir/pam.d/imap
%config(noreplace) %_sysconfdir/pam.d/pop3
%config(noreplace) %_sysconfdir/%name/imapd.cnf
%config(noreplace) %_sysconfdir/%name/pop3d.cnf
%_sysconfdir/%name/quotawarnmsg
%_bindir/maildiracl
%_bindir/maildirkw
%_sbindir/couriertcpd
%_sbindir/couriertls
%_sbindir/imapd
%_sbindir/imaplogin
%_sbindir/makedatprog
%_sbindir/pop3d
%_sbindir/pop3login
%_sbindir/sharedindexinstall
%_sbindir/sharedindexsplit
%_libexecdir/%name/*.rc
%_man1dir/couriertcpd.1*
%_man1dir/maildiracl.1*
%_man1dir/maildirkw.1*
%_man8dir/imapd.8*
%dir %_docdir/%name-%version
%doc %_docdir/%name-%version/*
%ghost %attr(0640,root,root) %config(noreplace,missingok) %_pemdir/imapd.pem
%ghost %attr(0640,root,root) %config(noreplace,missingok) %_pemdir/pop3d.pem
%dir %_localstatedir/%name
%dir %_localstatedir/%name/shared
%dir %_localstatedir/%name/shared.tmp
%ghost %attr(0644,root,root) %_localstatedir/%name/couriersslcache

%files utils
%_bindir/deliverquota
%_bindir/maildirmake
%_man1dir/maildirmake.1.*
%_man8dir/deliverquota.8.*

%changelog
