%define courier_confdir	/etc/courier-imap
%define courier_datadir	%_datadir/courier-imap
%define confldap maildrop-ldap.conf
%define confmysql maildrop-mysql.conf

%define rev %nil
%define origname maildrop

Name: courier-maildrop
Version: 2.5.5
Release: alt0.1

Summary: maildrop mail filter/mail delivery agent
License: GPL
Group: Networking/Mail
Url: http://www.flounder.net/~mrsam/maildrop

Requires: courier-authlib
Requires: courier-common-utils
Provides:  maildrop-common = %version-%release
Obsoletes: maildrop-common < %version-%release

Source0: %url/%origname-%version.tar.bz2
Source1: %origname.README-ALT

Patch1: %origname-2.1.0-alt-makefile.patch

BuildPreReq: libcourier-authlib-devel = 0.63.0

# Automatically added by buildreq on Sun Nov 27 2005
BuildRequires: gcc-c++ libdb4-devel libfam-devel libpcre-devel libstdc++-devel

%description
Maildrop - mail delivery agent with filtering capabilities and
Maildir/Mailbox format support.

%package utils
Summary: Maildir utilities
Group: Networking/Mail
Provides: courier-common-utils
Requires: courier-authlib
Conflicts: maildrop-utils
Conflicts: courier-imap-utils

%description utils
Some common maildir utilities for courier-maildrop
and courier-imap packages.

%prep
%setup -q -n %origname-%version
%patch1 -p2

%build
%__autoconf
%configure \
  --sysconfdir=%courier_confdir \
  --with-etcdir=%courier_confdir \
  --enable-sendmail=/usr/sbin/sendmail \
  --enable-restrict-trusted=0 \
  --enable-trusted-groups='root daemon mail postfix' \
  --enable-trusted-users='root daemon mail postfix' \
  --enable-syslog=1 \
  --enable-use-dotlock=0 \
  --enable-use-flock=0 \
  --with-db=db \
  --disable-tempdir \
  --enable-maildirquota

%make_build

%install
%__make DESTDIR=%buildroot install

# adjust documentation 
%__mkdir_p %buildroot/%_docdir/%name-%version
%__mv %buildroot/%_datadir/%origname/html %buildroot/%_docdir/%name-%version
%__rm -rf %buildroot/%_datadir/%origname

# src_root docs
%__install -m 0644 %SOURCE1       %buildroot/%_docdir/%name-%version/
%__install -m 0644 AUTHORS        %buildroot/%_docdir/%name-%version/
%__install -m 0644 ChangeLog      %buildroot/%_docdir/%name-%version/
%__install -m 0644 INSTALL        %buildroot/%_docdir/%name-%version/
%__install -m 0644 NEWS           %buildroot/%_docdir/%name-%version/
%__install -m 0644 README         %buildroot/%_docdir/%name-%version/
%__install -m 0644 README.postfix %buildroot/%_docdir/%name-%version/
%__install -m 0644 UPGRADE        %buildroot/%_docdir/%name-%version/

%__install -m 0644 INSTALL.html %buildroot/%_docdir/%name-%version/html/
%__install -m 0644 README.html  %buildroot/%_docdir/%name-%version/html/
%__install -m 0644 UPGRADE.html %buildroot/%_docdir/%name-%version/html/

#maildir docs
%__install -m 0644 maildir/README.maildirquota.txt  %buildroot/%_docdir/%name-%version/
%__install -m 0644 maildir/README.sharedfolders.txt %buildroot/%_docdir/%name-%version/

%__install -m 0644 maildir/maildiracl.html   %buildroot/%_docdir/%name-%version/html/
%__install -m 0644 maildir/maildirkw.html    %buildroot/%_docdir/%name-%version/html/
%__install -m 0644 maildir/maildirmake.html  %buildroot/%_docdir/%name-%version/html/
%__install -m 0644 maildir/maildirquota.html %buildroot/%_docdir/%name-%version/html/
%__install -m 0644 maildir/README.imapkeywords.html  %buildroot/%_docdir/%name-%version/html/
%__install -m 0644 maildir/README.maildirfilter.html %buildroot/%_docdir/%name-%version/html/
%__install -m 0644 maildir/README.maildirquota.html  %buildroot/%_docdir/%name-%version/html/
%__install -m 0644 maildir/README.sharedfolders.html %buildroot/%_docdir/%name-%version/html/

# maildrop docs
%__install -m 0644 maildrop/README.html       %buildroot/%_docdir/%name-%version/html/README.maildrop.html
%__install -m 0644 maildrop/maildroptips.html %buildroot/%_docdir/%name-%version/html/
%__install -m 0644 maildrop/makedat.html      %buildroot/%_docdir/%name-%version/html/
%__install -m 0644 maildrop/reformail.html    %buildroot/%_docdir/%name-%version/html/

%files
%_bindir/lockmail
%_bindir/mailbot
%_bindir/maildrop
%_bindir/makemime
%_bindir/reformail
%_bindir/reformime
%_man1dir/lockmail.1*
%_man1dir/mailbot.1*
%_man1dir/maildrop.1*
%_man1dir/makemime.1*
%_man1dir/reformail.1*
%_man1dir/reformime.1*
%_man5dir/maildir.5*
%_man7dir/maildirquota.7*
%_man7dir/maildropex.7*
%_man7dir/maildropfilter.7*
%_man7dir/maildropgdbm.7*
%dir %_docdir/%name-%version
%_docdir/%name-%version/*

%files utils
%_bindir/maildirmake
%_bindir/deliverquota
%_man1dir/maildirmake.1*
%_man8dir/deliverquota.8*

%changelog
