%define branch_point alt0
%define branch M80P
%define revision 1

# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: cppcheck
Version: 1.82
Release: %branch_point.%branch.%revision.1
Summary: A tool for static C/C++ code analysis

License: GPLv3
Group: Development/Tools
Url:  git://github.com/danmar/cppcheck.git

Source: %name-%version.tar
Patch1: cppcheck-makefile-docbook_xsl-1.70.patch
Patch2: cppcheck-1.78-norebuild.patch
Patch3: cppcheck-1.82-appPath.patch
Patch4: cppcheck-1.72-test_32.patch

BuildRequires(pre): rpm-macros-qt5

# Automatically added by buildreq on Sat Jan 20 2018
# optimized out: docbook-dtds fontconfig gcc-c++ libGL-devel libgpg-error libqt5-core libqt5-gui libqt5-printsupport libqt5-widgets libqt5-xml libstdc++-devel pkg-config python-base python-modules python-modules-compiler python-modules-encodings qt5-base-common xml-common
BuildRequires: ImageMagick-tools docbook-style-xsl libpcre-devel qt5-base-devel qt5-tools xsltproc

%description
Static analysis of C/C++ code. Checks for: memory leaks, mismatching
allocation-deallocation, buffer overrun, and many more. The goal is
0%% false positives.

%package gui
Summary: Qt version of %name, %summary
Group: Development/Tools
Requires: %name = %version-%release
%description gui
%summary

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1

%ifnarch x86_64
%patch4 -p1
%endif

cat > %name.desktop <<@@@
[Desktop Entry]
Type=Application

Exec=%name-gui
Icon=%name
 
Name=CppCheck
Comment=Static analysis of C/C++ code
GenericName=Code analyzer

Categories=Development;Qt;
@@@

for i in 16 24 32 48 64; do
	convert gui/cppcheck-gui.png ${i}.png
done

%build
%define dirs SRCDIR=build CFGDIR=%_datadir/%name/cfg HAVE_RULES=yes INCLUDEPATH="%_includedir/pcre"
%make_build %dirs CPPFLAGS="$(pkg-config --cflags libpcre)"
cd gui
%qmake_qt5 %dirs
lrelease-qt5 gui.pro
%make_build %dirs
cd ..

%make_build man %dirs
%make_build testrunner

# Generate html documentation
for N in man/*.docbook; do
  xsltproc -o ${N%%.docbook}.html \
	/usr/share/xml/docbook/xsl-stylesheets/xhtml/docbook.xsl $N
done

%check
%make_build check

%install
%makeinstall_std %dirs

install -D gui/%name-gui %buildroot%_bindir/%name-gui

install -pD -m 644 %name.1 %buildroot%_man1dir/%name.1

mkdir -p "%buildroot%_datadir/%name/lang"
for N in gui/*.qm; do install -D $N %buildroot%_datadir/%name/lang/`basename $N`; done

# install -D gui/%name.desktop %buildroot%_desktopdir/%name.desktop
install -D gui/%name-gui.desktop %buildroot%_desktopdir/%name.desktop
for i in 64 48 32 24 16; do
	install -D $i.png %buildroot%_iconsdir/hicolor/${i}x${i}/apps/%name-gui.png
done
install -D gui/%name-gui.svg %buildroot%_iconsdir/hicolor/scalable/apps/%name-gui.svg

%files
%doc readme.txt man/*.html
%_bindir/%name

%_bindir/%name-htmlreport
%_bindir/*.py
%_man1dir/%name.1.*
%_datadir/%name/cfg

%files gui
%doc gui/help/manual.html
%_bindir/%name-gui
%exclude %_datadir/%name/cfg
%_datadir/%name
%_desktopdir/*
%_iconsdir/hicolor/*/apps/*

%changelog
