# vim: set ft=spec: -*- rpm-spec -*-

%def_disable docs

Name: cppunit
Version: 1.14.0
Release: alt0.M80P.1

Summary: C++ port of the famous JUnit framework for unit testing
License: LGPL
Group: Development/C++
Url: https://www.freedesktop.org/wiki/Software/cppunit/

Source: %name-%version.tar.gz

# Automatically added by buildreq on Thu Oct 05 2006
BuildRequires: doxygen gcc-c++ graphviz

%description
CppUnit is the C++ port of the famous JUnit framework for unit
testing.

%package devel
Summary: C++ port of the famous JUnit framework for unit testing
Group: Development/C++
Requires: %name = %version-%release
Obsoletes: %name-gcc2-devel, %name-gcc3-devel, %name-common-devel
Provides: %name-gcc2 = %version-%release, %name-gcc3 = %version-%release, %name-common-devel = %version-%release

%description devel
CppUnit is the C++ port of the famous JUnit framework for unit
testing.

%package devel-docs
Summary: Documentation for CppUnit
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version-%release

%description devel-docs
CppUnit is the C++ port of the famous JUnit framework for unit
testing.

This package contains development documentation for CppUnit.

%prep
%setup

%build
%autoreconf
#./autogen.sh
%configure \
	--disable-static \
	--docdir=%_docdir/%name-%version
%make_build

%install
%makeinstall_std

%check
make check

%files
%_libdir/lib*.so.*

%files devel
%doc %_docdir/%name-%version/*
%_bindir/*
%_includedir/cppunit/
%_libdir/lib*.so
#_datadir/aclocal/*
#_man1dir/*
%_pkgconfigdir/%name.pc

%if_enabled docs
%files devel-docs
%_datadir/%name
%endif

%changelog
