%def_disable static
%def_enable acpi
%def_enable nforce2
%def_enable apm
%def_enable sensors
%def_enable pmu
%def_enable exec
%def_enable tau


Summary: CPU frequency scaling daemon
Name: cpufreqd
Version: 2.4.3
Release: alt2
Url: http://sourceforge.net/projects/cpufreqd/
License: GPLv2
Group: System/Kernel and hardware
Packager: Alexey Shabalin <shaba@altlinux.ru>

Source0: %name-%version.tar
Source1: %name.init.alt
Source2: %name.service
Patch0: %name-%version-%release.patch

BuildRequires: gcc-c++ libcpufreq-devel libsysfs-devel
%{?_enable_sensors:BuildRequires: libsensors3-devel}
Requires: cpufrequtils

%description
Cpufreqd is meant to be a replacement of the speedstep applet you
can find on some other OS, it monitors battery level, AC state and
running programs and adjusts the frequency of the processor according to
a set of rules specified in the config file (see cpufreqd.conf (5)).

Cpufreqd 2 aims to become the next generation power management
daemon. It provides a common interface to enable system monitoring
and to take useful actions upon that.
Currently it is still centered on the CPUFreq kernel interface,
that means that running a CPUFreq capable kernel is still needed but
also that behaviour could be delegated to a plugin.

Note that the configuration file format is slightly incompatible
with the previous cpufreqd 1 but it's really easy to migrate (a
simple Perl script could do it, I'll try to prepare one soon).

%prep
%setup -q
%patch0 -p1

%build
%__aclocal
%__libtoolize -c -f
%__aclocal
%__autoconf
%__automake -a -c --foreign

%configure \
	%{subst_enable static} \
	%{subst_enable acpi} \
	%{subst_enable nforce2} \
	%{subst_enable apm} \
	%{subst_enable sensors} \
	%{subst_enable pmu} \
	%{subst_enable exec} \
	--enable-governor-parameters \
	%{subst_enable tau} \
	--libdir=%_libdir/%name
# libdir need only for plugins

%make_build

%install
%make DESTDIR=%buildroot install

install -d %buildroot{%_initdir,%systemd_unitdir}
install %SOURCE1 %buildroot%_initdir/%name
install %SOURCE2 %buildroot%systemd_unitdir/%name.service

# remove non-packaged files 
rm -f %buildroot%_libdir/%name/*.la

%post
%post_service cpufreqd

%preun
%preun_service cpufreqd

%files
%doc AUTHORS COPYING INSTALL README NEWS TODO ChangeLog
%_sbindir/*
%_bindir/*
%dir %_libdir/cpufreqd
%_libdir/cpufreqd/*.so
%attr(644,root,root) %config(noreplace) %_sysconfdir/%name.conf
%_initdir/%name
%systemd_unitdir/%name.service
%_mandir/man?/*

%changelog
