# -*- coding: utf-8; mode: rpm-spec -*-
# $Id: crossfire-maps-bigworld.spec,v 1.2 2006/07/15 15:55:25 eugene Exp $

%define maps_name maps-bigworld
%define maps_version 1.11.0
%define maps_release alt1

Name: crossfire-%maps_name
Version: %maps_version
Release: %maps_release.qa1.1.1
Summary: Bigworld maps for crossfire
Summary(ru_RU.UTF-8): Карты большого мира для crossfire
Group: Games/Adventure
License: GPL
Url: http://crossfire.real-time.com

Packager: Eugene Vlasov <eugvv@altlinux.ru>

BuildArch: noarch

Requires: crossfire
Provides: crossfire-maps

%add_python_req_skip CFBank CFBoard CFGamble CFGuilds CFCampfire CFLog
%add_python_req_skip CFItemBroker CFMail Crossfire CFWorld Crossfire_Type

Source0: crossfire-%version.maps.tar.bz2
Source1: %name.alternatives

Patch0: maps-1.11-python_syntax_fix.patch

# Automatically added by buildreq on Fri Mar 10 2006
BuildRequires: alternatives

%description
crossfire is a multiplayer graphical arcade and adventure game made for
the X-Windows environment.  It runs on a client/server model.
The client runs with X11, GTK, or  SDL within a gtk window.

It has certain flavours from other games, especially Gauntlet (TM)
and Nethack/Moria.

Any number of players can move around in their own window, finding
and using items and battle monsters.  They can choose to cooperate
or compete in the same "world".

This package contains bigworld maps for crossfire server.

%description -l ru_RU.UTF-8
crossfire - многопользовательская графическая аркадная и
приключенческая игра, работающая в среде X-Windows. Делится на
клиентскую и серверную части. Доступны клиентские части с интерфейсом
X11, GTK, или SDL (в окне gtk).

Игра разработана под влиянием некоторых других игр, особенно Gauntlet
(TM) и Nethack/Moria.

Любое количество игроков может перемещатся в созданном ими мире,
находить и использовать предметы, уничтожать монстров. Игроки могут
сотрудничать или конкурировать в пределах одного "мира"

Этот пакет содержит карты большого мира для сервера crossfire.

%prep
%setup -q -c maps
%patch0 -p0

%install
mkdir -p %buildroot%_altdir
install -p -m644 %SOURCE1 %buildroot%_altdir/%name
mkdir -p %buildroot%_gamesdatadir/crossfire/%maps_name
cp -R maps/* %buildroot%_gamesdatadir/crossfire/%maps_name
cp maps/.emergency %buildroot%_gamesdatadir/crossfire/%maps_name
mkdir -p %buildroot%_localstatedir/games/crossfire/players-%maps_name

%files
%_gamesdatadir/crossfire/%maps_name/
%_altdir/%name
%dir %attr(775, games, games) %_localstatedir/games/crossfire/players-%maps_name


%changelog
