Name: cups
Version: 2.1.0
Release: alt2.M80P.4

Summary: Common Unix Printing System - server package
License: GPL
Group: System/Servers

Url: http://www.cups.org

Source: http://www.cups.org/software/%version/cups-%version-source.tar.bz2

# READMEs
Source10: README.alt
Source11: README.patches

# MISC
Source20: cups.control
Source21: cups.startup

# support
Source95: repatch_spec.unused
Source96: repatch_spec.sh
Source97: alt_ru.po
Source98: pofix.py

## FC patches
Patch1: FC-no-gzip-man.patch
Patch2: FC-system-auth.patch
Patch3: FC-multilib.patch
Patch4: FC-banners.patch
Patch5: FC-serverbin-compat.patch
Patch6: FC-no-export-ssllibs.patch
Patch7: FC-direct-usb.patch
Patch8: FC-lpr-help.patch
Patch9: FC-peercred.patch
Patch10: FC-pid.patch
Patch11: FC-eggcups.patch
Patch12: FC-driverd-timeout.patch
Patch13: FC-strict-ppd-line-length.patch
Patch14: FC-logrotate.patch
Patch15: FC-usb-paperout.patch
Patch16: FC-res_init.patch
Patch17: FC-filter-debug.patch
Patch18: FC-uri-compat.patch
Patch19: FC-str3382.patch
Patch20: FC-0755.patch
Patch21: FC-hp-deviceid-oid.patch
Patch22: FC-dnssd-deviceid.patch
Patch23: FC-ricoh-deviceid-oid.patch
Patch24: FC-systemd-socket.patch
Patch25: FC-avahi-address.patch
Patch26: FC-enum-all.patch
Patch27: FC-dymo-deviceid.patch
Patch28: FC-freebind.patch
Patch29: FC-no-gcry.patch
Patch30: FC-libusb-quirks.patch
Patch31: FC-use-ipp1.1.patch
Patch32: FC-avahi-no-threaded.patch
Patch33: FC-ipp-multifile.patch
Patch34: FC-web-devices-timeout.patch
Patch35: FC-synconclose.patch
Patch36: FC-lspp.patch

## Ubuntu patches
Patch101: Ubuntu-usb-backend-fix-infinite-loop-when-usblp-module-attached.patch
Patch102: Ubuntu-usb-backend-delayed-closing-for-old-laserjets.patch
Patch103: Ubuntu-fix-ppd-file-load-for-ipp-printers.patch
Patch104: Ubuntu-pwg-raster-attributes.patch
Patch105: Ubuntu-manpage-hyphen-minus.patch
Patch106: Ubuntu-rootbackends-worldreadable.patch
Patch107: Ubuntu-fixes-for-jobs-with-multiple-files-and-multiple-formats.patch
Patch108: Ubuntu-cupsd-upstart-support.patch
Patch109: Ubuntu-tests-ignore-warnings.patch
Patch110: Ubuntu-tests-ignore-usb-crash.patch
Patch111: Ubuntu-tests-ignore-kfreebsd-amd64-not-a-pdf.patch
Patch112: Ubuntu-tests-ignore-system-bus-failure.patch
Patch113: Ubuntu-tests-ignore-ipv6-address-family-not-supported.patch
Patch114: Ubuntu-test-i18n-nonlinux.patch
Patch115: Ubuntu-tests-wait-on-unfinished-jobs-everytime.patch
Patch116: Ubuntu-tests-fix-ppdLocalize-on-unclean-env.patch
Patch117: Ubuntu-tests-use-cupsfilters.patch
Patch118: Ubuntu-tests-fix-mips-getjobs.patch
Patch119: Ubuntu-tests-use-ipv4-lo-address.patch
Patch120: Ubuntu-move-cupsd-conf-default-to-share.patch
Patch121: Ubuntu-drop_unnecessary_dependencies.patch
Patch122: Ubuntu-read-embedded-options-from-incoming-postscript-and-add-to-ipp-attrs.patch
Patch123: Ubuntu-deviced-allow-device-ids-with-newline.patch
Patch124: Ubuntu-airprint-support.patch
Patch125: Ubuntu-snmp-oids-device-id-hp-ricoh.patch
Patch126: Ubuntu-no-conffile-timestamp.patch
Patch127: Ubuntu-pidfile.patch
Patch128: Ubuntu-ppd-poll-with-client-conf.patch
Patch129: Ubuntu-removecvstag.patch
Patch130: Ubuntu-rename-systemd-units.patch
Patch131: Ubuntu-do-not-broadcast-with-hostnames.patch
Patch132: Ubuntu-reactivate_recommended_driver.patch
Patch133: Ubuntu-add-ipp-backend-of-cups-1.4.patch
Patch134: Ubuntu-logfiles_adm_readable.patch
Patch135: Ubuntu-default_log_settings.patch
Patch136: Ubuntu-confdirperms.patch
Patch137: Ubuntu-printer-filtering.patch
Patch138: Ubuntu-show-compile-command-lines.patch
Patch139: Ubuntu-ppdc-dynamic-linking.patch
Patch140: Ubuntu-log-debug-history-nearly-unlimited.patch
Patch141: Ubuntu-cupsd-set-default-for-SyncOnClose-to-Yes.patch
Patch142: Ubuntu-man-cups-lpd-drop-dangling-references.patch
Patch143: Ubuntu-debianize_cups-config.patch
Patch144: Ubuntu-manpage-translations.patch

## ALT patches
Patch500: ALT-1.6.1-hardening.patch
Patch501: ALT-build_po.patch
Patch502: ALT-remove_BSD.patch
Patch503: ALT-enable-631.patch
Patch504: ALT-1.6.2-lpd-utf8.patch
Patch505: ALT-1.4.6-config-libs.patch
Patch506: ALT-1.6.2-lspp-SE.patch
Patch507: ALT-1.7.0-docroot-i18n.patch
Patch508: ALT-644.patch
Patch509: ALT-1.7.2-local_ipv6.patch
Patch510: ALT-config-nolibs.patch
Patch511: ALT-pwg-raster-attributes.patch
Patch512: ALT-ipp-alt-extension-copy-document.patch
Patch513: ALT-lspp-context+no-filename.patch
Patch514: ALT-2.1.0-lpd-sanitizer.patch

## Provides
Provides: %name-ppd = %version %name-common = %version
Provides: cups-libs = %version

## External dependencies
Requires: printer-testpages bc cups-filters

# Automatically added by buildreq on Tue Dec 24 2013
# optimized out: libcom_err-devel libkrb5-devel libstdc++-devel libsystemd-daemon pkg-config
BuildRequires: gcc-c++ libacl-devel libaudit-devel libavahi-devel libdbus-devel libpam-devel libpaper-devel libselinux-devel libssl-devel libsystemd-daemon-devel systemd-devel libusb-devel xdg-utils zlib-devel

BuildRequires: dbus python python-module-polib

%description
The Common Unix Printing System provides a portable printing layer for
UNIX(TM) operating systems. It has been developed by Easy Software Products
to promote a standard printing solution for all UNIX vendors and users.
CUPS provides the System V and Berkeley command-line interfaces.

This is the main package needed for CUPS servers (machines where a
printer is connected to or which host a queue for a network
printer). It can also be used on CUPS clients so that they simply pick
up broadcasted printer information from other CUPS servers and do not
need to be assigned to a specific CUPS server by an
/etc/cups/client.conf file.

%package ipptool
Summary: Common Unix Printing System - tool for performing IPP requests
Group: System/Servers
License: GPL

%description ipptool
Sends IPP requests to the specified URI and tests and/or displays the results.

%package -n lib%name
Summary: Common Unix Printing System - CUPS library
License: LGPL
Group: System/Servers

%description -n lib%name
The Common Unix Printing System provides a portable printing layer for
UNIX(TM) operating systems. This package contains the CUPS API library
which contains common functions used by both the CUPS daemon and all
CUPS frontends (lpr-cups, xpp, qtcups, kups, ...).

%package -n lib%name-devel
Summary: Common Unix Printing System - Development environment "libcups"
License: LGPL
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version %name-ddk = %version

%description -n lib%name-devel
The Common Unix Printing System provides a portable printing layer for
UNIX(TM) operating systems. This is the development package for
creating additional printer drivers, printing software, and other CUPS
services using the main CUPS library "libcups".


%prep
%setup

## FC apply patches
%patch1 -p1 -b .no-gzip-man
%patch2 -p1 -b .system-auth
#patch3 -p1 -b .multilib
%patch4 -p1 -b .banners
#patch5 -p1 -b .serverbin-compat
%patch6 -p1 -b .no-export-ssllibs
%patch7 -p1 -b .direct-usb
%patch8 -p1 -b .lpr-help
%patch9 -p1 -b .peercred
%patch10 -p1 -b .pid
%patch11 -p1 -b .eggcups
%patch12 -p1 -b .driverd-timeout
%patch13 -p1 -b .strict-ppd-line-length
%patch14 -p1 -b .logrotate
%patch15 -p1 -b .usb-paperout
%patch16 -p1 -b .res_init
%patch17 -p1 -b .filter-debug
#patch18 -p1 -b .uri-compat
%patch19 -p1 -b .str3382
%patch20 -p1 -b .0755
%patch21 -p1 -b .hp-deviceid-oid
%patch22 -p1 -b .dnssd-deviceid
%patch23 -p1 -b .ricoh-deviceid-oid
%patch24 -p1 -b .systemd-socket
%patch25 -p1 -b .avahi-address
%patch26 -p1 -b .enum-all
%patch27 -p1 -b .dymo-deviceid
%patch28 -p1 -b .freebind
%patch29 -p1 -b .no-gcry
%patch30 -p1 -b .libusb-quirks
%patch31 -p1 -b .use-ipp1.1
%patch32 -p1 -b .avahi-no-threaded
%patch33 -p1 -b .ipp-multifile
%patch34 -p1 -b .web-devices-timeout
%patch35 -p1 -b .synconclose
%patch36 -p1 -b .lspp

## Ubuntu apply patches
%patch101 -p1
%patch102 -p1
%patch103 -p1
#patch104 -p1
##patch105 -p1
%patch106 -p1
#patch107 -p1
#patch108 -p1
%patch109 -p1
%patch110 -p1
%patch111 -p1
%patch112 -p1
%patch113 -p1
%patch114 -p1
%patch115 -p1
%patch116 -p1
%patch117 -p1
%patch118 -p1
%patch119 -p1
%patch120 -p1
#patch121 -p1
%patch122 -p1
%patch123 -p1
%patch124 -p1
##patch125 -p1
%patch126 -p1
%patch127 -p1
%patch128 -p1
%patch129 -p1
%patch130 -p1
%patch131 -p1
%patch132 -p1
%patch133 -p1
#patch134 -p1
%patch135 -p1
%patch136 -p1
%patch137 -p1
%patch138 -p1
##patch139 -p1
%patch140 -p1
#patch141 -p1
##patch142 -p1
#patch143 -p1
##patch144 -p1

## ALT apply patches
##patch500 -p1
%patch501 -p1
%patch502 -p1
%patch503 -p1
%patch504 -p1
#patch505 -p1
%patch506 -p1
%patch507 -p1
%patch508 -p1
%patch509 -p1
%patch510 -p1
%patch511 -p1
%patch512 -p1
%patch513 -p1
%patch514 -p2

# make some temporary hacks
sed -i 's/EndComments comment."/EndComments comment.\\n"/' systemv/cupstestdsc.c

cp %SOURCE98 %SOURCE97 %SOURCE10 %SOURCE11 .
cp %SOURCE21 scheduler/cups.sh.in

# TODO help translation injecting

%build

aclocal -I config-scripts
autoconf -I config-scripts

%configure \
   --with-icondir=%_iconsdir \
   --with-menudir=%_desktopdir \
   --with-xinetd=%_sysconfdir/xinetd.d \
   --enable-relro \
   --enable-dbus \
   --enable-libusb \
   --with-cups-user=lp \
   --with-cups-group=lp \
   --with-log-file-perm=0600 \
   --with-docdir=%_docdir/%name \
   --with-rcdir=%_initdir/.. \
   --localstatedir=%_var \
   --enable-avahi \
   --with-local_protocols='dnssd' \
   --enable-lspp \
   --enable-libpaper \
   --enable-debug

%make_build

(
cd locale
make pot
mv cups_ru.po cups_old_ru.po
msgmerge cups_old_ru.po cups.pot -C ../alt_ru.po -o cups_ru.po
python ../pofix.py cups_ru.po
)

%install
make BUILDROOT=%buildroot install

# fixup funny org.cups.*.* names
( cd %buildroot%_unitdir;
for f in *; do
  case "$f" in
    org.cups.cupsd.*) ln -s "$f" cups."${f##*.}";;
    org.cups.*) ln -s "$f" "${f/org.cups./}";;
  esac;
done;
echo "###"; ls
)

### install non-upstream files
install -D scheduler/cups-lpd.xinetd %buildroot%_sysconfdir/xinetd.d/cups-lpd
install -Dpm 755 %SOURCE20 %buildroot%_controldir/%name

alternate() { # priority files \
p="$1"; shift; \
for f; do \
  case "$f" in \
  	*/sbin/*) man=8;; \
  	*/bin/*) man=1;; \
	*/etc/*|*/share/*) man=5;; \
	*) man=6;; \
  esac; \
  mp="%_mandir/man$man"; \
  n="$(basename "$f")"; fa="$f-%name"; m="$mp/$n.$man"; ma="$mp/$n-%name.$man"; \
  /bin/echo -e "$f $fa $p\n$m.gz $ma.gz $fa"; \
  mv "%buildroot$f" "%buildroot$fa"; mv "%buildroot$m" "%buildroot$ma"; \
done }

alternate 10 \
	/usr/bin/lpr \
	/usr/bin/lpq \
	/usr/bin/lprm \
	/usr/bin/lp \
	/usr/bin/cancel \
	/usr/bin/lpstat \
	/usr/sbin/lpc > %name.alternative

install -D %name.alternative %buildroot%_altdir/%name

%post
%post_service cups

%preun
%preun_service cups

%files
%doc README*
%_docdir/%name
%config(noreplace) %_sysconfdir/%name
%config(noreplace) %attr(0640,root,lp) %_sysconfdir/%name/snmp.conf
%config(noreplace) %_sysconfdir/xinetd.d/%name-lpd
%config(noreplace) %_sysconfdir/pam.d/%name
%config(noreplace) %_sysconfdir/dbus-1/system.d/*
%_controldir/%name
%_unitdir/*
%_initdir/%name
%_prefix/lib/%name
%_man1dir/*
%_man5dir/*
%_man8dir/*
%_man7dir/*

%_datadir/%name
%_datadir/locale/*/*.po
%_sbindir/*
%_bindir/*
%_altdir/%name

%_iconsdir/hicolor/*/apps/*.png
%_desktopdir/%name.desktop

%exclude %_prefix/*/*/*/ipptool*
%exclude %_prefix/*/*/ipptool*
%exclude %_prefix/*/ipptool*
%exclude %_bindir/%name-config
%exclude %_bindir/ppd*
%exclude %_mandir/*/ppd*
%exclude %_datadir/%name/examples
%exclude %_sysconfdir/rc.d/rc*.d

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_bindir/%name-config
%_bindir/ppd*
%_includedir/%name
%_datadir/%name/examples
%_libdir/*.so
%_man1dir/ppd*
%_man5dir/ppd*

%files ipptool
%_bindir/ipptool
%_datadir/cups/ipptool
%_man1dir/ipptool.*

%changelog
