%global _localstatedir %_var
%def_with php
%define php5_extension cups
%define _cups_serverbin %_libexecdir/cups
%global _localstatedir %_var

Name: cups-filters
Version: 1.20.4
Release: alt3.M80P.1

Summary: OpenPrinting CUPS filters and backends
# For a breakdown of the licensing, see COPYING file
# GPLv2:   filters: commandto*, imagetoraster, pdftops, rasterto*,
#                   imagetopdf, pstopdf, texttopdf
#         backends: parallel, serial
# GPLv2+:  filters: textonly, texttops, imagetops
# GPLv3:   filters: bannertopdf
# MIT:     filters: pdftoijs, pdftoopvp, pdftopdf, pdftoraster
License: GPLv2 and GPLv2+ and GPLv3 and MIT
Group: System/Servers

Url: http://www.linuxfoundation.org/collaborate/workgroups/openprinting/pdf_as_standard_print_job_format
Source0: http://www.openprinting.org/download/cups-filters/cups-filters-%version.tar
Source1: %name.watch
Source2: cups-browsed.init
Patch0: %name-alt.patch
Patch1: %name-alt-php-5.4.14-fix.patch
Patch2: %name-braille-indexv4-path.patch
Patch3: %name-alt-build-fix.patch
Patch4: %name-pjl-as-ps.patch

Conflicts: cups < 1.6.1-alt1
Conflicts: ghostscript-cups
Obsoletes: ghostscript-cups
Provides: ghostscript-cups
Obsoletes: foomatic-filters
Provides: foomatic-filters
Conflicts: foomatic-filters

BuildRequires: cups-devel
BuildRequires: libdbus-devel
BuildRequires: libldap-devel
# pdftopdf
BuildRequires: libqpdf-devel
# pdftops
BuildRequires: poppler-utils
BuildRequires: /proc
# pdftoijs, pdftoopvp, pdftoraster
BuildRequires: libpoppler-devel libpoppler-cpp-devel
BuildRequires: libjpeg-devel
BuildRequires: libpng-devel
BuildRequires: libtiff-devel
BuildRequires: gcc-c++
BuildRequires: zlib-devel
BuildRequires: libijs-devel
BuildRequires: glib2-devel
BuildRequires: libgs-devel
BuildRequires: libfreetype-devel
BuildRequires: mupdf
BuildRequires: fontconfig-devel
BuildRequires: liblcms2-devel
%{?_with_php:BuildRequires: php5-devel}
BuildRequires: libgio-devel
BuildRequires: libavahi-devel libavahi-glib-devel
BuildRequires(pre): rpm-build-ubt

# Make sure we get postscriptdriver tags.
BuildRequires: python-module-cups

Requires: poppler-utils
Requires: /usr/bin/gs

%package libs
Summary: OpenPrinting CUPS filters and backends - cupsfilters and fontembed libraries
Group: System/Libraries
# LGPLv2: libcupsfilters
# MIT:    libfontembed
License: LGPLv2 and MIT

%package devel
Summary: OpenPrinting CUPS filters and backends - development environment
Group: Development/C
License: LGPLv2 and MIT
Requires: cups-filters-libs = %version-%release

%description
Contains backends, filters, and other software that was
once part of the core CUPS distribution but is no longer maintained by
Apple Inc. In addition it contains additional filters developed
independently of Apple, especially filters for the PDF-centric printing
workflow introduced by OpenPrinting.

%description libs
This package provides cupsfilters and fontembed libraries.

%description devel
This is the development package for OpenPrinting CUPS filters and backends.

%if_with php
%package -n php5-cups
Epoch: 1
Summary: PHP5 module for the Common Unix Printing System
License: GPL
Group: System/Servers
Requires: php5 = %php5_version
BuildRequires(pre): rpm-build-php5

%description -n php5-cups
PHP5 module for the Common Unix Printing System
%endif

%package -n cups-backend-serial
Epoch: 1
Summary: serial backend for cups
License: GPL
Group: System/Servers

%description -n cups-backend-serial
serial backend for cups

%prep
%setup
%patch0 -p2
%patch1 -p2
%patch2 -p2
%patch3 -p2
%patch4 -p2

%build
# work-around Rpath
./autogen.sh

# --with-pdftops=pdftops - use Poppler instead of Ghostscript (see README)
%configure --disable-static \
           --disable-silent-rules \
	   --without-php \
	   --enable-driverless \
	   --enable-auto-setup-driverless \
	   --with-gs-path=/usr/bin/gs \
           --with-pdftops=pdftops

%make

%if_with php
pushd scripting/php
phpize

BUILD_HAVE=`echo %php5_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir
export LDFLAGS=-lphp-%_php5_version
%configure \
	--with-%php5_extension=%_usr
%php5_make
popd
%endif

%install
%make install DESTDIR=%buildroot
%if_with php
install -D -m 755 scripting/php/.libs/cups.so %buildroot/%php5_extdir/cups.so
install -D -m 644 scripting/php/php-cups.ini %buildroot/%php5_extconf/%php5_extension/config
install -D -m 644 scripting/php/php-cups-params.sh %buildroot/%php5_extconf/%php5_extension/params
%endif
install -D -m 755 %SOURCE2 %buildroot/%_initdir/cups-browsed
mkdir -p %buildroot/%_unitdir/
install -m 644 utils/cups-browsed.service %buildroot/%_unitdir/
ln -sf ../lib/cups/filter/foomatic-rip %buildroot/%_bindir/foomatic-rip

%if_with php
%post -n php5-cups
%php5_extension_postin

%preun -n php5-cups
%php5_extension_preun
%endif

%files
%doc README AUTHORS NEWS
%config(noreplace) %_sysconfdir/cups/cups-browsed.conf
%config(noreplace) %_initdir/cups-browsed
%attr(0755,root,root) %_cups_serverbin/filter/*
%attr(0755,root,root) %_cups_serverbin/driver/*
%attr(0755,root,root) %_cups_serverbin/backend/parallel
%attr(0755,root,root) %_cups_serverbin/backend/beh
%attr(0755,root,root) %_cups_serverbin/backend/implicitclass
%attr(0755,root,root) %_cups_serverbin/backend/driverless
%_datadir/cups/banners
%_datadir/cups/charsets
%_datadir/cups/braille
%_datadir/cups/data/*
%_datadir/cups/ppdc/*
%_datadir/cups/drv/cupsfilters.drv
%_datadir/cups/drv/generic-brf.drv
%_datadir/cups/drv/indexv3.drv
%_datadir/cups/drv/indexv4.drv
%_datadir/cups/mime/braille.types
%_datadir/cups/mime/braille.convs
%_datadir/cups/mime/cupsfilters.types
%_datadir/cups/mime/cupsfilters.convs
%_datadir/cups/mime/cupsfilters-mupdf.convs
%_datadir/cups/mime/cupsfilters-poppler.convs
%_datadir/cups/mime/cupsfilters-ghostscript.convs
%_datadir/ppd/cupsfilters
%_bindir/ttfread
%_bindir/foomatic-rip
%_bindir/driverless
%_sbindir/cups-browsed
%_datadir/man/man*/*
%_unitdir/*

%files -n cups-backend-serial
%attr(0700,root,root) %_prefix/lib/cups/backend/serial

%if_with php
%files -n php5-cups
%php5_extdir/cups.so
%php5_extconf/%php5_extension
%endif

%files libs
%doc COPYING fontembed/README
%attr(0755,root,root) %_libdir/libcupsfilters.so.*
%attr(0755,root,root) %_libdir/libfontembed.so.*

%files devel
%_includedir/cupsfilters
%_includedir/fontembed
%_libdir/pkgconfig/libcupsfilters.pc
%_libdir/pkgconfig/libfontembed.pc
%_libdir/libcupsfilters.so
%_libdir/libfontembed.so

%changelog
